/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.test.synth.TestSynth;

public class Value {
    private int type;
    private Object data;
    private TestSynth config;

    private Value(TestSynth config, int type, Object data) {
        this.config = config;
        this.type = type;
        this.data = data;
    }

    String getSQL() {
        if (this.data == null) {
            return "NULL";
        }
        switch (this.type) {
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return this.data.toString();
            }
            case -1: 
            case 1: 
            case 12: 
            case 1111: 
            case 2005: {
                return "'" + this.data.toString() + "'";
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return this.getBlobSQL();
            }
            case 91: {
                return this.getDateSQL((Date)this.data);
            }
            case 92: {
                return this.getTimeSQL((Time)this.data);
            }
            case 93: {
                return this.getTimestampSQL((Timestamp)this.data);
            }
            case -7: 
            case 16: {
                return (String)this.data;
            }
        }
        throw new Error("type=" + this.type);
    }

    private static Date randomDate(TestSynth config) {
        return config.random().randomDate();
    }

    private static Double randomDouble(TestSynth config) {
        return new Double((double)config.random().getInt(100) / 10.0);
    }

    private static Long randomLong(TestSynth config) {
        return new Long(config.random().getInt(1000));
    }

    private static Time randomTime(TestSynth config) {
        return config.random().randomTime();
    }

    private static Timestamp randomTimestamp(TestSynth config) {
        return config.random().randomTimestamp();
    }

    private String getTimestampSQL(Timestamp ts) {
        String s = "'" + ts.toString() + "'";
        if (this.config.getMode() != 2) {
            s = "TIMESTAMP " + s;
        }
        return s;
    }

    private String getDateSQL(Date date) {
        String s = "'" + date.toString() + "'";
        if (this.config.getMode() != 2) {
            s = "DATE " + s;
        }
        return s;
    }

    private String getTimeSQL(Time time) {
        String s = "'" + time.toString() + "'";
        if (this.config.getMode() != 2) {
            s = "TIME " + s;
        }
        return s;
    }

    private String getBlobSQL() {
        byte[] bytes = (byte[])this.data;
        StringBuffer buff = new StringBuffer("'");
        for (int i = 0; i < bytes.length; ++i) {
            int c = bytes[i] & 0xFF;
            buff.append(Integer.toHexString(c >> 4 & 0xF));
            buff.append(Integer.toHexString(c & 0xF));
        }
        buff.append("'");
        return buff.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static Value read(TestSynth config, ResultSet rs, int index) throws SQLException {
        void var4_5;
        Object data;
        ResultSetMetaData meta = rs.getMetaData();
        int type = meta.getColumnType(index);
        switch (type) {
            case 7: 
            case 8: {
                data = new Double(rs.getDouble(index));
                break;
            }
            case -5: {
                data = new Long(rs.getLong(index));
                break;
            }
            case 2: 
            case 3: {
                data = rs.getBigDecimal(index);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                data = rs.getBytes(index);
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 1111: 
            case 2005: {
                data = rs.getString(index);
                break;
            }
            case 91: {
                data = rs.getDate(index);
                break;
            }
            case 92: {
                data = rs.getTime(index);
                break;
            }
            case 93: {
                data = rs.getTimestamp(index);
                break;
            }
            case 4: {
                data = new Integer(rs.getInt(index));
                break;
            }
            case 0: {
                data = null;
                break;
            }
            case -7: 
            case 16: {
                data = rs.getBoolean(index) ? "TRUE" : "FALSE";
                break;
            }
            default: {
                throw new Error("type=" + type);
            }
        }
        if (rs.wasNull()) {
            data = null;
        }
        return new Value(config, type, var4_5);
    }

    /*
     * WARNING - void declaration
     */
    public static Value getRandom(TestSynth config, int type, int precision, int scale, boolean mayBeNull) {
        void var5_5;
        if (mayBeNull && config.random().getBoolean(20)) {
            return new Value(config, type, null);
        }
        switch (type) {
            case -5: {
                Object data = Value.randomLong(config);
                break;
            }
            case 8: {
                Object data = Value.randomDouble(config);
                break;
            }
            case 3: {
                Object data = Value.randomDecimal(config, precision, scale);
                break;
            }
            case -3: 
            case -2: 
            case 2004: {
                Object data = Value.randomBytes(config, precision);
                break;
            }
            case 12: 
            case 2005: {
                Object data = config.random().randomString(config.random().getInt(precision));
                break;
            }
            case 91: {
                Object data = Value.randomDate(config);
                break;
            }
            case 92: {
                Object data = Value.randomTime(config);
                break;
            }
            case 93: {
                Object data = Value.randomTimestamp(config);
                break;
            }
            case 4: {
                Object data = Value.randomInt(config);
                break;
            }
            case -7: 
            case 16: {
                Object data = config.random().getBoolean(50) ? "TRUE" : "FALSE";
                break;
            }
            default: {
                throw new Error("type=" + type);
            }
        }
        return new Value(config, type, var5_5);
    }

    private static Object randomInt(TestSynth config) {
        int value = config.is(4) ? config.random().getInt(1000000) : config.random().getRandomInt();
        return new Integer(value);
    }

    private static byte[] randomBytes(TestSynth config, int max) {
        int len = config.random().getLog(max);
        byte[] data = new byte[len];
        config.random().getBytes(data);
        return data;
    }

    private static BigDecimal randomDecimal(TestSynth config, int precision, int scale) {
        int len = config.random().getLog(precision - scale) + scale;
        if (len == 0) {
            ++len;
        }
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            buff.append((char)(48 + config.random().getInt(10)));
        }
        buff.insert(len - scale, '.');
        if (config.random().getBoolean(20)) {
            buff.insert(0, '-');
        }
        return new BigDecimal(buff.toString());
    }

    public int compareTo(Object o) {
        Value v = (Value)o;
        if (this.type != v.type) {
            throw new Error("compare " + this.type + " " + v.type + " " + this.data + " " + v.data);
        }
        if (this.data == null) {
            return v.data == null ? 0 : -1;
        }
        if (v.data == null) {
            return 1;
        }
        switch (this.type) {
            case 3: {
                return ((BigDecimal)this.data).compareTo((BigDecimal)v.data);
            }
            case -3: 
            case -2: 
            case 2004: {
                return Value.compareBytes((byte[])this.data, (byte[])v.data);
            }
            case 12: 
            case 2005: {
                return this.data.toString().compareTo(v.data.toString());
            }
            case 91: {
                return ((Date)this.data).compareTo((Date)v.data);
            }
            case 4: {
                return ((Integer)this.data).compareTo((Integer)v.data);
            }
        }
        throw new Error("type=" + this.type);
    }

    static int compareBytes(byte[] a, byte[] b) {
        int al = a.length;
        int bl = b.length;
        int len = Math.min(al, bl);
        for (int i = 0; i < len; ++i) {
            int x = a[i] & 0xFF;
            int y = b[i] & 0xFF;
            if (x == y) continue;
            return x > y ? 1 : -1;
        }
        return al == bl ? 0 : (al > bl ? 1 : -1);
    }

    public String toString() {
        return this.getSQL();
    }
}

