/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.codecs.video.mpeg12;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import net.sourceforge.jffmpeg.JMFCodec;
import net.sourceforge.jffmpeg.codecs.utils.BitStream;
import net.sourceforge.jffmpeg.codecs.utils.FFMpegException;
import net.sourceforge.jffmpeg.codecs.utils.VLCTable;
import net.sourceforge.jffmpeg.codecs.video.mpeg.DisplayOutput;
import net.sourceforge.jffmpeg.codecs.video.mpeg12.MpegException;
import net.sourceforge.jffmpeg.codecs.video.mpeg12.data.AddressIncrementVlc;
import net.sourceforge.jffmpeg.codecs.video.mpeg12.data.DiscreteCosineChrominanceVlc;
import net.sourceforge.jffmpeg.codecs.video.mpeg12.data.DiscreteCosineLuminanceVlc;
import net.sourceforge.jffmpeg.codecs.video.mpeg12.data.MbBTypeVLC;
import net.sourceforge.jffmpeg.codecs.video.mpeg12.data.MbPTypeVLC;
import net.sourceforge.jffmpeg.codecs.video.mpeg12.data.MotionVectorVlc;
import net.sourceforge.jffmpeg.codecs.video.mpeg12.data.PatVLC;
import net.sourceforge.jffmpeg.codecs.video.mpeg12.data.Tables;
import net.sourceforge.jffmpeg.codecs.video.mpeg12.rltables.Mpeg1RLTable;
import net.sourceforge.jffmpeg.codecs.video.mpeg12.rltables.Mpeg2RLTable;
import net.sourceforge.jffmpeg.codecs.video.mpeg12.rltables.RLTable;
import net.sourceforge.jffmpeg.codecs.video.mpeg12.scantable.AlternateHorizontalScan;
import net.sourceforge.jffmpeg.codecs.video.mpeg12.scantable.AlternateVerticalScan;
import net.sourceforge.jffmpeg.codecs.video.mpeg12.scantable.ScanTable;
import net.sourceforge.jffmpeg.codecs.video.mpeg12.scantable.ZigZagDirect;

public class MpegVideo
implements Codec,
JMFCodec {
    protected BitStream in = new BitStream();
    private DisplayOutput displayOutput;
    public static final boolean showInterlace = false;
    public static final boolean skipBFrames = false;
    public static final boolean debug = false;
    private int numberOfFramesDelivered = 0;
    public int targetFrameBuffer = 50;
    public boolean hurryUp = false;
    public static final int SYNC_BYTES = 1;
    public static final int SEQ_END_CODE = 183;
    public static final int SEQ_START_CODE = 179;
    public static final int GOP_START_CODE = 184;
    public static final int PICTURE_START_CODE = 0;
    public static final int SLICE_MIN_START_CODE = 1;
    public static final int SLICE_MAX_START_CODE = 175;
    public static final int EXT_START_CODE = 181;
    public static final int USER_START_CODE = 178;
    private static final int SEQUENCE_EXTENSION = 1;
    private static final int SEQUENCE_DISPLAY_EXTENSION = 2;
    private static final int QUANT_MATRIX_EXTENSION = 3;
    private static final int PICTURE_DISPLAY_EXTENSION = 7;
    private static final int PICTURE_CODING_EXTENSION = 8;
    public static final int I_TYPE = 1;
    public static final int P_TYPE = 2;
    public static final int B_TYPE = 3;
    public static final int SKIP_FRAME_TYPE = -1;
    public static final int PICT_FRAME = 3;
    public static final int MT_FIELD = 1;
    public static final int MT_FRAME = 2;
    public static final int MT_16X8 = 2;
    public static final int MT_DMV = 3;
    public static final int MV_TYPE_16X16 = 0;
    public static final int MV_TYPE_8X8 = 1;
    public static final int MV_TYPE_16X8 = 2;
    public static final int MV_TYPE_FIELD = 3;
    public static final int MV_TYPE_DMV = 4;
    public static final int MV_DIR_FORWARD = 2;
    public static final int MV_DIR_BACKWARD = 1;
    private int currentHeader;
    private int mbWidth;
    private int mbHeight;
    protected boolean mpeg2;
    protected int width;
    protected int height;
    protected int aspectRatio;
    protected int frame_rate_index;
    protected int bit_rate;
    protected float frameRate = 29.0f;
    private ScanTable alternateVerticalScanTable = new AlternateVerticalScan();
    private ScanTable alternateHorizontalScanTable = new AlternateHorizontalScan();
    private ScanTable zigZagDirect = new ZigZagDirect();
    private ScanTable intraScanTable = new ZigZagDirect();
    private ScanTable interScanTable = new ZigZagDirect();
    private ScanTable intraHScanTable = new AlternateHorizontalScan();
    private ScanTable intraVScanTable = new AlternateVerticalScan();
    private final int[] dsp_idct_permutation = Tables.getDspIdctPermutation();
    private final int[] ff_mpeg1_default_intra_matrix = Tables.getMpeg1DefaultIntraMatrix();
    private final int[] ff_mpeg1_default_non_intra_matrix = Tables.getMpeg1DefaultNonIntraMatrix();
    private final int[] non_linear_qscale = Tables.getNonLinearQscale();
    public final VLCTable mbincr_vlc = new AddressIncrementVlc();
    public final VLCTable mv_vlc = new MotionVectorVlc();
    public final RLTable rl_mpeg1 = new Mpeg1RLTable();
    public final RLTable rl_mpeg2 = new Mpeg2RLTable();
    private final VLCTable dc_lum_vlc = new DiscreteCosineLuminanceVlc();
    private final VLCTable dc_chroma_vlc = new DiscreteCosineChrominanceVlc();
    private int[] ptype2mb_type = Tables.getPType2mb_type();
    private int[] btype2mb_type = Tables.getBType2mb_type();
    private VLCTable mb_ptype_vlc = new MbPTypeVLC();
    private VLCTable mb_btype_vlc = new MbBTypeVLC();
    private VLCTable mb_pat_vlc = new PatVLC();
    private int[] intra_matrix = new int[64];
    private int[] inter_matrix = new int[64];
    private int[] chroma_intra_matrix = new int[64];
    private int[] chroma_inter_matrix = new int[64];
    private int[][] motion_val;
    private int mv_dir;
    private int mv_type;
    private int motion_type;
    private int[] mv = new int[8];
    private int[] last_mv = new int[8];
    private boolean[] full_pel = new boolean[2];
    private boolean[] field_select = new boolean[4];
    private boolean mb_intra = true;
    protected int mb_type;
    public static final int NUMBER_OF_BLOCKS = 6;
    private int[] blockWrap = new int[6];
    private int[] blockIndex = new int[6];
    private int[][] block = new int[6][64];
    private int[] last_dc = new int[]{128, 128, 128};
    protected int profile;
    protected int level;
    protected boolean progressive_sequence;
    protected int vdv_buf_ext;
    private int panScanWidth;
    private int panScanHeight;
    protected int intra_dc_precision;
    protected int picture_structure = 3;
    protected boolean top_field_first;
    protected boolean frame_pred_frame_dct;
    protected boolean concealment_motion_vectors;
    protected boolean q_scale_type;
    protected boolean intra_vlc_format;
    protected boolean alternate_scan;
    protected boolean repeat_first_field;
    protected boolean chroma_420_type;
    protected boolean progressive_frame;
    protected boolean first_field;
    protected int pict_type;
    protected int picture_number;
    protected int[] mpeg_f_code = new int[4];
    protected int y_dc_scale;
    protected int c_dc_scale;
    protected boolean first_slice;
    protected boolean field_pic;
    protected int resync_mb_x;
    protected int resync_mb_y;
    protected int mb_x;
    protected int mb_y;
    protected boolean interlaced_dct;
    protected int repeat_pict;
    protected int qscale;
    protected int mb_skip_run;
    protected final float[] frameRateTable = Tables.getFrameRateTable();
    private int lastFullFrame;
    private boolean notConsumed = false;
    private boolean findSequenceHeader = true;
    private VideoFormat inputFormat;
    private long lastTime;
    private int frames;
    private int skipToIFrame = 0;

    private void initialise(int n, int n2) {
        this.mbWidth = (n + 15) / 16;
        this.mbHeight = (n2 + 15) / 16;
        if (this.displayOutput == null) {
            this.displayOutput = new DisplayOutput(this.mbWidth, this.mbHeight);
        }
        this.blockWrap[0] = this.mbWidth * 2 + 2;
        this.blockWrap[1] = this.mbWidth * 2 + 2;
        this.blockWrap[2] = this.mbWidth * 2 + 2;
        this.blockWrap[3] = this.mbWidth * 2 + 2;
        this.blockWrap[4] = this.mbWidth + 2;
        this.blockWrap[5] = this.mbWidth + 2;
        this.motion_val = new int[1 + (this.mbWidth * 2 + 2) * this.mbHeight * 2 * 4][2];
    }

    private void mpeg1_decode_sequence() {
        int n;
        int n2;
        int n3;
        this.width = this.in.getBits(12);
        this.height = this.in.getBits(12);
        this.aspectRatio = this.in.getBits(4);
        this.frame_rate_index = this.in.getBits(4);
        this.frameRate = this.frameRateTable[this.frame_rate_index];
        this.bit_rate = this.in.getBits(18) * 400;
        this.in.getTrueFalse();
        this.in.getBits(10);
        this.in.getTrueFalse();
        if (this.in.getTrueFalse()) {
            for (n3 = 0; n3 < 64; ++n3) {
                n2 = this.in.getBits(8);
                n = this.intraScanTable.getPermutated()[n3];
                this.intra_matrix[n] = n2;
                this.chroma_intra_matrix[n] = n2;
            }
        } else {
            for (n3 = 0; n3 < 64; ++n3) {
                n2 = this.dsp_idct_permutation[n3];
                this.intra_matrix[n2] = n = this.ff_mpeg1_default_intra_matrix[n3];
                this.chroma_intra_matrix[n2] = n;
            }
        }
        if (this.in.getTrueFalse()) {
            for (n3 = 0; n3 < 64; ++n3) {
                n2 = this.in.getBits(8);
                n = this.intraScanTable.getPermutated()[n3];
                this.inter_matrix[n] = n2;
                this.chroma_inter_matrix[n] = n2;
            }
        } else {
            for (n3 = 0; n3 < 64; ++n3) {
                n2 = this.dsp_idct_permutation[n3];
                this.inter_matrix[n2] = n = this.ff_mpeg1_default_non_intra_matrix[n3];
                this.chroma_inter_matrix[n2] = n;
            }
        }
        this.progressive_sequence = true;
        this.progressive_frame = true;
        this.picture_structure = 3;
        this.frame_pred_frame_dct = true;
    }

    private void mpeg_decode_sequence_extension() {
        this.in.getTrueFalse();
        this.profile = this.in.getBits(3);
        this.level = this.in.getBits(4);
        this.progressive_sequence = this.in.getTrueFalse();
        this.in.getBits(2);
        this.width |= this.in.getBits(2) << 12;
        this.height |= this.in.getBits(2) << 12;
        this.bit_rate = (this.bit_rate / 400 | this.in.getBits(12) << 12) * 400;
        this.in.getTrueFalse();
        this.vdv_buf_ext = this.in.getBits(8);
        this.in.getTrueFalse();
        int n = this.in.getBits(2);
        int n2 = this.in.getBits(5);
        this.mpeg2 = true;
    }

    private void mpeg_decode_sequence_display_extension() {
        this.in.getBits(3);
        if (this.in.getTrueFalse()) {
            this.in.getBits(24);
        }
        int n = this.in.getBits(14);
        this.in.getTrueFalse();
        int n2 = this.in.getBits(14);
        this.in.getTrueFalse();
        this.panScanWidth = 16 * n;
        this.panScanHeight = 16 * n2;
    }

    private void mpeg_decode_picture_coding_extension() {
        this.full_pel[0] = false;
        this.full_pel[1] = false;
        this.mpeg_f_code[0] = this.in.getBits(4);
        this.mpeg_f_code[1] = this.in.getBits(4);
        this.mpeg_f_code[2] = this.in.getBits(4);
        this.mpeg_f_code[3] = this.in.getBits(4);
        this.intra_dc_precision = this.in.getBits(2);
        this.picture_structure = this.in.getBits(2);
        this.top_field_first = this.in.getTrueFalse();
        this.frame_pred_frame_dct = this.in.getTrueFalse();
        this.concealment_motion_vectors = this.in.getTrueFalse();
        this.q_scale_type = this.in.getTrueFalse();
        this.intra_vlc_format = this.in.getTrueFalse();
        this.alternate_scan = this.in.getTrueFalse();
        this.repeat_first_field = this.in.getTrueFalse();
        this.chroma_420_type = this.in.getTrueFalse();
        this.progressive_frame = this.in.getTrueFalse();
        if (this.picture_structure == 3) {
            this.first_field = false;
        } else {
            boolean bl = this.first_field = !this.first_field;
        }
        if (this.alternate_scan) {
            this.intraScanTable = this.alternateVerticalScanTable;
            this.interScanTable = this.alternateVerticalScanTable;
            this.intraHScanTable = this.alternateVerticalScanTable;
            this.intraVScanTable = this.alternateVerticalScanTable;
        } else {
            this.intraScanTable = this.zigZagDirect;
            this.interScanTable = this.zigZagDirect;
            this.intraHScanTable = this.alternateHorizontalScanTable;
            this.intraVScanTable = this.alternateVerticalScanTable;
        }
    }

    private void mpeg_decode_quant_matrix_extension() {
        int n;
        int n2;
        int n3;
        if (this.in.getTrueFalse()) {
            for (n3 = 0; n3 < 64; ++n3) {
                n2 = this.in.getBits(8);
                n = this.zigZagDirect.getPermutated()[n3];
                this.intra_matrix[n] = n2;
                this.chroma_intra_matrix[n] = n2;
            }
        }
        if (this.in.getTrueFalse()) {
            for (n3 = 0; n3 < 64; ++n3) {
                n2 = this.in.getBits(8);
                n = this.zigZagDirect.getPermutated()[n3];
                this.inter_matrix[n] = n2;
                this.chroma_inter_matrix[n] = n2;
            }
        }
        if (this.in.getTrueFalse()) {
            for (n3 = 0; n3 < 64; ++n3) {
                n2 = this.in.getBits(8);
                n = this.zigZagDirect.getPermutated()[n3];
                this.chroma_intra_matrix[n] = n2;
            }
        }
        if (this.in.getTrueFalse()) {
            for (n3 = 0; n3 < 64; ++n3) {
                n2 = this.in.getBits(8);
                n = this.zigZagDirect.getPermutated()[n3];
                this.chroma_inter_matrix[n] = n2;
            }
        }
    }

    private void mpeg_decode_extension() {
        int n = this.in.getBits(4);
        switch (n) {
            case 1: {
                this.mpeg_decode_sequence_extension();
                break;
            }
            case 2: {
                this.mpeg_decode_sequence_display_extension();
                break;
            }
            case 3: {
                this.mpeg_decode_quant_matrix_extension();
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                this.mpeg_decode_picture_coding_extension();
                break;
            }
        }
    }

    private void mpeg1_decode_picture() {
        int n;
        int n2 = this.in.getBits(10);
        this.pict_type = this.in.getBits(3);
        this.in.getBits(16);
        if (this.pict_type == 2 || this.pict_type == 3) {
            this.full_pel[0] = this.in.getTrueFalse();
            this.mpeg_f_code[0] = n = this.in.getBits(3);
            this.mpeg_f_code[1] = n;
        }
        if (this.pict_type == 3) {
            this.full_pel[1] = this.in.getTrueFalse();
            this.mpeg_f_code[2] = n = this.in.getBits(3);
            this.mpeg_f_code[3] = n;
        }
        this.y_dc_scale = 8;
        this.c_dc_scale = 8;
        this.first_slice = true;
    }

    private int mpeg_decode_motion(int n, int n2) throws FFMpegException {
        int n3 = this.in.getVLC(this.mv_vlc);
        if (n3 == 0) {
            return n2;
        }
        boolean bl = this.in.getTrueFalse();
        int n4 = n - 1;
        if (n4 != 0) {
            n3 = n3 - 1 << n4;
            n3 |= this.in.getBits(n4);
            ++n3;
        }
        if (bl) {
            n3 = -n3;
        }
        n3 += n2;
        int n5 = 1 << n4 + 4;
        n3 = (n3 + n5 & n5 * 2 - 1) - n5;
        return n3;
    }

    private int decode_dc(int n) throws FFMpegException {
        int n2 = this.in.getVLC(n == 0 ? this.dc_lum_vlc : this.dc_chroma_vlc);
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.in.getBits(n2);
        if ((n3 & 1 << n2 - 1) == 0) {
            n3 = -1 << n2 | n3 + 1;
        }
        return n3;
    }

    private void mpeg1_decode_block_inter(int[] nArray, int n) throws FFMpegException {
        RLTable rLTable = this.rl_mpeg1;
        ScanTable scanTable = this.intraScanTable;
        int[] nArray2 = this.inter_matrix;
        int n2 = -1;
        int n3 = this.in.showBits(2);
        if ((n3 & 2) != 0) {
            this.in.getBits(2);
            this.level = 3 * this.qscale * nArray2[0] >> 4;
            this.level = this.level - 1 | 1;
            if ((n3 & 1) != 0) {
                this.level = -this.level;
            }
            nArray[0] = this.level;
            ++n2;
        }
        while (true) {
            int n4;
            int n5 = this.in.getVLC(rLTable);
            int n6 = rLTable.getLevel(n5);
            int n7 = rLTable.getRun(n5);
            if (n6 == 127) break;
            if (n6 != 0) {
                n4 = scanTable.getPermutated()[n2 += n7];
                n6 = (n6 * 2 + 1) * this.qscale * nArray2[n4] >> 4;
                n6 = n6 - 1 | 1;
                if (this.in.getTrueFalse()) {
                    n6 = -n6;
                }
            } else {
                n7 = this.in.getBits(6) + 1;
                n6 = this.in.getBits(8);
                if ((n6 & 0x80) != 0) {
                    n6 |= 0xFFFFFF00;
                }
                if (n6 == -128) {
                    n6 = this.in.getBits(8) - 256;
                } else if (n6 == 0) {
                    n6 = this.in.getBits(8);
                }
                n4 = scanTable.getPermutated()[n2 += n7];
                if (n6 < 0) {
                    n6 = -n6;
                    n6 = (n6 * 2 + 1) * this.qscale * nArray2[n4] >> 4;
                    n6 = n6 - 1 | 1;
                    n6 = -n6;
                } else {
                    n6 = (n6 * 2 + 1) * this.qscale * nArray2[n4] >> 4;
                    n6 = n6 - 1 | 1;
                }
            }
            if (n2 > 63) {
                throw new MpegException("Illegal MB code");
            }
            nArray[n4] = n6;
        }
    }

    private void mpeg1_decode_block_intra(int[] nArray, int n) throws FFMpegException {
        RLTable rLTable = this.rl_mpeg1;
        ScanTable scanTable = this.intraScanTable;
        int[] nArray2 = this.intra_matrix;
        int n2 = n <= 3 ? 0 : n - 4 + 1;
        int n3 = this.decode_dc(n2);
        int n4 = this.last_dc[n2];
        this.last_dc[n2] = n4 += n3;
        nArray[0] = n4 << 3;
        int n5 = 0;
        while (true) {
            int n6;
            int n7 = this.in.getVLC(rLTable);
            int n8 = rLTable.getLevel(n7);
            int n9 = rLTable.getRun(n7);
            if (n8 == 127) break;
            if (n8 != 0) {
                n6 = scanTable.getPermutated()[n5 += n9];
                n8 = n8 * this.qscale * nArray2[n6] >> 3;
                n8 = n8 - 1 | 1;
                if (this.in.getTrueFalse()) {
                    n8 = -n8;
                }
            } else {
                n9 = this.in.getBits(6) + 1;
                n8 = this.in.getBits(8);
                if ((n8 & 0x80) != 0) {
                    n8 |= 0xFFFFFF00;
                }
                if (n8 == -128) {
                    n8 = this.in.getBits(8) - 256;
                } else if (n8 == 0) {
                    n8 = this.in.getBits(8);
                }
                n6 = scanTable.getPermutated()[n5 += n9];
                if (n8 < 0) {
                    n8 = -n8;
                    n8 = n8 * this.qscale * nArray2[n6] >> 3;
                    n8 = n8 - 1 | 1;
                    n8 = -n8;
                } else {
                    n8 = n8 * this.qscale * nArray2[n6] >> 3;
                    n8 = n8 - 1 | 1;
                }
            }
            if (n5 > 63) {
                throw new MpegException("Error decoding mb");
            }
            nArray[n6] = n8;
        }
    }

    private void mpeg2_decode_block_intra(int[] nArray, int n) throws FFMpegException {
        int n2;
        int[] nArray2 = this.intraScanTable.getPermutated();
        int[] nArray3 = n < 4 ? this.intra_matrix : this.chroma_intra_matrix;
        int n3 = n2 = n < 4 ? 0 : n - 3;
        this.last_dc[n3] = this.last_dc[n3] + this.decode_dc(n2);
        nArray[0] = this.last_dc[n2] << 3 - this.intra_dc_precision;
        int n4 = nArray[0] ^ 1;
        RLTable rLTable = this.intra_vlc_format ? this.rl_mpeg2 : this.rl_mpeg1;
        int n5 = 0;
        int n6 = 0;
        while (true) {
            int n7 = this.in.getVLC(rLTable);
            int n8 = rLTable.getLevel(n7);
            int n9 = rLTable.getRun(n7);
            if (n8 == 127) break;
            if (n8 != 0) {
                n6 = nArray2[n5 += n9];
                n8 = n8 * this.qscale * nArray3[n6] >> 4;
                if (this.in.getTrueFalse()) {
                    n8 = ~n8 + 1;
                }
            } else {
                n9 = this.in.getBits(6) + 1;
                n8 = this.in.getTrueFalse() ? this.in.getBits(11) | 0xFFFFF800 : this.in.getBits(11);
                n6 = nArray2[n5 += n9];
                if (n8 < 0) {
                    n8 = -n8 * this.qscale * nArray3[n6] >> 4;
                    n8 = -n8;
                } else {
                    n8 = n8 * this.qscale * nArray3[n6] >> 4;
                }
            }
            if (n5 > 63) {
                throw new MpegException("Error");
            }
            n4 ^= n8;
            nArray[n6] = n8;
        }
        nArray[63] = nArray[63] ^ n4 & 1;
    }

    private void mpeg2_decode_block_non_intra(int[] nArray, int n) throws FFMpegException {
        int[] nArray2 = this.intraScanTable.getPermutated();
        int[] nArray3 = n < 4 ? this.inter_matrix : this.chroma_inter_matrix;
        int n2 = 1;
        int n3 = -1;
        int n4 = this.in.showBits(2);
        if ((n4 & 2) == 2) {
            n4 = this.in.getBits(2);
            nArray[0] = 3 * this.qscale * nArray3[0] >> 5;
            if ((n4 & 1) == 1) {
                nArray[0] = -nArray[0];
            }
            n2 ^= nArray[0];
            ++n3;
        }
        RLTable rLTable = this.rl_mpeg1;
        int n5 = 0;
        while (true) {
            int n6 = this.in.getVLC(rLTable);
            int n7 = rLTable.getLevel(n6);
            int n8 = rLTable.getRun(n6);
            if (n7 == 127) break;
            if (n7 != 0) {
                n5 = nArray2[n3 += n8];
                n7 = (n7 * 2 + 1) * this.qscale * nArray3[n5] >> 5;
                if (this.in.getTrueFalse()) {
                    n7 = ~n7 + 1;
                }
            } else {
                n8 = this.in.getBits(6) + 1;
                n7 = this.in.getTrueFalse() ? this.in.getBits(11) | 0xFFFFF800 : this.in.getBits(11);
                n5 = nArray2[n3 += n8];
                if (n7 < 0) {
                    n7 = (-n7 * 2 + 1) * this.qscale * nArray3[n5] >> 5;
                    n7 = -n7;
                } else {
                    n7 = (n7 * 2 + 1) * this.qscale * nArray3[n5] >> 5;
                }
            }
            if (n3 > 63) {
                throw new MpegException("Error");
            }
            n2 ^= n7;
            nArray[n5] = n7;
        }
        nArray[63] = nArray[63] ^ n2 & 1;
    }

    private void mpeg_decode_mb() throws FFMpegException {
        block45: {
            int n;
            int n2;
            block44: {
                if (this.mb_skip_run-- != 0) {
                    if (this.pict_type == 1) {
                        throw new Error("skip in IFrame");
                    }
                    this.mv_type = 0;
                    if (this.pict_type == 2) {
                        this.mv_dir = 2;
                        this.mv[0] = 0;
                        this.mv[1] = 0;
                        this.last_mv[0] = 0;
                        this.last_mv[1] = 0;
                        this.last_mv[2] = 0;
                        this.last_mv[3] = 0;
                    } else {
                        this.mv[0] = this.last_mv[0];
                        this.mv[1] = this.last_mv[1];
                        this.mv[4] = this.last_mv[4];
                        this.mv[5] = this.last_mv[5];
                    }
                    this.mb_intra = false;
                    return;
                }
                switch (this.pict_type) {
                    case 1: {
                        if (this.in.getTrueFalse()) {
                            this.mb_type = 1;
                            break;
                        }
                        if (this.in.getTrueFalse()) {
                            this.mb_type = 65537;
                            break;
                        }
                        throw new MpegException("Invalid mb type");
                    }
                    case 2: {
                        this.mb_type = this.ptype2mb_type[this.in.getVLC(this.mb_ptype_vlc)];
                        break;
                    }
                    case 3: {
                        this.mb_type = this.btype2mb_type[this.in.getVLC(this.mb_btype_vlc)];
                    }
                }
                if ((7 & this.mb_type) == 0) break block44;
                if (this.picture_structure == 3 && !this.frame_pred_frame_dct) {
                    this.interlaced_dct = this.in.getTrueFalse();
                }
                if ((0x10000 & this.mb_type) != 0) {
                    this.qscale = this.get_qscale();
                }
                if (this.concealment_motion_vectors) {
                    if (this.picture_structure != 3) {
                        this.in.getTrueFalse();
                    }
                    this.mv[0] = this.mpeg_decode_motion(this.mpeg_f_code[1], this.last_mv[0]);
                    this.mv[1] = this.mpeg_decode_motion(this.mpeg_f_code[1], this.last_mv[1]);
                    this.last_mv[0] = this.mv[0];
                    this.last_mv[2] = this.mv[0];
                    this.last_mv[1] = this.mv[1];
                    this.last_mv[3] = this.mv[1];
                    this.in.getTrueFalse();
                } else {
                    this.last_mv[0] = 0;
                    this.last_mv[2] = 0;
                    this.last_mv[1] = 0;
                    this.last_mv[3] = 0;
                    this.last_mv[4] = 0;
                    this.last_mv[6] = 0;
                    this.last_mv[5] = 0;
                    this.last_mv[7] = 0;
                }
                this.mb_intra = true;
                if (this.mpeg2) {
                    for (int i = 0; i < 6; ++i) {
                        this.mpeg2_decode_block_intra(this.block[i], i);
                    }
                } else {
                    for (int i = 0; i < 6; ++i) {
                        this.mpeg1_decode_block_intra(this.block[i], i);
                    }
                }
                break block45;
            }
            if ((this.mb_type & 0x20000000) != 0) {
                if (this.picture_structure == 3 && !this.frame_pred_frame_dct) {
                    this.interlaced_dct = this.in.getTrueFalse();
                }
                if ((0x10000 & this.mb_type) != 0) {
                    this.qscale = this.get_qscale();
                }
                this.mv_dir = 2;
                this.mv_type = 0;
                this.last_mv[0] = 0;
                this.last_mv[1] = 0;
                this.last_mv[2] = 0;
                this.last_mv[3] = 0;
                this.mv[0] = 0;
                this.mv[1] = 0;
            } else {
                this.motion_type = this.frame_pred_frame_dct ? 2 : this.in.getBits(2);
                if (this.picture_structure == 3 && !this.frame_pred_frame_dct && (this.mb_type & 0x40000000) != 0) {
                    this.interlaced_dct = this.in.getTrueFalse();
                }
                if ((0x10000 & this.mb_type) != 0) {
                    this.qscale = this.get_qscale();
                }
                this.mv_dir = 0;
                block12: for (n2 = 0; n2 < 2; ++n2) {
                    if (0 == (this.mb_type & 12288 << 2 * n2)) continue;
                    this.mv_dir |= 2 >> n2;
                    switch (this.motion_type) {
                        case 2: {
                            if (this.picture_structure == 3) {
                                this.mb_type |= 8;
                                this.mv_type = 0;
                                this.mv[n2 * 4] = this.mpeg_decode_motion(this.mpeg_f_code[n2 * 2], this.last_mv[n2 * 4]);
                                this.last_mv[n2 * 4] = this.mv[n2 * 4];
                                this.last_mv[n2 * 4 + 2] = this.mv[n2 * 4];
                                this.mv[n2 * 4 + 1] = this.mpeg_decode_motion(this.mpeg_f_code[n2 * 2 + 1], this.last_mv[n2 * 4 + 1]);
                                this.last_mv[n2 * 4 + 1] = this.mv[n2 * 4 + 1];
                                this.last_mv[n2 * 4 + 3] = this.mv[n2 * 4 + 1];
                                if (!this.full_pel[n2]) continue block12;
                                int n3 = n2 * 4;
                                this.mv[n3] = this.mv[n3] << 1;
                                int n4 = n2 * 4 + 1;
                                this.mv[n4] = this.mv[n4] << 1;
                                continue block12;
                            }
                            this.mb_type |= 0x10;
                            this.mv_type = 2;
                            for (n = 0; n < 2; ++n) {
                                this.field_select[n2 * 2 + n] = this.in.getTrueFalse();
                                for (int i = 0; i < 2; ++i) {
                                    this.mv[n2 * 4 + n * 2 + i] = this.mpeg_decode_motion(this.mpeg_f_code[n2 * 2 + i], this.last_mv[n2 * 4 + n * 2 + i]);
                                    this.last_mv[n2 * 4 + n * 2 + i] = this.mv[n2 * 4 + n * 2 + i];
                                }
                            }
                            continue block12;
                        }
                        case 1: {
                            this.mv_type = 3;
                            if (this.picture_structure == 3) {
                                this.mb_type |= 0x90;
                                for (n = 0; n < 2; ++n) {
                                    this.field_select[n2 * 2 + n] = this.in.getTrueFalse();
                                    this.last_mv[n2 * 4 + n * 2] = this.mpeg_decode_motion(this.mpeg_f_code[n2 * 2], this.last_mv[n2 * 4 + n * 2]);
                                    this.mv[n2 * 4 + n * 2] = this.last_mv[n2 * 4 + n * 2];
                                    this.last_mv[n2 * 4 + n * 2 + 1] = this.mpeg_decode_motion(this.mpeg_f_code[n2 * 2 + 1], this.last_mv[n2 * 4 + n * 2 + 1] >> 1);
                                    this.mv[n2 * 4 + n * 2 + 1] = this.last_mv[n2 * 4 + n * 2 + 1];
                                    int n5 = n2 * 4 + n * 2 + 1;
                                    this.last_mv[n5] = this.last_mv[n5] << 1;
                                }
                                continue block12;
                            }
                            this.mb_type |= 8;
                            this.field_select[n2 * 2] = this.in.getTrueFalse();
                            for (n = 0; n < 2; ++n) {
                                this.last_mv[n2 * 4 + n] = this.mpeg_decode_motion(this.mpeg_f_code[n2 * 2 + n], this.last_mv[n2 * 4 + n]);
                                this.last_mv[n2 * 4 + 2 + n] = this.last_mv[n2 * 4 + n];
                                this.mv[n2 * 4 + n] = this.last_mv[n2 * 4 + n];
                            }
                            continue block12;
                        }
                        case 3: {
                            System.out.println("MT_DMV");
                            continue block12;
                        }
                        default: {
                            System.out.println("UNKNOWN");
                        }
                    }
                }
            }
            this.mb_intra = false;
            if ((this.mb_type & 0x40000000) == 0) break block45;
            n2 = this.in.getVLC(this.mb_pat_vlc);
            ++n2;
            if (this.mpeg2) {
                for (n = 0; n < 6; ++n) {
                    if ((n2 & 0x20) == 32) {
                        this.mpeg2_decode_block_non_intra(this.block[n], n);
                    }
                    n2 *= 2;
                }
            } else {
                for (n = 0; n < 6; ++n) {
                    if ((n2 & 0x20) == 32) {
                        this.mpeg1_decode_block_inter(this.block[n], n);
                    }
                    n2 *= 2;
                }
            }
        }
    }

    private int get_qscale() {
        int n = this.mpeg2 ? (this.q_scale_type ? this.non_linear_qscale[this.in.getBits(5)] : this.in.getBits(5) << 1) : this.in.getBits(5);
        return n;
    }

    private void MPV_decode_mb() {
        if (!this.mb_intra) {
            this.last_dc[0] = 128 << this.intra_dc_precision;
            this.last_dc[1] = 128 << this.intra_dc_precision;
            this.last_dc[2] = 128 << this.intra_dc_precision;
        }
        if (this.hurryUp && this.pict_type == 3) {
            return;
        }
        if (!this.mb_intra) {
            int n = this.mb_x;
            int n2 = this.mb_y;
            boolean bl = false;
            if ((this.mv_dir & 2) != 0) {
                if (this.pict_type == 2) {
                    this.displayOutput.moveFromNext(n, n2, this.mv, 0, false, bl, this.mv_type, this.field_select, 0);
                } else {
                    this.displayOutput.moveFromLast(n, n2, this.mv, 0, true, bl, this.mv_type, this.field_select, 0);
                }
                bl = true;
            }
            if ((this.mv_dir & 1) != 0 && this.pict_type != 2) {
                this.displayOutput.moveFromNext(n, n2, this.mv, 4, true, bl, this.mv_type, this.field_select, 2);
            }
            this.displayOutput.addLuminanceIdct(n * 2, n2 * 2, this.block[0], this.interlaced_dct);
            this.displayOutput.addLuminanceIdct(n * 2 + 1, n2 * 2, this.block[1], this.interlaced_dct);
            this.displayOutput.addLuminanceIdct(n * 2, n2 * 2 + 1, this.block[2], this.interlaced_dct);
            this.displayOutput.addLuminanceIdct(n * 2 + 1, n2 * 2 + 1, this.block[3], this.interlaced_dct);
            this.displayOutput.addRedIdct(n, n2, this.block[5]);
            this.displayOutput.addBlueIdct(n, n2, this.block[4]);
        } else {
            int n = this.mb_x;
            int n3 = this.mb_y;
            this.displayOutput.putLuminanceIdct(n * 2, n3 * 2, this.block[0], this.interlaced_dct);
            this.displayOutput.putLuminanceIdct(n * 2 + 1, n3 * 2, this.block[1], this.interlaced_dct);
            this.displayOutput.putLuminanceIdct(n * 2, n3 * 2 + 1, this.block[2], this.interlaced_dct);
            this.displayOutput.putLuminanceIdct(n * 2 + 1, n3 * 2 + 1, this.block[3], this.interlaced_dct);
            this.displayOutput.putRedIdct(n, n3, this.block[5]);
            this.displayOutput.putBlueIdct(n, n3, this.block[4]);
        }
    }

    private void mpeg_decode_slice(int n) throws FFMpegException {
        int n2;
        block16: {
            block17: {
                block18: {
                    this.last_dc[0] = 1 << 7 + this.intra_dc_precision;
                    this.last_dc[1] = this.last_dc[0];
                    this.last_dc[2] = this.last_dc[0];
                    this.last_mv[0] = 0;
                    this.last_mv[1] = 0;
                    this.last_mv[2] = 0;
                    this.last_mv[3] = 0;
                    this.last_mv[4] = 0;
                    this.last_mv[5] = 0;
                    this.last_mv[6] = 0;
                    this.last_mv[7] = 0;
                    this.field_pic = this.picture_structure != 3;
                    this.interlaced_dct = false;
                    if (!this.first_slice) break block16;
                    if (!this.first_field && this.field_pic) break block17;
                    this.repeat_pict = 0;
                    if (!this.repeat_first_field) break block16;
                    if (!this.progressive_sequence) break block18;
                    this.repeat_pict = this.top_field_first ? 4 : 2;
                    break block16;
                }
                if (!this.progressive_frame) break block16;
                this.repeat_pict = 1;
                break block16;
            }
            for (n2 = 0; n2 < 4; ++n2) {
            }
        }
        this.first_slice = false;
        this.qscale = this.get_qscale();
        while (this.in.getTrueFalse()) {
            this.in.getBits(8);
        }
        this.mb_x = 0;
        do {
            if ((n2 = this.in.getVLC(this.mbincr_vlc)) > 33) continue;
            this.mb_x += n2;
        } while (n2 >= 33);
        this.resync_mb_x = this.mb_x;
        this.resync_mb_y = n;
        this.mb_y = n;
        this.blockIndex[0] = this.blockWrap[0] * (this.mb_y * 2 + 1) - 1 + this.mb_x * 2;
        this.blockIndex[1] = this.blockIndex[0] + 1;
        this.blockIndex[2] = this.blockIndex[0] + this.blockWrap[0];
        this.blockIndex[3] = this.blockIndex[2] + 1;
        this.blockIndex[4] = this.blockWrap[0] * (this.mbHeight * 2 + 2) + this.blockWrap[4] * (this.mb_y + 1) + this.mb_x;
        this.blockIndex[5] = this.blockIndex[4] + this.blockWrap[4] * (this.mbHeight + 2);
        this.mb_skip_run = 0;
        boolean bl = false;
        block3: while (!bl && this.mb_y << (this.field_pic ? 1 : 0) < this.mbHeight) {
            int n3;
            int n4;
            if (this.mb_x > this.mbWidth) {
                System.out.println("X too large");
            }
            for (n4 = 0; n4 < 6; ++n4) {
                for (n3 = 0; n3 < 64; ++n3) {
                    this.block[n4][n3] = 0;
                }
            }
            this.mpeg_decode_mb();
            if (this.pict_type != 3) {
                int n5;
                int n6;
                n4 = this.blockWrap[0];
                n3 = this.mb_x * 2 + 1 + (this.mb_y * 2 + 1) * n4;
                if (this.mb_intra) {
                    n6 = 0;
                    n5 = 0;
                } else if (this.mv_type == 0) {
                    n6 = this.mv[0];
                    n5 = this.mv[1];
                } else {
                    n6 = this.mv[0] + this.mv[2];
                    n5 = this.mv[1] + this.mv[3];
                    n6 = n6 >> 1 | n6 & 1;
                }
                this.motion_val[n3][0] = n6;
                this.motion_val[n3][1] = n5;
                this.motion_val[n3 + 1][0] = n6;
                this.motion_val[n3 + 1][1] = n5;
                this.motion_val[n3 + n4][0] = n6;
                this.motion_val[n3 + n4][1] = n5;
                this.motion_val[n3 + n4 + 1][0] = n6;
                this.motion_val[n3 + n4 + 1][1] = n5;
            }
            this.MPV_decode_mb();
            if (++this.mb_x >= this.mbWidth) {
                this.mb_x = 0;
                ++this.mb_y;
                if (this.mb_y << (this.field_pic ? 1 : 0) >= this.mbHeight) {
                    bl = true;
                    break;
                }
            }
            if (this.mb_skip_run != -1) continue;
            this.mb_skip_run = 0;
            do {
                if ((n2 = this.in.getVLC(this.mbincr_vlc)) <= 33) {
                    this.mb_skip_run += n2;
                }
                if (n2 != 35) continue;
                bl = true;
                continue block3;
            } while (n2 >= 33);
        }
        this.in.seek((this.in.getPos() / 8 - 2) * 8);
    }

    public void decodeFrame(byte[] byArray, int n) throws FFMpegException {
        int n2;
        if (!this.notConsumed) {
            this.in.addData(byArray, 0, n);
            n2 = this.in.getPos() + this.in.availableBits() - n * 8;
            this.lastFullFrame = 0;
            boolean bl = false;
            boolean bl2 = false;
            for (int i = 0; i < n - 6; ++i) {
                if (byArray[i] != 0 || byArray[i + 1] != 0 || byArray[i + 2] != 1) continue;
                byte by = byArray[i + 3];
                if (by == 0) {
                    if (!bl) {
                        this.lastFullFrame = i * 8 + n2;
                    }
                    bl = false;
                }
                if (bl || by != -77 && by != -72) continue;
                bl = true;
                this.lastFullFrame = i * 8 + n2;
                this.findSequenceHeader = false;
            }
        }
        if (this.lastFullFrame == 0 || this.findSequenceHeader) {
            this.pict_type = -1;
            this.lastFullFrame = 0;
            return;
        }
        this.notConsumed = false;
        n2 = 0;
        block8: while (n2 == 0 && this.in.availableBits() > 24) {
            do {
                if (this.in.showBits(24) == 1) {
                    this.in.getBits(24);
                    this.currentHeader = this.in.getBits(8);
                    continue;
                }
                this.in.getBits(8 - this.in.getPos() % 8);
                this.currentHeader = -1;
            } while (this.currentHeader == -1);
            switch (this.currentHeader) {
                case 179: {
                    this.mpeg1_decode_sequence();
                    continue block8;
                }
                case 0: {
                    this.mpeg1_decode_picture();
                    continue block8;
                }
                case 181: {
                    this.mpeg_decode_extension();
                    continue block8;
                }
                case 178: {
                    continue block8;
                }
                case 184: {
                    this.first_field = false;
                    continue block8;
                }
            }
            if (this.currentHeader < 1 || this.currentHeader > 175) continue;
            this.mpeg_decode_slice(this.currentHeader - 1);
            if (this.mb_y < this.mbHeight) continue;
            n2 = 1;
        }
        while (this.in.showBits(24) != 1) {
            this.in.getBits(8 - this.in.getPos() % 8);
        }
    }

    public Format[] getSupportedInputFormats() {
        return new Format[]{new VideoFormat("mpeg")};
    }

    public Format[] getSupportedOutputFormats(Format format) {
        return new Format[]{new RGBFormat()};
    }

    public Format setInputFormat(Format format) {
        this.inputFormat = (VideoFormat)format;
        this.initialise((int)this.inputFormat.getSize().getWidth(), (int)this.inputFormat.getSize().getHeight());
        if (this.inputFormat.getFrameRate() > 0.0f) {
            this.frameRate = this.inputFormat.getFrameRate();
        }
        return format;
    }

    public Format setOutputFormat(Format format) {
        return new RGBFormat(new Dimension(this.mbWidth * 16, this.mbHeight * 16), -1, new int[0].getClass(), this.inputFormat.getFrameRate(), 32, 0xFF0000, 65280, 255);
    }

    public int process(Buffer buffer, Buffer buffer2) {
        if ((buffer.getFlags() & 0x200) != 0) {
            this.reset();
        }
        buffer2.setFlags(buffer.getFlags());
        if ((buffer.getFlags() & 0x40) == 0) {
            if (this.lastTime != buffer.getTimeStamp()) {
                this.lastTime = buffer.getTimeStamp();
                this.frames = 0;
            } else {
                buffer2.setFlags(buffer.getFlags() | 0x100 | 0x20);
            }
            buffer2.setTimeStamp(buffer.getTimeStamp() + (long)(1.0E9f / this.frameRate) * (long)this.frames);
        }
        try {
            byte[] byArray = (byte[])buffer.getData();
            this.decodeFrame(byArray, buffer.getLength());
            if (this.pict_type == 1 || this.pict_type == 2) {
                this.displayOutput.showNextScreen(buffer2);
                this.displayOutput.endIPFrame();
            } else if (this.pict_type == 3) {
                if (!this.hurryUp) {
                    this.displayOutput.showScreen(buffer2);
                    this.displayOutput.endBFrame();
                } else {
                    this.displayOutput.endBFrame();
                    buffer2.setLength(0);
                }
            } else {
                buffer2.setLength(0);
                this.numberOfFramesDelivered = 0;
                return 0;
            }
            if (this.pict_type == 1 && this.skipToIFrame != 0) {
                --this.skipToIFrame;
            }
            if (this.pict_type == 2 && this.skipToIFrame == 1) {
                --this.skipToIFrame;
            }
            if (this.skipToIFrame != 0) {
                buffer2.setLength(0);
                buffer2.setFlags(64);
                this.frames = 0;
            }
        }
        catch (Error error) {
            error.printStackTrace();
            this.in = new BitStream();
            buffer2.setLength(0);
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.in = new BitStream();
            buffer2.setLength(0);
            return 0;
        }
        ++this.numberOfFramesDelivered;
        ++this.frames;
        if (this.in.getPos() < this.lastFullFrame) {
            this.notConsumed = true;
            return 2;
        }
        this.hurryUp = false;
        this.numberOfFramesDelivered = 0;
        return 0;
    }

    public void open() {
    }

    public void close() {
    }

    public void reset() {
        this.frames = 0;
        this.in.seek(this.in.getPos() + this.in.availableBits());
        this.skipToIFrame = 2;
    }

    public String getName() {
        return "MPEG video decoder";
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String string) {
        return null;
    }

    public boolean isCodecAvailable() {
        return true;
    }

    public void setVideoSize(Dimension dimension) {
        this.setInputFormat((Format)new VideoFormat("MPEG", dimension, -1, new byte[0].getClass(), 0.0f));
    }

    public void setEncoding(String string) {
    }

    public void setIsRtp(boolean bl) {
    }

    public void setIsTruncated(boolean bl) {
    }
}

