# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Olivier Tilloy <olivier@fluendo.com>

"""
A welcome screen.
"""

from elisa.core.utils import defer
from elisa.core.utils.i18n import install_translation

from elisa.plugins.poblesec.configuration.list import ChoiceModel, ListScreen


_ = install_translation('poblesec')


class WelcomeScreen(ListScreen):

    """
    A welcome screen to be displayed as the first step of a standard
    configuration wizard.
    """

    actions = ['next', 'quit']

    def setup(self):
        self.title = _('Welcome!')
        self.summary = _('We will now guide you through a very short setup '
                         'procedure which will allow you to get the most out '
                         'of your Moovida media center experience.')

        continue_option = ChoiceModel()
        continue_option.label = _('Continue')
        continue_option.action = 'next'
        quit_option = ChoiceModel()
        quit_option.label = _('Cancel & Quit The Application')
        quit_option.action = 'quit'
        self.set_model([continue_option, quit_option])

        return defer.succeed(self)

    def save(self):
        # We don't actually want to save anything.
        pass

    def handle_input_cancel(self):
        # This screen is meant to be used as the first one, cannot go back.
        pass
