/* ethos-plugin.h
 *
 * Copyright (C) 2009 Christian Hergert <chris@dronelabs.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 
 * 02110-1301 USA
 */

#ifndef __ETHOS_PLUGIN_H__
#define __ETHOS_PLUGIN_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define ETHOS_TYPE_PLUGIN		(ethos_plugin_get_type ())
#define ETHOS_PLUGIN(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), ETHOS_TYPE_PLUGIN, EthosPlugin))
#define ETHOS_PLUGIN_CONST(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), ETHOS_TYPE_PLUGIN, EthosPlugin const))
#define ETHOS_PLUGIN_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  ETHOS_TYPE_PLUGIN, EthosPluginClass))
#define ETHOS_IS_PLUGIN(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), ETHOS_TYPE_PLUGIN))
#define ETHOS_IS_PLUGIN_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  ETHOS_TYPE_PLUGIN))
#define ETHOS_PLUGIN_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  ETHOS_TYPE_PLUGIN, EthosPluginClass))

typedef struct _EthosPlugin		EthosPlugin;
typedef struct _EthosPluginClass	EthosPluginClass;
typedef struct _EthosPluginPrivate	EthosPluginPrivate;

struct _EthosPlugin
{
	GObject parent;

	/*< private >*/
	EthosPluginPrivate *priv;
};

struct _EthosPluginClass
{
	GObjectClass parent_class;

	void (*activated)   (EthosPlugin *plugin);
	void (*deactivated) (EthosPlugin *plugin);

	void (*reserved1)   (void);
	void (*reserved2)   (void);
	void (*reserved3)   (void);
	void (*reserved4)   (void);
};

GType ethos_plugin_get_type   (void) G_GNUC_CONST;
void  ethos_plugin_activate   (EthosPlugin *plugin);
void  ethos_plugin_deactivate (EthosPlugin *plugin);

G_END_DECLS

#endif /* __ETHOS_PLUGIN_H__ */
