<?php
	class AttachItemListModule extends ListModule
	{
		/**
		 * Constructor
		 * @param int $id nique id.
		 * @param array		$data list of all actions.
		 */
		function AttachItemListModule($id, $data)
		{
			parent::ListModule($id, $data, array(OBJECT_SAVE, TABLE_SAVE, TABLE_DELETE));
		}

		/**
		 * Executes all the actions in the $data variable.
		 * @return boolean true on success or false on failure.
		 */
		function execute()
		{
			foreach($this->data as $actionType => $action)
			{
				if(isset($actionType)) {
					try {
						$store = $this->getActionStore($action);
						$parententryid = $this->getActionParentEntryID($action);
						$entryid = $this->getActionEntryID($action);

						switch($actionType) {
							case "list":
								// get properties info
								$this->getPropertiesForMessageType($store, $entryid, $action);
								// @TODO:	get the sort data from sort settings
								//			not working now, as of sorting is not suppported by table widget.
								$this->sort[$this->properties["subject"]] = TABLE_SORT_ASCEND;
		
								$this->messageList($store, $entryid, $action, $actionType);
								break;

							case "attach_items":
								$this->attach($store, $parententryid, $action);
								break;
							default:
								$this->handleUnknownActionType($actionType);
						}
					} catch (MAPIException $e) {
						$this->processException($e, $actionType);
					}
				}
			}
		}

		/**
		 * Function will set properties for particular message class
		 * @param Object $store MAPI Message Store Object
		 * @param HexString $entryid entryid of the folder
		 * @param Array $action the action data, sent by the client
		 */
		function getPropertiesForMessageType($store, $entryid, $action)
		{
			if(isset($action["container_class"])) {
				$messageType = $action["container_class"];

				switch($messageType) {
					case "IPF.Appointment":
						$this->properties = $GLOBALS["properties"]->getAppointmentProperties();
						break;
					case "IPF.Contact":
						$this->properties = $GLOBALS["properties"]->getContactProperties();
						break;
					case "IPF.Journal":		// not implemented
						break;
					case "IPF.Task":
						$this->properties = $GLOBALS["properties"]->getTaskProperties();
						break;
					case "IPF.StickyNote":
						$this->properties = $GLOBALS["properties"]->getStickyNoteProperties();
						break;
					case "IPF.Note":
					default:
						$this->properties = $GLOBALS["properties"]->getMailProperties();
						break;
				}
			}
		}

		/**
		 * Function which sets selected messages as attachment to the item
		 * @param object $store MAPI Message Store Object
		 * @param string $parententryid entryid of the message
		 * @param array $action the action data, sent by the client
		 * @return boolean true on success or false on failure 
		 */
		function attach($store, $parententryid, $action)
		{
			if($store){
				if(isset($action["entryids"]) && $action["entryids"]){
					
					if(!is_array($action["entryids"])){
						$action["entryids"] = array($action["entryids"]);
					}
					if($action["type"] == "attachment"){

						//add attach items to session variables
						$attachments = $GLOBALS["operations"]->setAttachmentInSession($store, $action["entryids"], $action["dialog_attachments"]);

						$data = array();
						$data["item"] = array();
						$data["item"]["parententryid"] = bin2hex($parententryid);
						$data["item"]["attachments"] = array_merge($data["item"]["attachments"], $attachments);

						$this->addActionData("attach_items", $data);
						$GLOBALS["bus"]->addData($this->getResponseData());
					}else{
						$data = array();
						$data["item"] = array();

						foreach($action["entryids"] as $key => $item){
							$message = mapi_msgstore_openentry($store, hex2bin($item));
							$items = array();
							$items = $GLOBALS["operations"]->getMessageProps($store, $message, $this->properties, true);

							array_push($data["item"], $items);
						}

						$this->addActionData("attach_items_in_body", $data);
						$GLOBALS["bus"]->addData($this->getResponseData());
					}
				}
			}
		}
	}
?>
