/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.functions.Function;
import org.icepdf.core.pobjects.graphics.DeviceN;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.pobjects.graphics.ShadingPattern;
import org.icepdf.core.pobjects.graphics.batik.ext.awt.MultipleGradientPaint;
import org.icepdf.core.pobjects.graphics.batik.ext.awt.RadialGradientPaint;
import org.icepdf.core.util.Library;

public class ShadingType3Pattern
extends ShadingPattern {
    private static final Logger logger = Logger.getLogger(ShadingType3Pattern.class.toString());
    protected Function function;
    protected Vector<Number> domain;
    protected Vector coords;
    protected Vector<Boolean> extend;
    protected RadialGradientPaint radialGradientPaint;

    public ShadingType3Pattern(Library library, Hashtable hashtable) {
        super(library, hashtable);
    }

    public synchronized void init() {
        if (this.inited) {
            return;
        }
        if (this.shading == null) {
            this.shading = this.library.getDictionary(this.entries, "Shading");
        }
        this.shadingType = this.library.getInt(this.shading, "ShadingType");
        this.bBox = this.library.getRectangle(this.shading, "BBox");
        this.colorSpace = PColorSpace.getColorSpace(this.library, this.library.getObject(this.shading, "ColorSpace"));
        if (this.library.getObject(this.shading, "Background") != null && this.library.getObject(this.shading, "Background") instanceof Vector) {
            this.background = (Vector)this.library.getObject(this.shading, "Background");
        }
        this.antiAlias = this.library.getBoolean(this.shading, "AntiAlias");
        if (this.library.getObject(this.shading, "Domain") instanceof Vector) {
            this.domain = (Vector)this.library.getObject(this.shading, "Domain");
        } else {
            this.domain = new Vector(2);
            this.domain.add(new Float(0.0));
            this.domain.add(new Float(1.0));
        }
        if (this.library.getObject(this.shading, "Coords") instanceof Vector) {
            this.coords = (Vector)this.library.getObject(this.shading, "Coords");
        }
        if (this.library.getObject(this.shading, "Extend") instanceof Vector) {
            this.extend = (Vector)this.library.getObject(this.shading, "Extend");
        } else {
            this.extend = new Vector(2);
            this.extend.add(false);
            this.extend.add(false);
        }
        Object object = this.library.getObject(this.shading, "Function");
        if (object != null) {
            this.function = Function.getFunction(this.library, object);
        }
        float f = this.domain.get(0).floatValue();
        float f2 = this.domain.get(1).floatValue();
        float[] fArray = new float[]{0.0f, 0.5f, 1.0f};
        Point2D.Float float_ = new Point2D.Float(((Number)this.coords.get(0)).floatValue(), ((Number)this.coords.get(1)).floatValue());
        Point2D.Float float_2 = new Point2D.Float(((Number)this.coords.get(3)).floatValue(), ((Number)this.coords.get(4)).floatValue());
        float f3 = ((Number)this.coords.get(5)).floatValue();
        float f4 = ((Number)this.coords.get(3)).floatValue();
        if (f4 > f3) {
            f3 = f4;
        }
        Color color = this.calculateColour(this.colorSpace, fArray[0], f, f2);
        Color color2 = this.calculateColour(this.colorSpace, fArray[1], f, f2);
        Color color3 = this.calculateColour(this.colorSpace, fArray[2], f, f2);
        if (color == null || color2 == null || color3 == null) {
            return;
        }
        Color[] colorArray = new Color[]{color, color3, color2};
        this.radialGradientPaint = new RadialGradientPaint(float_, f3, float_2, fArray, colorArray, MultipleGradientPaint.NO_CYCLE, MultipleGradientPaint.LINEAR_RGB, this.matrix);
        this.inited = true;
    }

    private Color calculateColour(PColorSpace pColorSpace, float f, float f2, float f3) {
        float f4 = this.parametrixValue(f, f2, f3, this.extend);
        float[] fArray = new float[]{f4};
        if (this.function != null) {
            float[] fArray2 = this.function.calculate(fArray);
            if (fArray2 != null) {
                if (!(pColorSpace instanceof DeviceN)) {
                    fArray2 = PColorSpace.reverse(fArray2);
                }
                return pColorSpace.getColor(fArray2);
            }
            return null;
        }
        logger.fine("Error processing Shading Type 3 Pattern.");
        return null;
    }

    private float parametrixValue(float f, float f2, float f3, Vector vector) {
        return f2 + (f3 - f2) * f;
    }

    public Paint getPaint() {
        this.init();
        return this.radialGradientPaint;
    }

    public String toSting() {
        return super.toString() + "\n                    domain: " + this.domain + "\n                    coords: " + this.coords + "\n                    extend: " + this.extend + "\n                 function: " + this.function;
    }
}

