/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts.ofont;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.io.SeekableInput;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Parser;
import org.icepdf.core.util.Utils;

class CMap
extends Dictionary
implements org.icepdf.core.pobjects.fonts.CMap {
    private static final Logger logger = Logger.getLogger(CMap.class.toString());
    private Map cIdSystemInfo;
    private String cMapName;
    private float cMapType;
    private Object useCMap;
    private int wMode;
    private int[][] codeSpaceRange;
    private Map<Integer, Integer> bfChars;
    private List<CMapRange> bfRange;
    private Map cIdChars;
    private Map cIdRange;
    private Hashtable notDefChars;
    private Hashtable notDefRange;
    private Stream cMapStream;
    private InputStream cMapInputStream;

    public CMap(Library library, Hashtable hashtable, Stream stream) {
        super(library, hashtable);
        this.cMapStream = stream;
    }

    public CMap(Library library, Hashtable hashtable, InputStream inputStream) {
        super(library, hashtable);
        this.cMapInputStream = inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        try {
            Object object;
            Object object2;
            Object object3;
            if (this.cMapInputStream == null) {
                this.cMapInputStream = this.cMapStream.getInputStreamForDecodedStreamBytes();
            }
            if (logger.isLoggable(Level.FINER)) {
                if (this.cMapInputStream instanceof SeekableInput) {
                    object3 = Utils.getContentFromSeekableInput((SeekableInput)((Object)this.cMapInputStream), false);
                } else {
                    object2 = new InputStream[]{this.cMapInputStream};
                    object3 = Utils.getContentAndReplaceInputStream((InputStream[])object2, false);
                    this.cMapInputStream = object2[0];
                }
                logger.finer("<------------------------ CMap");
                logger.finer((String)object3);
                logger.finer("CMap ------------------------>  ");
            }
            object3 = new Parser(this.cMapInputStream);
            object2 = null;
            while ((object = ((Parser)object3).getStreamObject()) != null) {
                String string = object.toString();
                if (string.toLowerCase().indexOf("cidsysteminfo") >= 0) {
                    object = ((Parser)object3).getStreamObject();
                    this.cIdSystemInfo = (Hashtable)object;
                    object = ((Parser)object3).getStreamObject();
                }
                if (object instanceof Name) {
                    string = object.toString();
                    if (string.toLowerCase().indexOf("cmapname") >= 0) {
                        object = ((Parser)object3).getStreamObject();
                        this.cMapName = object.toString();
                        object = ((Parser)object3).getStreamObject();
                    }
                    if (string.toLowerCase().indexOf("cmaptype") >= 0) {
                        object = ((Parser)object3).getStreamObject();
                        this.cMapType = Float.parseFloat(object.toString());
                        object = ((Parser)object3).getStreamObject();
                    }
                    if (string.toLowerCase().indexOf("usemap") >= 0) {
                        // empty if block
                    }
                }
                if (object instanceof String) {
                    Object object4;
                    int n;
                    int n2;
                    String string2 = (String)object;
                    if (string2.equalsIgnoreCase("begincodespacerange")) {
                        n2 = (int)Float.parseFloat(object2.toString());
                        this.codeSpaceRange = new int[n2][2];
                        for (n = 0; n < n2; ++n) {
                            object = ((Parser)object3).getStreamObject();
                            object4 = (StringObject)object;
                            int n3 = object4.getUnsignedInt(0, object4.getLength());
                            object = ((Parser)object3).getStreamObject();
                            object4 = (StringObject)object;
                            int n4 = object4.getUnsignedInt(0, object4.getLength());
                            this.codeSpaceRange[n][0] = n3;
                            this.codeSpaceRange[n][1] = n4;
                        }
                    }
                    if (string2.equalsIgnoreCase("beginbfchar")) {
                        n2 = (int)Float.parseFloat(object2.toString());
                        if (this.bfChars == null) {
                            this.bfChars = new HashMap<Integer, Integer>(n2);
                        }
                        for (n = 0; n < n2; ++n) {
                            object = ((Parser)object3).getStreamObject();
                            object4 = (StringObject)object;
                            Integer n5 = object4.getUnsignedInt(0, object4.getLength());
                            object = ((Parser)object3).getStreamObject();
                            object4 = (StringObject)object;
                            Integer n6 = null;
                            try {
                                n6 = object4.getUnsignedInt(0, object4.getLength());
                            }
                            catch (NumberFormatException numberFormatException) {
                                logger.log(Level.FINE, "CMAP: ", numberFormatException);
                            }
                            this.bfChars.put(n5, n6);
                        }
                    }
                    if (string2.equalsIgnoreCase("beginbfrange")) {
                        n2 = (int)Float.parseFloat(object2.toString());
                        if (this.bfRange == null) {
                            this.bfRange = new ArrayList<CMapRange>(n2);
                        }
                        for (int i = 0; i < n2 && (object = ((Parser)object3).getStreamObject()) instanceof StringObject; ++i) {
                            StringObject stringObject = (StringObject)object;
                            object4 = stringObject.getUnsignedInt(0, stringObject.getLength());
                            object = ((Parser)object3).getStreamObject();
                            if (!(object instanceof StringObject)) break;
                            stringObject = (StringObject)object;
                            Integer n7 = stringObject.getUnsignedInt(0, stringObject.getLength());
                            object = ((Parser)object3).getStreamObject();
                            if (object instanceof Vector) {
                                this.bfRange.add(new CMapRange(((Integer)object4).intValue(), (int)n7, (Vector)object));
                                break;
                            }
                            stringObject = (StringObject)object;
                            Integer n8 = stringObject.getUnsignedInt(0, stringObject.getLength());
                            this.bfRange.add(new CMapRange(((Integer)object4).intValue(), (int)n7, n8));
                        }
                    }
                    if (string2.equalsIgnoreCase("begincidchar")) {
                        // empty if block
                    }
                    if (string2.equalsIgnoreCase("begincidrange")) {
                        // empty if block
                    }
                    if (string2.equalsIgnoreCase("beginnotdefchar")) {
                        // empty if block
                    }
                    if (string2.equalsIgnoreCase("beginnotdefrange")) {
                        // empty if block
                    }
                }
                object2 = object;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.log(Level.SEVERE, "CMap parsing error", unsupportedEncodingException);
        }
        catch (IOException iOException) {
        }
        finally {
            if (this.cMapInputStream != null) {
                try {
                    this.cMapInputStream.close();
                }
                catch (IOException iOException) {
                    logger.log(Level.FINE, "Error clossing cmap stream", iOException);
                }
            }
        }
    }

    public char toSelector(char c) {
        if (this.cIdSystemInfo != null) {
            Object object;
            if (this.bfChars != null && (object = this.bfChars.get(c)) != null) {
                return (char)((Integer)object).intValue();
            }
            if (this.bfRange != null) {
                for (CMapRange cMapRange : this.bfRange) {
                    if (!cMapRange.inRange(c)) continue;
                    return (char)cMapRange.getCMapValue(c);
                }
            }
        }
        return c;
    }

    class CMapRange {
        int startRange = 0;
        int endRange = 0;
        int offsetValue = 0;
        Vector offsetVecor = null;

        public CMapRange(int n, int n2, int n3) {
            this.startRange = n;
            this.endRange = n2;
            this.offsetValue = n3;
        }

        public CMapRange(int n, int n2, Vector vector) {
            this.startRange = n;
            this.endRange = n2;
            this.offsetVecor = vector;
        }

        public boolean inRange(int n) {
            return n >= this.startRange && n <= this.endRange;
        }

        public int getCMapValue(int n) {
            if (this.offsetVecor != null) {
                StringObject stringObject = (StringObject)this.offsetVecor.elementAt(n - this.startRange);
                return stringObject.getUnsignedInt(0, stringObject.getLength());
            }
            int n2 = this.offsetValue + (n - this.startRange);
            return n2;
        }
    }
}

