/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmimemagic.detectors;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import net.sf.jmimemagic.MagicDetector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oro.text.perl.Perl5Util;

public class TextFileDetector
implements MagicDetector {
    private static Log log = LogFactory.getLog((Class)(class$net$sf$jmimemagic$detectors$TextFileDetector == null ? (class$net$sf$jmimemagic$detectors$TextFileDetector = TextFileDetector.class$("net.sf.jmimemagic.detectors.TextFileDetector")) : class$net$sf$jmimemagic$detectors$TextFileDetector));
    static /* synthetic */ Class class$net$sf$jmimemagic$detectors$TextFileDetector;

    public String getDisplayName() {
        return "Text File Detector";
    }

    public String getVersion() {
        return "0.1";
    }

    public String[] getHandledExtensions() {
        return new String[]{"txt", "text"};
    }

    public String[] getHandledTypes() {
        return new String[]{"text/plain"};
    }

    public String getName() {
        return "textfiledetector";
    }

    public String[] process(byte[] data, int offset, int length, long bitmask, char comparator, String mimeType, Map params) {
        log.debug((Object)"processing stream data");
        Perl5Util util = new Perl5Util();
        try {
            String s = new String(data, "UTF-8");
            if (!util.match("/[^[:ascii:][:space:]]/", s)) {
                return new String[]{"text/plain"};
            }
            return null;
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"TextFileDetector: failed to process data");
            return null;
        }
    }

    public String[] process(File file, int offset, int length, long bitmask, char comparator, String mimeType, Map params) {
        log.debug((Object)"processing file data");
        return new String[0];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

