/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmimemagic;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.jmimemagic.MagicException;
import net.sf.jmimemagic.MagicMatch;
import net.sf.jmimemagic.MagicMatchNotFoundException;
import net.sf.jmimemagic.MagicMatcher;
import net.sf.jmimemagic.MagicParseException;
import net.sf.jmimemagic.MagicParser;
import net.sf.jmimemagic.UnsupportedTypeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Magic {
    private static Log log = LogFactory.getLog((Class)(class$net$sf$jmimemagic$Magic == null ? (class$net$sf$jmimemagic$Magic = Magic.class$("net.sf.jmimemagic.Magic")) : class$net$sf$jmimemagic$Magic));
    private static boolean initialized = false;
    private static MagicParser magicParser = null;
    private static HashMap hintMap = new HashMap();
    static /* synthetic */ Class class$net$sf$jmimemagic$Magic;

    public Magic() {
        log.debug((Object)"instantiated");
    }

    private static void addHint(String extension, MagicMatcher matcher) {
        if (hintMap.keySet().contains(extension)) {
            ArrayList a = (ArrayList)hintMap.get(extension);
            a.add(matcher);
        } else {
            ArrayList<MagicMatcher> a = new ArrayList<MagicMatcher>();
            a.add(matcher);
            hintMap.put(extension, a);
        }
    }

    public static synchronized void initialize() throws MagicParseException {
        log.debug((Object)"initialize()");
        if (!initialized) {
            log.debug((Object)"initializing");
            magicParser = new MagicParser();
            magicParser.initialize();
            Iterator i = magicParser.getMatchers().iterator();
            while (i.hasNext()) {
                MagicMatcher matcher = (MagicMatcher)i.next();
                String ext = matcher.getMatch().getExtension();
                if (ext != null && !ext.trim().equals("")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("adding hint mapping for extension '" + ext + "'"));
                    }
                    Magic.addHint(ext, matcher);
                    continue;
                }
                if (!matcher.getMatch().getType().equals("detector")) continue;
                String[] exts = matcher.getDetectorExtensions();
                for (int j = 0; j < exts.length; ++j) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("adding hint mapping for extension '" + exts[j] + "'"));
                    }
                    Magic.addHint(exts[j], matcher);
                }
            }
            initialized = true;
        }
    }

    public static Collection getMatchers() throws MagicParseException {
        log.debug((Object)"getMatchers()");
        if (!initialized) {
            Magic.initialize();
        }
        Iterator i = magicParser.getMatchers().iterator();
        ArrayList<Object> m = new ArrayList<Object>();
        while (i.hasNext()) {
            MagicMatcher matcher = (MagicMatcher)i.next();
            try {
                m.add(matcher.clone());
            }
            catch (CloneNotSupportedException e) {
                log.error((Object)"failed to clone matchers");
                throw new MagicParseException("failed to clone matchers");
            }
        }
        return m;
    }

    public static MagicMatch getMagicMatch(byte[] data) throws MagicParseException, MagicMatchNotFoundException, MagicException {
        return Magic.getMagicMatch(data, false);
    }

    public static MagicMatch getMagicMatch(byte[] data, boolean onlyMimeMatch) throws MagicParseException, MagicMatchNotFoundException, MagicException {
        log.debug((Object)"getMagicMatch(byte[])");
        if (!initialized) {
            Magic.initialize();
        }
        Collection matchers = magicParser.getMatchers();
        log.debug((Object)("getMagicMatch(byte[]): have " + matchers.size() + " matchers"));
        MagicMatcher matcher = null;
        MagicMatch match = null;
        Iterator i = matchers.iterator();
        while (i.hasNext()) {
            matcher = (MagicMatcher)i.next();
            log.debug((Object)("getMagicMatch(byte[]): trying to match: " + matcher.getMatch().getMimeType()));
            try {
                match = matcher.test(data, onlyMimeMatch);
                if (match == null) continue;
                log.debug((Object)("getMagicMatch(byte[]): matched " + matcher.getMatch().getMimeType()));
                return match;
            }
            catch (IOException e) {
                log.error((Object)("getMagicMatch(byte[]): " + e));
                throw new MagicException(e);
            }
            catch (UnsupportedTypeException e) {
                log.error((Object)("getMagicMatch(byte[]): " + e));
                throw new MagicException(e);
            }
        }
        throw new MagicMatchNotFoundException();
    }

    public static MagicMatch getMagicMatch(File file, boolean extensionHints) throws MagicParseException, MagicMatchNotFoundException, MagicException {
        return Magic.getMagicMatch(file, extensionHints, false);
    }

    public static MagicMatch getMagicMatch(File file, boolean extensionHints, boolean onlyMimeMatch) throws MagicParseException, MagicMatchNotFoundException, MagicException {
        log.debug((Object)"getMagicMatch(File)");
        if (!initialized) {
            Magic.initialize();
        }
        long start = System.currentTimeMillis();
        MagicMatcher matcher = null;
        MagicMatch match = null;
        ArrayList<MagicMatcher> checked = new ArrayList<MagicMatcher>();
        if (extensionHints) {
            log.debug((Object)"trying to use hints first");
            String name = file.getName();
            int pos = name.lastIndexOf(46);
            if (pos > -1) {
                String ext = name.substring(pos + 1, name.length());
                if (ext != null && !ext.equals("")) {
                    Collection c;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("using extension '" + ext + "' for hinting"));
                    }
                    if ((c = (Collection)hintMap.get(ext)) != null) {
                        Iterator i = c.iterator();
                        while (i.hasNext()) {
                            matcher = (MagicMatcher)i.next();
                            log.debug((Object)("getMagicMatch(File): trying to match: " + matcher.getMatch().getDescription()));
                            try {
                                match = matcher.test(file, onlyMimeMatch);
                                if (match != null) {
                                    log.debug((Object)("getMagicMatch(File): matched " + matcher.getMatch().getDescription()));
                                    if (log.isDebugEnabled()) {
                                        long end = System.currentTimeMillis();
                                        log.debug((Object)("found match in '" + (end - start) + "' milliseconds"));
                                    }
                                    return match;
                                }
                            }
                            catch (UnsupportedTypeException e) {
                                log.error((Object)("getMagicMatch(File): " + e));
                                throw new MagicException(e);
                            }
                            catch (IOException e) {
                                log.error((Object)("getMagicMatch(File): " + e));
                                throw new MagicException(e);
                            }
                            checked.add(matcher);
                        }
                    }
                } else {
                    log.debug((Object)"no file extension, ignoring hints");
                }
            } else {
                log.debug((Object)"no file extension, ignoring hints");
            }
        }
        Collection matchers = magicParser.getMatchers();
        log.debug((Object)("getMagicMatch(File): have " + matchers.size() + " matches"));
        Iterator i = matchers.iterator();
        while (i.hasNext()) {
            matcher = (MagicMatcher)i.next();
            if (!checked.contains(matcher)) {
                log.debug((Object)("getMagicMatch(File): trying to match: " + matcher.getMatch().getDescription()));
                try {
                    match = matcher.test(file, onlyMimeMatch);
                    if (match == null) continue;
                    log.debug((Object)("getMagicMatch(File): matched " + matcher.getMatch().getDescription()));
                    if (log.isDebugEnabled()) {
                        long end = System.currentTimeMillis();
                        log.debug((Object)("found match in '" + (end - start) + "' milliseconds"));
                    }
                    return match;
                }
                catch (UnsupportedTypeException e) {
                    log.error((Object)("getMagicMatch(File): " + e));
                    throw new MagicException(e);
                }
                catch (IOException e) {
                    log.error((Object)("getMagicMatch(File): " + e));
                    throw new MagicException(e);
                }
            }
            log.debug((Object)("getMagicMatch(File): already checked, skipping: " + matcher.getMatch().getDescription()));
        }
        throw new MagicMatchNotFoundException();
    }

    public static void printMagicFile(PrintStream stream) throws MagicParseException {
        if (!initialized) {
            Magic.initialize();
        }
        Collection matchers = Magic.getMatchers();
        log.debug((Object)("have " + matchers.size() + " matches"));
        MagicMatcher matcher = null;
        Iterator i = matchers.iterator();
        while (i.hasNext()) {
            matcher = (MagicMatcher)i.next();
            log.debug((Object)"printing");
            Magic.printMagicMatcher(stream, matcher, "");
        }
    }

    private static void printMagicMatcher(PrintStream stream, MagicMatcher matcher, String spacing) {
        stream.println(spacing + "name: " + matcher.getMatch().getDescription());
        stream.println(spacing + "children: ");
        Collection matchers = matcher.getSubMatchers();
        Iterator i = matchers.iterator();
        while (i.hasNext()) {
            Magic.printMagicMatcher(stream, (MagicMatcher)i.next(), spacing + "  ");
        }
    }

    public static void printMagicMatch(PrintStream stream, MagicMatch match, String spacing) {
        stream.println(spacing + "=============================");
        stream.println(spacing + "mime type: " + match.getMimeType());
        stream.println(spacing + "description: " + match.getDescription());
        stream.println(spacing + "extension: " + match.getExtension());
        stream.println(spacing + "test: " + new String(match.getTest().array()));
        stream.println(spacing + "bitmask: " + match.getBitmask());
        stream.println(spacing + "offset: " + match.getOffset());
        stream.println(spacing + "length: " + match.getLength());
        stream.println(spacing + "type: " + match.getType());
        stream.println(spacing + "comparator: " + match.getComparator());
        stream.println(spacing + "=============================");
        Collection submatches = match.getSubMatches();
        Iterator i = submatches.iterator();
        while (i.hasNext()) {
            Magic.printMagicMatch(stream, (MagicMatch)i.next(), spacing + "    ");
        }
    }

    public static void main(String[] args) {
        try {
            File f = new File(args[0]);
            if (f.exists()) {
                MagicMatch match = Magic.getMagicMatch(f, true, false);
                System.out.println("filename: " + args[0]);
                Magic.printMagicMatch(System.out, match, "");
            } else {
                System.err.println("file '" + f.getCanonicalPath() + "' not found");
            }
        }
        catch (MagicMatchNotFoundException e) {
            System.out.println("no match found");
        }
        catch (Exception e) {
            System.err.println("error: " + e);
            e.printStackTrace(System.err);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

