/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.util.MathUtils;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueString;

abstract class ValueStringBase
extends Value {
    protected String value;

    protected ValueStringBase(String value) {
        this.value = new String(value);
    }

    public String getSQL() {
        return StringUtils.quoteStringSQL(this.value);
    }

    public String getString() {
        return this.value;
    }

    public long getPrecision() {
        return this.value.length();
    }

    public Object getObject() {
        return this.value;
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setString(parameterIndex, this.value);
    }

    public Value convertPrecision(long precision) {
        if (precision == 0L || (long)this.value.length() <= precision) {
            return this;
        }
        int p = MathUtils.convertLongToInt(precision);
        return ValueString.get(this.value.substring(0, p));
    }

    public int getDisplaySize() {
        return this.value.length();
    }

    protected boolean isEqual(Value v) {
        return v instanceof ValueString && this.value.equals(((ValueString)v).value);
    }
}

