/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.util.ByteUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueBytes
extends Value {
    private byte[] value;
    private int hash;
    private static final ValueBytes EMPTY = new ValueBytes(new byte[0]);

    private ValueBytes(byte[] v) {
        this.value = v;
    }

    public String getSQL() {
        return "X'" + this.getString() + "'";
    }

    public byte[] getBytes() {
        return this.value;
    }

    public int getType() {
        return 12;
    }

    protected int compareSecure(Value v, CompareMode mode) {
        byte[] v2 = ((ValueBytes)v).value;
        return ByteUtils.compareNotNull(this.value, v2);
    }

    public String getString() {
        return ByteUtils.convertBytesToString(this.value);
    }

    public long getPrecision() {
        return this.value.length;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = ByteUtils.getByteArrayHash(this.value);
        }
        return this.hash;
    }

    public Object getObject() {
        return this.getBytes();
    }

    public void set(PreparedStatement prep, int parameterIndex) throws SQLException {
        prep.setBytes(parameterIndex, this.value);
    }

    public static ValueBytes get(byte[] b) {
        if (b.length == 0) {
            return EMPTY;
        }
        ValueBytes obj = new ValueBytes(b);
        if (b.length > 256) {
            return obj;
        }
        return (ValueBytes)Value.cache(obj);
    }

    public int getDisplaySize() {
        return this.value.length * 2;
    }

    protected boolean isEqual(Value v) {
        return v instanceof ValueBytes && ByteUtils.compareNotNull(this.value, ((ValueBytes)v).value) == 0;
    }
}

