/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.h2.engine.Constants;
import org.h2.message.Message;

public class StringUtils {
    public static boolean equals(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public static String getDefaultCharset() {
        return System.getProperty("file.encoding");
    }

    public static String quoteStringSQL(String s) {
        StringBuffer buff = new StringBuffer();
        buff.append('\'');
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\'') {
                buff.append(c);
            } else if (c < ' ' || c > '\u007f') {
                return "STRINGDECODE(" + StringUtils.quoteStringSQL(StringUtils.javaEncode(s)) + ")";
            }
            buff.append(c);
        }
        buff.append('\'');
        return buff.toString();
    }

    public static String javaEncode(String s) {
        StringBuffer buff = new StringBuffer(s.length());
        block9: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\b': {
                    buff.append("\\b");
                    continue block9;
                }
                case '\t': {
                    buff.append("\\t");
                    continue block9;
                }
                case '\n': {
                    buff.append("\\n");
                    continue block9;
                }
                case '\f': {
                    buff.append("\\f");
                    continue block9;
                }
                case '\r': {
                    buff.append("\\r");
                    continue block9;
                }
                case '\"': {
                    buff.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    buff.append("\\\\");
                    continue block9;
                }
                default: {
                    int ch = c & 0xFFFF;
                    if (ch >= 32 && ch < 128) {
                        buff.append(c);
                        continue block9;
                    }
                    if (ch < 255) {
                        buff.append("\\");
                        buff.append(Integer.toOctalString(0x200 | ch).substring(1));
                        continue block9;
                    }
                    buff.append("\\u");
                    buff.append(Integer.toHexString(0x10000 | ch).substring(1));
                }
            }
        }
        return buff.toString();
    }

    public static String addAsterix(String s, int index) {
        if (s != null && index < s.length()) {
            s = s.substring(0, index) + "[*]" + s.substring(index);
        }
        return s;
    }

    private static SQLException getFormatException(String s, int i) {
        return Message.getSQLException(90095, StringUtils.addAsterix(s, i));
    }

    public static String javaDecode(String s) throws SQLException {
        char c;
        StringBuffer buff = new StringBuffer(s.length());
        block14: for (int i = 0; i < s.length() && (c = s.charAt(i)) != '\"'; ++i) {
            if (c == '\\') {
                if (i >= s.length()) {
                    throw StringUtils.getFormatException(s, s.length() - 1);
                }
                c = s.charAt(++i);
                switch (c) {
                    case 't': {
                        buff.append('\t');
                        continue block14;
                    }
                    case 'r': {
                        buff.append('\r');
                        continue block14;
                    }
                    case 'n': {
                        buff.append('\n');
                        continue block14;
                    }
                    case 'b': {
                        buff.append('\b');
                        continue block14;
                    }
                    case 'f': {
                        buff.append('\f');
                        continue block14;
                    }
                    case '\"': {
                        buff.append('\"');
                        continue block14;
                    }
                    case '\\': {
                        buff.append('\\');
                        continue block14;
                    }
                    case 'u': {
                        try {
                            c = (char)Integer.parseInt(s.substring(i + 1, i + 5), 16);
                        }
                        catch (NumberFormatException e) {
                            throw StringUtils.getFormatException(s, i);
                        }
                        i += 4;
                        buff.append(c);
                        continue block14;
                    }
                    default: {
                        if (c >= '0' && c <= '9') {
                            try {
                                c = (char)Integer.parseInt(s.substring(i, i + 3), 8);
                            }
                            catch (NumberFormatException e) {
                                throw StringUtils.getFormatException(s, i);
                            }
                            i += 2;
                            buff.append(c);
                            continue block14;
                        }
                        throw StringUtils.getFormatException(s, i);
                    }
                }
            }
            buff.append(c);
        }
        return buff.toString();
    }

    public static String quoteJavaString(String s) {
        if (s == null) {
            return "null";
        }
        return "\"" + StringUtils.javaEncode(s) + "\"";
    }

    public static byte[] utf8Encode(String s) throws SQLException {
        try {
            return s.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw Message.convert(e);
        }
    }

    public static String utf8Decode(byte[] utf8) {
        try {
            return new String(utf8, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw Message.convertToInternal(e);
        }
    }

    public static String utf8Decode(byte[] bytes, int offset, int length) {
        try {
            return new String(bytes, offset, length, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw Message.convertToInternal(e);
        }
    }

    public static String quoteJavaStringArray(String[] array) {
        if (array == null) {
            return "null";
        }
        StringBuffer buff = new StringBuffer();
        buff.append("new String[]{");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(StringUtils.quoteJavaString(array[i]));
        }
        buff.append("}");
        return buff.toString();
    }

    public static String quoteJavaIntArray(int[] array) {
        if (array == null) {
            return "null";
        }
        StringBuffer buff = new StringBuffer();
        buff.append("new int[]{");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(array[i]);
        }
        buff.append("}");
        return buff.toString();
    }

    public static String enclose(String s) {
        if (s.startsWith("(")) {
            return s;
        }
        return "(" + s + ")";
    }

    public static String unEnclose(String s) {
        if (s.startsWith("(") && s.endsWith(")")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String urlDecode(String encoded) throws SQLException {
        byte[] buff = new byte[encoded.length()];
        int j = 0;
        for (int i = 0; i < encoded.length(); ++i) {
            char ch = encoded.charAt(i);
            if (ch == '+') {
                buff[j++] = 32;
                continue;
            }
            if (ch == '%') {
                buff[j++] = (byte)Integer.parseInt(encoded.substring(i + 1, i + 3), 16);
                i += 2;
                continue;
            }
            if (Constants.CHECK && (ch > '\u007f' || ch < ' ')) {
                throw new IllegalArgumentException("unexpected char " + ch + " decoding " + encoded);
            }
            buff[j++] = (byte)ch;
        }
        String s = StringUtils.utf8Decode(buff, 0, j);
        return s;
    }

    public static String[] arraySplit(String s, char separatorChar) {
        if (s == null) {
            return null;
        }
        if (s.length() == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>();
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == separatorChar) {
                list.add(buff.toString());
                buff.setLength(0);
                continue;
            }
            if (c == '\\' && i < s.length() - 1) {
                buff.append(s.charAt(++i));
                continue;
            }
            buff.append(c);
        }
        list.add(buff.toString());
        String[] array = new String[list.size()];
        list.toArray(array);
        return array;
    }

    public static String arrayCombine(String[] list, char separatorChar) {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < list.length; ++i) {
            String s;
            if (i > 0) {
                buff.append(separatorChar);
            }
            if ((s = list[i]) == null) {
                s = "";
            }
            for (int j = 0; j < s.length(); ++j) {
                char c = s.charAt(j);
                if (c == '\\' || c == separatorChar) {
                    buff.append('\\');
                }
                buff.append(c);
            }
        }
        return buff.toString();
    }

    public static String replaceAll(String s, String before, String after) {
        int index = 0;
        int next;
        while ((next = s.indexOf(before, index)) >= 0) {
            s = s.substring(0, next) + after + s.substring(next + before.length());
            index = next + after.length();
        }
        return s;
    }

    public static String formatDateTime(Date date, String format, String locale, String timezone) throws SQLException {
        SimpleDateFormat sdf = StringUtils.getDateFormat(format, locale, timezone);
        return sdf.format(date);
    }

    public static Date parseDateTime(String date, String format, String locale, String timezone) throws SQLException {
        SimpleDateFormat sdf = StringUtils.getDateFormat(format, locale, timezone);
        try {
            return sdf.parse(date);
        }
        catch (ParseException e) {
            throw Message.getSQLException(90014, date);
        }
    }

    private static SimpleDateFormat getDateFormat(String format, String locale, String timezone) throws SQLException {
        try {
            SimpleDateFormat df;
            if (locale == null) {
                df = new SimpleDateFormat(format);
            } else {
                Locale l = new Locale(locale);
                df = new SimpleDateFormat(format, l);
            }
            if (timezone != null) {
                df.setTimeZone(TimeZone.getTimeZone(timezone));
            }
            return df;
        }
        catch (Exception e) {
            throw Message.getSQLException(90014, format + "/" + locale + "/" + timezone);
        }
    }

    public static String xmlAttr(String name, String value) {
        return " " + name + "=\"" + StringUtils.xmlText(value) + "\"";
    }

    public static String xmlNode(String name, String attributes, String content) {
        String start;
        String string = start = attributes == null ? name : name + attributes;
        if (content == null) {
            return "<" + start + "/>\n";
        }
        if (content.indexOf(10) >= 0) {
            content = "\n" + StringUtils.indent(content);
        }
        return "<" + start + ">" + content + "</" + name + ">\n";
    }

    public static String indent(String s) {
        return StringUtils.indent(s, 4);
    }

    public static String indent(String s, int spaces) {
        StringBuffer buff = new StringBuffer(s.length() + spaces);
        int i = 0;
        while (i < s.length()) {
            for (int j = 0; j < spaces; ++j) {
                buff.append(' ');
            }
            int n = s.indexOf(10, i);
            n = n < 0 ? s.length() : n + 1;
            buff.append(s.substring(i, n));
            i = n;
        }
        if (!s.endsWith("\n")) {
            buff.append('\n');
        }
        return buff.toString();
    }

    public static String xmlComment(String data) {
        int idx = 0;
        while ((idx = data.indexOf("--", idx)) >= 0) {
            data = data.substring(0, idx + 1) + " " + data.substring(idx + 1);
        }
        if (data.indexOf(10) >= 0) {
            return "<!--\n" + StringUtils.indent(data) + "-->\n";
        }
        return "<!-- " + data + " -->\n";
    }

    public static String xmlCData(String data) {
        if (data.indexOf("]]>") >= 0) {
            return StringUtils.xmlText(data);
        }
        boolean newline = data.endsWith("\n");
        data = "<![CDATA[" + data + "]]>";
        return newline ? data + "\n" : data;
    }

    public static String xmlStartDoc() {
        return "<?xml version=\"1.0\"?>\n";
    }

    public static String xmlText(String text) {
        StringBuffer buff = new StringBuffer();
        block8: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    buff.append("&lt;");
                    continue block8;
                }
                case '>': {
                    buff.append("&gt;");
                    continue block8;
                }
                case '&': {
                    buff.append("&amp;");
                    continue block8;
                }
                case '\'': {
                    buff.append("&apos;");
                    continue block8;
                }
                case '\"': {
                    buff.append("&quot;");
                    continue block8;
                }
                case '\t': 
                case '\n': 
                case '\r': {
                    buff.append(ch);
                    continue block8;
                }
                default: {
                    if (ch < ' ' || ch > '\u007f') {
                        buff.append("&#x");
                        buff.append(Integer.toHexString(ch));
                        buff.append(';');
                        continue block8;
                    }
                    buff.append(ch);
                }
            }
        }
        return buff.toString();
    }
}

