/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import org.h2.message.Message;
import org.h2.message.TraceSystem;
import org.h2.util.MemoryFile;

public class FileUtils {
    public static HashMap memoryFiles = new HashMap();
    private static final String MEMORY_PREFIX = "inmemory:";
    private static final String MEMORY_PREFIX_2 = "mem:";

    public static RandomAccessFile openRandomAccessFile(String fileName, String mode) throws IOException {
        try {
            return new RandomAccessFile(fileName, mode);
        }
        catch (IOException e) {
            FileUtils.freeMemoryAndFinalize();
            return new RandomAccessFile(fileName, mode);
        }
    }

    public static FileWriter openFileWriter(String fileName, boolean append) throws IOException {
        try {
            return new FileWriter(fileName, append);
        }
        catch (IOException e) {
            FileUtils.freeMemoryAndFinalize();
            return new FileWriter(fileName, append);
        }
    }

    public static FileOutputStream openFileOutputStream(File file) throws IOException {
        try {
            return new FileOutputStream(file);
        }
        catch (IOException e) {
            FileUtils.freeMemoryAndFinalize();
            return new FileOutputStream(file);
        }
    }

    private static void freeMemoryAndFinalize() {
        long mem = Runtime.getRuntime().freeMemory();
        for (int i = 0; i < 16; ++i) {
            System.gc();
            long now = Runtime.getRuntime().freeMemory();
            Runtime.getRuntime().runFinalization();
            if (now == mem) break;
            mem = now;
        }
    }

    public static void rename(String oldName, String newName) throws SQLException {
        if (FileUtils.isInMemory(oldName)) {
            MemoryFile f = FileUtils.getMemoryFile(oldName);
            f.setName(newName);
            memoryFiles.put(newName, f);
            return;
        }
        File oldFile = new File(oldName);
        File newFile = new File(newName);
        if (oldFile.getName().equals(newFile.getName())) {
            throw Message.internal("rename file old=new");
        }
        if (oldFile.exists() && !newFile.exists()) {
            for (int i = 0; i < 16; ++i) {
                boolean ok = oldFile.renameTo(newFile);
                if (ok) {
                    return;
                }
                FileUtils.wait(i);
            }
        }
        throw Message.getSQLException(90024, new String[]{oldName, newName}, null);
    }

    public static synchronized Properties loadProperties(File file) throws IOException {
        Properties prop = new Properties();
        if (file.exists()) {
            FileInputStream in = new FileInputStream(file);
            prop.load(in);
            in.close();
        }
        return prop;
    }

    public static boolean getBooleanProperty(Properties prop, String key, boolean def) {
        String value = prop.getProperty(key, "" + def);
        try {
            return Boolean.valueOf(value);
        }
        catch (Exception e) {
            TraceSystem.traceThrowable(e);
            return def;
        }
    }

    public static int getIntProperty(Properties prop, String key, int def) {
        String value = prop.getProperty(key, "" + def);
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            TraceSystem.traceThrowable(e);
            return def;
        }
    }

    public static void createDirs(String fileName) throws SQLException {
        File f = new File(fileName);
        if (!f.exists()) {
            String parent = f.getParent();
            if (parent == null) {
                return;
            }
            File dir = new File(parent);
            for (int i = 0; i < 16; ++i) {
                if (dir.exists() || dir.mkdirs()) {
                    return;
                }
                FileUtils.wait(i);
            }
            throw Message.getSQLException(90062, parent);
        }
    }

    public static boolean createNewFile(String fileName) throws SQLException {
        if (FileUtils.isInMemory(fileName)) {
            if (FileUtils.exists(fileName)) {
                return false;
            }
            FileUtils.getMemoryFile(fileName);
            return true;
        }
        File file = new File(fileName);
        for (int i = 0; i < 8; ++i) {
            try {
                return file.createNewFile();
            }
            catch (IOException e) {
                FileUtils.wait(i);
                continue;
            }
        }
        return false;
    }

    public static void delete(String fileName) throws SQLException {
        if (FileUtils.isInMemory(fileName)) {
            memoryFiles.remove(fileName);
            return;
        }
        File file = new File(fileName);
        if (file.exists()) {
            for (int i = 0; i < 16; ++i) {
                boolean ok = file.delete();
                if (ok) {
                    return;
                }
                FileUtils.wait(i);
            }
            throw Message.getSQLException(90025, fileName);
        }
    }

    private static void wait(int i) {
        if (i > 8) {
            System.gc();
        }
        try {
            Thread.sleep(i * i);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static String getFileName(String name) throws SQLException {
        String separator = System.getProperty("file.separator");
        String path = FileUtils.getParent(name) + separator;
        String fullFileName = FileUtils.normalize(name);
        if (!fullFileName.startsWith(path)) {
            throw Message.internal("file utils error: " + fullFileName + " does not start with " + path);
        }
        String fileName = fullFileName.substring(path.length());
        return fileName;
    }

    public static File getFileInUserHome(String filename) {
        String userDir = System.getProperty("user.home");
        if (userDir == null) {
            return new File(filename);
        }
        return new File(userDir, filename);
    }

    public static String normalize(String fileName) throws SQLException {
        if (FileUtils.isInMemory(fileName)) {
            return fileName;
        }
        File f = new File(fileName);
        try {
            return f.getCanonicalPath();
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    public static void tryDelete(String fileName) {
        if (FileUtils.isInMemory(fileName)) {
            memoryFiles.remove(fileName);
            return;
        }
        new File(fileName).delete();
    }

    public static boolean isReadOnly(String fileName) {
        if (FileUtils.isInMemory(fileName)) {
            return false;
        }
        File f = new File(fileName);
        return f.exists() && !f.canWrite();
    }

    public static boolean exists(String fileName) {
        if (FileUtils.isInMemory(fileName)) {
            return memoryFiles.get(fileName) != null;
        }
        return new File(fileName).exists();
    }

    public static MemoryFile getMemoryFile(String fileName) {
        MemoryFile m = (MemoryFile)memoryFiles.get(fileName);
        if (m == null) {
            m = new MemoryFile(fileName);
            memoryFiles.put(fileName, m);
        }
        return m;
    }

    public static long length(String fileName) {
        if (FileUtils.isInMemory(fileName)) {
            return FileUtils.getMemoryFile(fileName).length();
        }
        return new File(fileName).length();
    }

    public static boolean isInMemory(String fileName) {
        return fileName.startsWith(MEMORY_PREFIX) || fileName.startsWith(MEMORY_PREFIX_2);
    }

    public static String createTempFile(String name, String suffix, boolean deleteOnExit) throws IOException {
        if (FileUtils.isInMemory(name = name + ".")) {
            int i = 0;
            while (true) {
                String n;
                if (!FileUtils.exists(n = name + i + suffix)) {
                    FileUtils.getMemoryFile(n);
                    return n;
                }
                ++i;
            }
        }
        String prefix = new File(name).getName();
        File dir = new File(name).getAbsoluteFile().getParentFile();
        File f = File.createTempFile(prefix, suffix, dir);
        if (deleteOnExit) {
            f.deleteOnExit();
        }
        return f.getCanonicalPath();
    }

    public static void deleteOnExit(String temp) {
        if (FileUtils.isInMemory(temp)) {
            return;
        }
        new File(temp).deleteOnExit();
    }

    public static String getParent(String fileName) {
        if (FileUtils.isInMemory(fileName)) {
            return MEMORY_PREFIX;
        }
        return new File(fileName).getParent();
    }

    public static String[] listFiles(String path) throws SQLException {
        if (FileUtils.isInMemory(path)) {
            String[] list = new String[memoryFiles.size()];
            MemoryFile[] l = new MemoryFile[memoryFiles.size()];
            memoryFiles.values().toArray(l);
            for (int i = 0; i < list.length; ++i) {
                list[i] = l[i].getName();
            }
            return list;
        }
        try {
            File[] files = new File(path).listFiles();
            if (files == null) {
                return new String[0];
            }
            String[] list = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                list[i] = files[i].getCanonicalPath();
            }
            return list;
        }
        catch (IOException e) {
            throw Message.convert(e);
        }
    }

    public static boolean isDirectory(String fileName) {
        if (FileUtils.isInMemory(fileName)) {
            return false;
        }
        return new File(fileName).isDirectory();
    }
}

