/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import org.h2.tools.FileBase;
import org.h2.util.FileUtils;

public class DeleteDbFiles
extends FileBase {
    private void showUsage() {
        System.out.println("java " + this.getClass().getName() + " [-dir <dir>] [-db <database>] [-quiet]");
    }

    public static void main(String[] args) throws Exception {
        new DeleteDbFiles().run(args);
    }

    private void run(String[] args) throws Exception {
        String dir = ".";
        String db = null;
        boolean quiet = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            if (args[i].equals("-dir")) {
                dir = args[++i];
                continue;
            }
            if (args[i].equals("-db")) {
                db = args[++i];
                continue;
            }
            if (args[i].equals("-quiet")) {
                quiet = true;
                continue;
            }
            this.showUsage();
            return;
        }
        DeleteDbFiles.execute(dir, db, quiet);
    }

    public static void execute(String dir, String db, boolean quiet) throws Exception {
        DeleteDbFiles delete = new DeleteDbFiles();
        delete.processFiles(dir, db, !quiet);
    }

    protected void process(String fileName) throws Exception {
        if (fileName.endsWith(".temp.db") || fileName.endsWith(".trace.db")) {
            FileUtils.tryDelete(fileName);
        } else {
            FileUtils.delete(fileName);
        }
    }

    protected boolean allFiles() {
        return true;
    }
}

