/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.h2.api.DatabaseEventListener;
import org.h2.test.TestBase;

public class TestExit
extends TestBase
implements DatabaseEventListener {
    static final int OPEN_WITH_CLOSE_ON_EXIT = 1;
    static final int OPEN_WITHOUT_CLOSE_ON_EXIT = 2;
    public static Connection conn;

    public void test() throws Exception {
        int ch;
        if (this.config.codeCoverage) {
            return;
        }
        String classPath = "bin" + File.pathSeparator + ".";
        this.deleteDb("exit");
        String[] procDef = new String[]{"java", "-cp", classPath, this.getClass().getName(), "1"};
        Process proc = Runtime.getRuntime().exec(procDef);
        while ((ch = proc.getErrorStream().read()) >= 0) {
            System.out.print((char)ch);
        }
        while ((ch = proc.getInputStream().read()) >= 0) {
            System.out.print((char)ch);
        }
        proc.waitFor();
        if (!TestExit.getClosedFile().exists()) {
            this.error("didnt close database");
        }
        procDef = new String[]{"java", "-cp", classPath, this.getClass().getName(), "2"};
        proc = Runtime.getRuntime().exec(procDef);
        proc.waitFor();
        if (TestExit.getClosedFile().exists()) {
            this.error("closed database");
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.exit(1);
        }
        int action = Integer.parseInt(args[0]);
        TestExit app = new TestExit();
        app.execute(action);
    }

    void execute(int action) throws Exception {
        Class.forName("org.h2.Driver");
        switch (action) {
            case 1: {
                conn = TestExit.open("jdbc:h2:exit;database_event_listener='" + this.getClass().getName() + "';db_close_on_exit=true");
                break;
            }
            case 2: {
                conn = TestExit.open("jdbc:h2:exit;database_event_listener='" + this.getClass().getName() + "';db_close_on_exit=false");
            }
        }
    }

    private static Connection open(String url) throws Exception {
        TestExit.getClosedFile().delete();
        return DriverManager.getConnection(url, "sa", "");
    }

    public void diskSpaceIsLow(long stillAvailable) throws SQLException {
    }

    public void exceptionThrown(SQLException e) {
    }

    public void closingDatabase() {
        try {
            TestExit.getClosedFile().createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static File getClosedFile() {
        return new File(BASE_DIR + "/closed.txt");
    }

    public void setProgress(int state, String name, int x, int max) {
    }
}

