/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import org.h2.test.TestBase;

public class TestKill
extends TestBase {
    Connection conn;
    int accounts = 10;
    Random random = new Random(1L);
    private String DIR = "synth";

    public void test() throws Exception {
        String connect = "";
        connect = ";MAX_LOG_SIZE=10;THROTTLE=80";
        String url = this.getURL(this.DIR + "/kill" + connect, true);
        String user = this.getUser();
        String password = this.getPassword();
        String[] procDef = new String[]{"java.exe", "-cp", "bin", "org.h2.test.synth.TestKillProcess", url, user, password, BASE_DIR, "" + this.accounts};
        int i = 0;
        while (true) {
            TestKill.printTime("TestKill " + i);
            if (i % 10 == 0) {
                this.trace("deleting db...");
                this.deleteDb(BASE_DIR, "kill");
            }
            this.conn = this.getConnection(url);
            this.createTables();
            this.checkData();
            this.initData();
            this.conn.close();
            Process proc = Runtime.getRuntime().exec(procDef);
            int runtime = this.random.nextInt(10000);
            this.trace("running...");
            Thread.sleep(runtime);
            this.trace("stopping...");
            proc.destroy();
            proc.waitFor();
            this.trace("stopped");
            ++i;
        }
    }

    private void createTables() throws SQLException {
        this.trace("createTables...");
        Statement stat = this.conn.createStatement();
        stat.execute("CREATE TABLE IF NOT EXISTS ACCOUNT(ID INT PRIMARY KEY, SUM INT)");
        stat.execute("CREATE TABLE IF NOT EXISTS LOG(ID IDENTITY, ACCOUNTID INT, AMOUNT INT, FOREIGN KEY(ACCOUNTID) REFERENCES ACCOUNT(ID))");
        stat.execute("CREATE TABLE IF NOT EXISTS TEST_A(ID INT PRIMARY KEY, DATA VARCHAR)");
        stat.execute("CREATE TABLE IF NOT EXISTS TEST_B(ID INT PRIMARY KEY, DATA VARCHAR)");
    }

    private void initData() throws SQLException {
        this.trace("initData...");
        this.conn.createStatement().execute("DROP TABLE LOG");
        this.conn.createStatement().execute("DROP TABLE ACCOUNT");
        this.conn.createStatement().execute("DROP TABLE TEST_A");
        this.conn.createStatement().execute("DROP TABLE TEST_B");
        this.createTables();
        PreparedStatement prep = this.conn.prepareStatement("INSERT INTO ACCOUNT VALUES(?, 0)");
        for (int i = 0; i < this.accounts; ++i) {
            prep.setInt(1, i);
            prep.execute();
        }
        PreparedStatement p1 = this.conn.prepareStatement("INSERT INTO TEST_A VALUES(?, '')");
        PreparedStatement p2 = this.conn.prepareStatement("INSERT INTO TEST_B VALUES(?, '')");
        for (int i = 0; i < this.accounts; ++i) {
            p1.setInt(1, i);
            p2.setInt(1, i);
            p1.execute();
            p2.execute();
        }
    }

    private void checkData() throws Exception {
        this.trace("checkData...");
        ResultSet rs = this.conn.createStatement().executeQuery("SELECT * FROM ACCOUNT ORDER BY ID");
        PreparedStatement prep = this.conn.prepareStatement("SELECT SUM(AMOUNT) FROM LOG WHERE ACCOUNTID=?");
        while (rs.next()) {
            int account = rs.getInt(1);
            int sum = rs.getInt(2);
            prep.setInt(1, account);
            ResultSet rs2 = prep.executeQuery();
            rs2.next();
            int sumLog = rs2.getInt(1);
            this.check(sumLog, sum);
            this.trace("account=" + account + " sum=" + sum);
        }
        PreparedStatement p1 = this.conn.prepareStatement("SELECT * FROM TEST_A WHERE ID=?");
        PreparedStatement p2 = this.conn.prepareStatement("SELECT * FROM TEST_B WHERE ID=?");
        for (int i = 0; i < this.accounts; ++i) {
            p1.setInt(1, i);
            p2.setInt(1, i);
            ResultSet r1 = p1.executeQuery();
            ResultSet r2 = p2.executeQuery();
            boolean hasData = r1.next();
            this.check(r2.next(), hasData);
            if (hasData) {
                String d1 = r1.getString("DATA");
                String d2 = r2.getString("DATA");
                this.check(d1, d2);
                this.checkFalse(r1.next());
                this.checkFalse(r2.next());
                this.trace("test: data=" + d1);
                continue;
            }
            this.trace("test: empty");
        }
    }
}

