/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import org.h2.test.TestBase;

public class TestJoin
extends TestBase {
    private ArrayList connections = new ArrayList();

    public void test() throws Exception {
        this.deleteDb("join");
        String shortestFailed = null;
        Connection c1 = this.getConnection("join");
        this.connections.add(c1);
        Class.forName("org.postgresql.Driver");
        Connection c2 = DriverManager.getConnection("jdbc:postgresql:test", "sa", "sa");
        this.connections.add(c2);
        this.execute("DROP TABLE TEST", true);
        this.execute("CREATE TABLE TEST(A INT PRIMARY KEY, B INT)");
        this.execute("INSERT INTO TEST VALUES(0, NULL)");
        this.execute("INSERT INTO TEST VALUES(1, 0)");
        this.execute("INSERT INTO TEST VALUES(2, 1)");
        this.execute("INSERT INTO TEST VALUES(3, 4");
        for (int i = 0; i < 10000; ++i) {
            int j;
            Random random = new Random(i);
            StringBuffer buff = new StringBuffer();
            buff.append("SELECT ");
            int tables = random.nextInt(10);
            for (j = 0; j <= tables; ++j) {
                if (j > 0) {
                    buff.append(", ");
                }
                buff.append("T" + (char)(48 + j) + ".A");
            }
            buff.append(" FROM TEST T0 ");
            for (j = 1; j < tables; ++j) {
                switch (random.nextInt(2)) {
                    case 0: {
                        buff.append("LEFT OUTER");
                        break;
                    }
                    case 1: {
                        buff.append("RIGHT OUTER");
                        break;
                    }
                    case 2: {
                        buff.append("INNER");
                    }
                }
                buff.append(" JOIN TEST T");
                buff.append((char)(48 + j));
                buff.append(" ON ");
                this.appendRandomCondition(buff, random, j);
            }
            if (random.nextBoolean()) {
                buff.append("WHERE ");
                this.appendRandomCondition(buff, random, tables - 1);
            }
            String sql = buff.toString();
            try {
                this.execute(sql);
                continue;
            }
            catch (Exception e) {
                if (shortestFailed != null && shortestFailed.length() <= sql.length()) continue;
                System.out.println("/*SHORT*/ " + sql);
                shortestFailed = sql;
            }
        }
        c1.close();
        c2.close();
    }

    private void appendRandomCondition(StringBuffer buff, Random random, int j) {
        int t1 = j <= 1 ? 0 : random.nextInt(j + 1);
        int t2 = j <= 1 ? 0 : random.nextInt(j + 1);
        String c1 = random.nextBoolean() ? "A" : "B";
        String c2 = random.nextBoolean() ? "A" : "B";
        buff.append("T" + (char)(48 + t1));
        buff.append("." + c1);
        buff.append("=");
        buff.append("T" + (char)(48 + t2));
        buff.append("." + c2);
        buff.append(" ");
    }

    private void execute(String sql) throws Exception {
        this.execute(sql, false);
    }

    private void execute(String sql, boolean ignoreDifference) throws Exception {
        String first = null;
        for (int i = 0; i < this.connections.size(); ++i) {
            String s;
            Connection conn = (Connection)this.connections.get(i);
            Statement stat = conn.createStatement();
            try {
                boolean result = stat.execute(sql);
                if (result) {
                    ResultSet rs = stat.getResultSet();
                    s = "rs: " + this.readResult(rs);
                } else {
                    s = "updateCount: " + stat.getUpdateCount();
                }
            }
            catch (SQLException e) {
                s = "exception";
            }
            if (i == 0) {
                first = s;
                continue;
            }
            if (ignoreDifference || s.equals(first)) continue;
            throw new Exception("FAIL");
        }
    }

    private String readResult(ResultSet rs) throws SQLException {
        int i;
        StringBuffer buff = new StringBuffer();
        ResultSetMetaData meta = rs.getMetaData();
        int columnCount = meta.getColumnCount();
        for (int i2 = 0; i2 < columnCount; ++i2) {
            if (i2 > 0) {
                buff.append(",");
            }
            buff.append(meta.getColumnLabel(i2 + 1).toUpperCase());
        }
        buff.append(":\n");
        String result = buff.toString();
        ArrayList<String> list = new ArrayList<String>();
        while (rs.next()) {
            buff = new StringBuffer();
            for (i = 0; i < columnCount; ++i) {
                if (i > 0) {
                    buff.append(",");
                }
                buff.append(rs.getString(i + 1));
            }
            list.add(buff.toString());
        }
        Collections.sort(list);
        for (i = 0; i < list.size(); ++i) {
            result = result + list.get(i) + "\n";
        }
        return result;
    }
}

