/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.h2.jdbc.JdbcConnection;
import org.h2.test.TestBase;
import org.h2.test.db.TestScript;
import org.h2.test.synth.RandomGen;

public class TestCrashAPI
extends TestBase {
    public static final Class[] INTERFACES = new Class[]{class$java$sql$Connection == null ? (class$java$sql$Connection = TestCrashAPI.class$("java.sql.Connection")) : class$java$sql$Connection, class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = TestCrashAPI.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement, class$java$sql$Statement == null ? (class$java$sql$Statement = TestCrashAPI.class$("java.sql.Statement")) : class$java$sql$Statement, class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = TestCrashAPI.class$("java.sql.ResultSet")) : class$java$sql$ResultSet, class$java$sql$ResultSetMetaData == null ? (class$java$sql$ResultSetMetaData = TestCrashAPI.class$("java.sql.ResultSetMetaData")) : class$java$sql$ResultSetMetaData, class$java$sql$Savepoint == null ? (class$java$sql$Savepoint = TestCrashAPI.class$("java.sql.Savepoint")) : class$java$sql$Savepoint};
    private ArrayList objects = new ArrayList();
    private HashMap classMethods = new HashMap();
    private RandomGen random = new RandomGen(null);
    private ArrayList statements = new ArrayList();
    private int openCount;
    private long callCount = 0L;
    private String DIR = "synth";
    static /* synthetic */ Class class$java$sql$Connection;
    static /* synthetic */ Class class$java$sql$PreparedStatement;
    static /* synthetic */ Class class$java$sql$Statement;
    static /* synthetic */ Class class$java$sql$ResultSet;
    static /* synthetic */ Class class$java$sql$ResultSetMetaData;
    static /* synthetic */ Class class$java$sql$Savepoint;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$sql$Array;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$sql$Clob;
    static /* synthetic */ Class class$java$sql$Blob;
    static /* synthetic */ Class class$java$util$Calendar;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Ref;

    private Connection getConnection(int seed, boolean delete) throws Exception {
        ++this.openCount;
        if (delete) {
            try {
                this.deleteDb(BASE_DIR + "/" + this.DIR, "crashapi" + (seed - 1));
                this.deleteDb(BASE_DIR + "/" + this.DIR, "crashapi" + seed);
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        String add = ";FILE_LOCK=NO;STORAGE=TEXT";
        String url = this.getURL(this.DIR + "/crashapi" + seed, true) + add;
        Connection conn = DriverManager.getConnection(url, "sa", "");
        int len = this.random.getInt(50);
        int start = this.random.getInt(this.statements.size() - len);
        int end = start + len;
        Statement stat = conn.createStatement();
        stat.execute("SET LOCK_TIMEOUT 10");
        stat.execute("SET WRITE_DELAY 0");
        for (int i = start; i < end && i < this.statements.size(); ++i) {
            try {
                stat.execute("SELECT * FROM TEST WHERE ID=1");
            }
            catch (Throwable t) {
                this.printIfBad(seed, -i, -1, t);
            }
            try {
                stat.execute("SELECT * FROM TEST WHERE ID=1 OR ID=1");
            }
            catch (Throwable t) {
                this.printIfBad(seed, -i, -1, t);
            }
            String sql = (String)this.statements.get(i);
            try {
                stat.execute(sql);
                continue;
            }
            catch (Throwable t) {
                this.printIfBad(seed, -i, -1, t);
            }
        }
        if (this.random.nextBoolean()) {
            try {
                conn.commit();
            }
            catch (Throwable t) {
                this.printIfBad(seed, 0, -1, t);
            }
        }
        return conn;
    }

    private void testOne(int seed) throws Exception {
        TestCrashAPI.printTime("TestCrashAPI " + seed);
        this.openCount = 0;
        this.random = new RandomGen(null);
        this.random.setSeed(seed);
        Connection c1 = this.getConnection(seed, true);
        Connection conn = null;
        for (int i = 0; i < 2000; ++i) {
            Object o;
            if (this.objects.size() == 0) {
                try {
                    conn = this.getConnection(seed, false);
                }
                catch (SQLException e) {
                    if (e.getSQLState().equals("08004")) {
                        try {
                            c1.createStatement().execute("SET PASSWORD ''");
                            conn = this.getConnection(seed, false);
                        }
                        catch (Throwable t) {
                            this.printIfBad(seed, -i, -1, t);
                        }
                    }
                    if (e.getSQLState().equals("90098")) break;
                    this.printIfBad(seed, -i, -1, e);
                }
                this.objects.add(conn);
            }
            int objectId = this.random.getInt(this.objects.size());
            if (this.random.getBoolean(1)) {
                this.objects.remove(objectId);
                continue;
            }
            if (this.random.getInt(2000) == 0) {
                ((JdbcConnection)conn).setPowerOffCount(this.random.getInt(50));
            }
            if ((o = this.objects.get(objectId)) == null) {
                this.objects.remove(objectId);
                continue;
            }
            Class in = this.getJdbcInterface(o);
            ArrayList methods = (ArrayList)this.classMethods.get(in);
            Method m = (Method)methods.get(this.random.getInt(methods.size()));
            Object o2 = this.callRandom(seed, i, objectId, o, m);
            if (o2 == null) continue;
            this.objects.add(o2);
        }
        try {
            if (conn != null) {
                conn.close();
            }
            c1.close();
        }
        catch (Throwable t) {
            this.printIfBad(seed, -101010, -1, t);
            try {
                this.deleteDb(null, "test");
            }
            catch (Throwable t2) {
                this.printIfBad(seed, -101010, -1, t2);
            }
        }
        this.objects.clear();
    }

    private void printError(int seed, int id, Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        String s = writer.toString();
        System.out.println("testOne(" + seed + "); // Bug " + s.hashCode() + " seed=" + seed + " id=" + id + " callCount=" + this.callCount + " openCount=" + this.openCount);
        t.printStackTrace();
    }

    private Object callRandom(int seed, int id, int objectId, Object o, Method m) throws Exception {
        Class<?>[] paramClasses = m.getParameterTypes();
        Object[] params = new Object[paramClasses.length];
        for (int i = 0; i < params.length; ++i) {
            params[i] = this.getRandomParam(id, paramClasses[i]);
        }
        Object result = null;
        try {
            ++this.callCount;
            result = m.invoke(o, params);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            this.printIfBad(seed, id, objectId, t);
        }
        if (result == null) {
            return null;
        }
        Class in = this.getJdbcInterface(result);
        if (in == null) {
            return null;
        }
        return result;
    }

    private void printIfBad(int seed, int id, int objectId, Throwable t) {
        if (!(t instanceof BatchUpdateException)) {
            if (t instanceof SQLException) {
                SQLException s = (SQLException)t;
                String state = s.getSQLState();
                if (state == null) {
                    this.printError(seed, id, s);
                } else if (state.equals("90008")) {
                    if (objectId >= 0) {
                        this.objects.remove(objectId);
                    }
                } else if (state.equals("HY000")) {
                    this.printError(seed, id, s);
                }
            } else {
                this.printError(seed, id, t);
            }
        }
    }

    private Object getRandomParam(int id, Class type) {
        if (type == Integer.TYPE) {
            return new Integer(this.random.getRandomInt());
        }
        if (type == Byte.TYPE) {
            return new Byte((byte)this.random.getRandomInt());
        }
        if (type == Short.TYPE) {
            return new Short((short)this.random.getRandomInt());
        }
        if (type == Long.TYPE) {
            return new Long(this.random.getRandomLong());
        }
        if (type == Float.TYPE) {
            return new Float(this.random.getRandomDouble());
        }
        if (type == Boolean.TYPE) {
            return new Boolean(this.random.nextBoolean());
        }
        if (type == Double.TYPE) {
            return new Double(this.random.getRandomDouble());
        }
        if (type == (class$java$lang$String == null ? (class$java$lang$String = TestCrashAPI.class$("java.lang.String")) : class$java$lang$String)) {
            if (this.random.getInt(10) == 0) {
                return null;
            }
            int randomId = this.random.getInt(this.statements.size());
            String sql = (String)this.statements.get(randomId);
            if (this.random.getInt(10) == 0) {
                sql = this.random.modify(sql);
            }
            return sql;
        }
        if (type == (array$I == null ? (array$I = TestCrashAPI.class$("[I")) : array$I)) {
            return this.random.getIntArray();
        }
        if (type == (class$java$io$Reader == null ? (class$java$io$Reader = TestCrashAPI.class$("java.io.Reader")) : class$java$io$Reader)) {
            return null;
        }
        if (type == (class$java$sql$Array == null ? (class$java$sql$Array = TestCrashAPI.class$("java.sql.Array")) : class$java$sql$Array)) {
            return null;
        }
        if (type == (array$B == null ? (array$B = TestCrashAPI.class$("[B")) : array$B)) {
            return this.random.getByteArray();
        }
        if (type == (class$java$util$Map == null ? (class$java$util$Map = TestCrashAPI.class$("java.util.Map")) : class$java$util$Map)) {
            return null;
        }
        if (type == (class$java$lang$Object == null ? (class$java$lang$Object = TestCrashAPI.class$("java.lang.Object")) : class$java$lang$Object)) {
            return null;
        }
        if (type == (class$java$sql$Date == null ? (class$java$sql$Date = TestCrashAPI.class$("java.sql.Date")) : class$java$sql$Date)) {
            return this.random.randomDate();
        }
        if (type == (class$java$sql$Time == null ? (class$java$sql$Time = TestCrashAPI.class$("java.sql.Time")) : class$java$sql$Time)) {
            return this.random.randomTime();
        }
        if (type == (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = TestCrashAPI.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
            return this.random.randomTimestamp();
        }
        if (type == (class$java$io$InputStream == null ? (class$java$io$InputStream = TestCrashAPI.class$("java.io.InputStream")) : class$java$io$InputStream)) {
            return null;
        }
        if (type == (array$Ljava$lang$String == null ? (array$Ljava$lang$String = TestCrashAPI.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
            return null;
        }
        if (type == (class$java$sql$Clob == null ? (class$java$sql$Clob = TestCrashAPI.class$("java.sql.Clob")) : class$java$sql$Clob)) {
            return null;
        }
        if (type == (class$java$sql$Blob == null ? (class$java$sql$Blob = TestCrashAPI.class$("java.sql.Blob")) : class$java$sql$Blob)) {
            return null;
        }
        if (type == (class$java$sql$Savepoint == null ? (class$java$sql$Savepoint = TestCrashAPI.class$("java.sql.Savepoint")) : class$java$sql$Savepoint)) {
            return null;
        }
        if (type == (class$java$util$Calendar == null ? (class$java$util$Calendar = TestCrashAPI.class$("java.util.Calendar")) : class$java$util$Calendar)) {
            return Calendar.getInstance();
        }
        if (type == (class$java$net$URL == null ? (class$java$net$URL = TestCrashAPI.class$("java.net.URL")) : class$java$net$URL)) {
            return null;
        }
        if (type == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TestCrashAPI.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return new BigDecimal("" + this.random.getRandomDouble());
        }
        if (type == (class$java$sql$Ref == null ? (class$java$sql$Ref = TestCrashAPI.class$("java.sql.Ref")) : class$java$sql$Ref)) {
            return null;
        }
        return null;
    }

    private Class getJdbcInterface(Object o) {
        Class<?>[] list = o.getClass().getInterfaces();
        for (int i = 0; i < list.length; ++i) {
            Class<?> in = list[i];
            if (this.classMethods.get(in) == null) continue;
            return in;
        }
        return null;
    }

    private void initMethods() {
        Class inter;
        int i;
        for (i = 0; i < INTERFACES.length; ++i) {
            inter = INTERFACES[i];
            this.classMethods.put(inter, new ArrayList());
        }
        for (i = 0; i < INTERFACES.length; ++i) {
            inter = INTERFACES[i];
            ArrayList list = (ArrayList)this.classMethods.get(inter);
            Method[] methods = inter.getMethods();
            for (int j = 0; j < methods.length; ++j) {
                Method m = methods[j];
                list.add(m);
            }
        }
    }

    public void test() throws Exception {
        if (this.config.logMode == 0) {
            this.error("Log mode 0 may corrupt the db, can't test");
        }
        BASE_DIR = "dataCrash";
        this.startServerIfRequired();
        TestScript script = new TestScript();
        ArrayList add = script.getAllStatements(this.config, "org/h2/test/test.in.txt");
        this.initMethods();
        Class.forName("org.h2.Driver");
        this.statements.addAll(add);
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            this.testOne(i);
        }
        BASE_DIR = "data";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

