/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.Statement;
import org.h2.test.TestBase;

public class TestMetaData
extends TestBase {
    Connection conn;
    DatabaseMetaData meta;
    Statement stat;
    String catalog = "METADATA";

    public void test() throws Exception {
        this.deleteDb("metaData");
        this.conn = this.getConnection("metaData");
        this.testCrossReferences();
        this.stat = this.conn.createStatement();
        this.meta = this.conn.getMetaData();
        this.testStatic();
        this.stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        this.stat.execute("CREATE INDEX IDXNAME ON TEST(NAME)");
        ResultSet rs = this.meta.getCatalogs();
        rs.next();
        this.check(rs.getString(1), this.catalog);
        this.checkFalse(rs.next());
        rs = this.meta.getSchemas();
        rs.next();
        this.check(rs.getString("TABLE_SCHEM"), "INFORMATION_SCHEMA");
        rs.next();
        this.check(rs.getString("TABLE_SCHEM"), "PUBLIC");
        this.checkFalse(rs.next());
        rs = this.meta.getTableTypes();
        rs.next();
        this.check(rs.getString("TABLE_TYPE"), "TABLE");
        rs.next();
        this.check(rs.getString("TABLE_TYPE"), "VIEW");
        this.checkFalse(rs.next());
        rs = this.meta.getTables(null, "PUBLIC", null, new String[]{"TABLE"});
        rs.next();
        this.check(rs.getString("TABLE_NAME"), "TEST");
        this.checkFalse(rs.next());
        rs = this.meta.getTables(null, "INFORMATION_SCHEMA", null, new String[]{"TABLE", "SYSTEM TABLE"});
        rs.next();
        this.check("CATALOGS", rs.getString("TABLE_NAME"));
        rs.next();
        this.check("COLLATIONS", rs.getString("TABLE_NAME"));
        rs.next();
        this.check("COLUMNS", rs.getString("TABLE_NAME"));
        rs.next();
        this.check("COLUMN_PRIVILEGES", rs.getString("TABLE_NAME"));
        rs.next();
        this.check("CONSTRAINTS", rs.getString("TABLE_NAME"));
        rs.next();
        this.check("CROSS_REFERENCES", rs.getString("TABLE_NAME"));
        rs.next();
        this.check("FUNCTION_ALIASES", rs.getString("TABLE_NAME"));
        rs.next();
        this.check("HELP", rs.getString("TABLE_NAME"));
        rs.next();
        this.check("INDEXES", rs.getString("TABLE_NAME"));
        rs.next();
        this.check("IN_DOUBT", rs.getString("TABLE_NAME"));
        rs.next();
        this.check("RIGHTS", rs.getString("TABLE_NAME"));
        rs.next();
        this.check("ROLES", rs.getString("TABLE_NAME"));
        rs.next();
        this.check("SCHEMATA", rs.getString("TABLE_NAME"));
        rs.next();
        this.check("SEQUENCES", rs.getString("TABLE_NAME"));
        rs.next();
        this.check("SETTINGS", rs.getString("TABLE_NAME"));
        rs.next();
        this.check("TABLES", rs.getString("TABLE_NAME"));
        rs.next();
        this.check("TABLE_PRIVILEGES", rs.getString("TABLE_NAME"));
        rs.next();
        this.check("TABLE_TYPES", rs.getString("TABLE_NAME"));
        rs.next();
        this.check("TYPE_INFO", rs.getString("TABLE_NAME"));
        rs.next();
        this.check("USERS", rs.getString("TABLE_NAME"));
        rs.next();
        this.check("VIEWS", rs.getString("TABLE_NAME"));
        this.checkFalse(rs.next());
        rs = this.meta.getColumns(null, null, "TEST", null);
        rs.next();
        this.check(rs.getString("COLUMN_NAME"), "ID");
        rs.next();
        this.check(rs.getString("COLUMN_NAME"), "NAME");
        this.checkFalse(rs.next());
        rs = this.meta.getPrimaryKeys(null, null, "TEST");
        rs.next();
        this.check(rs.getString("COLUMN_NAME"), "ID");
        this.checkFalse(rs.next());
        rs = this.meta.getBestRowIdentifier(null, null, "TEST", 2, false);
        rs.next();
        this.check(rs.getString("COLUMN_NAME"), "ID");
        this.checkFalse(rs.next());
        rs = this.meta.getIndexInfo(null, null, "TEST", false, false);
        rs.next();
        String index = rs.getString("INDEX_NAME");
        this.check(index.startsWith("PRIMARY_KEY"));
        this.check(rs.getString("COLUMN_NAME"), "ID");
        rs.next();
        this.check(rs.getString("INDEX_NAME"), "IDXNAME");
        this.check(rs.getString("COLUMN_NAME"), "NAME");
        this.checkFalse(rs.next());
        rs = this.meta.getIndexInfo(null, null, "TEST", true, false);
        rs.next();
        index = rs.getString("INDEX_NAME");
        this.check(index.startsWith("PRIMARY_KEY"));
        this.check(rs.getString("COLUMN_NAME"), "ID");
        this.checkFalse(rs.next());
        rs = this.meta.getVersionColumns(null, null, "TEST");
        this.checkFalse(rs.next());
        this.stat.execute("DROP TABLE TEST");
        rs = this.stat.executeQuery("SELECT * FROM INFORMATION_SCHEMA.SETTINGS");
        while (rs.next()) {
            String name = rs.getString("NAME");
            String value = rs.getString("VALUE");
            this.trace(name + "=" + value);
        }
        this.test(this.conn);
        this.conn.close();
        this.testTempTable();
    }

    private void testCrossReferences() throws Exception {
        DatabaseMetaData meta = this.conn.getMetaData();
        Statement stat = this.conn.createStatement();
        stat.execute("CREATE TABLE PARENT(A INT, B INT, PRIMARY KEY(A, B))");
        stat.execute("CREATE TABLE CHILD(ID INT PRIMARY KEY, PA INT, PB INT, CONSTRAINT AB FOREIGN KEY(PA, PB) REFERENCES PARENT(A, B))");
        ResultSet rs = meta.getCrossReference(null, "PUBLIC", "PARENT", null, "PUBLIC", "CHILD");
        this.checkCrossRef(rs);
        rs = meta.getImportedKeys(null, "PUBLIC", "CHILD");
        this.checkCrossRef(rs);
        rs = meta.getExportedKeys(null, "PUBLIC", "PARENT");
        this.checkCrossRef(rs);
        stat.execute("DROP TABLE PARENT");
        stat.execute("DROP TABLE CHILD");
    }

    private void checkCrossRef(ResultSet rs) throws Exception {
        this.testResultSetMeta(rs, 14, new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5}, null, null);
        this.testResultSetOrdered(rs, new String[][]{{this.catalog, "PUBLIC", "PARENT", "A", this.catalog, "PUBLIC", "CHILD", "PA", "1", "1", "1", "AB", null, "7"}, {this.catalog, "PUBLIC", "PARENT", "B", this.catalog, "PUBLIC", "CHILD", "PB", "2", "1", "1", "AB", null, "7"}});
    }

    void testTempTable() throws Exception {
        Connection conn = this.getConnection("metaData");
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST_TEMP");
        stat.execute("CREATE TEMP TABLE TEST_TEMP(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        stat.execute("CREATE INDEX IDX_NAME ON TEST_TEMP(NAME)");
        stat.execute("ALTER TABLE TEST_TEMP ADD FOREIGN KEY(ID) REFERENCES(ID)");
        conn.close();
        conn = this.getConnection("metaData");
        stat = conn.createStatement();
        stat.execute("CREATE TEMP TABLE TEST_TEMP(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        ResultSet rs = stat.executeQuery("SELECT STORAGE_TYPE FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME='TEST_TEMP'");
        rs.next();
        this.check(rs.getString("STORAGE_TYPE"), "TEMPORARY");
        stat.execute("DROP TABLE IF EXISTS TEST_TEMP");
        conn.close();
    }

    void testStatic() throws Exception {
        String versionStart;
        Driver dr = (Driver)Class.forName("org.h2.Driver").newInstance();
        this.check(dr.getMajorVersion(), this.meta.getDriverMajorVersion());
        this.check(dr.getMinorVersion(), this.meta.getDriverMinorVersion());
        this.check(dr.jdbcCompliant());
        this.check(dr.getPropertyInfo(null, null).length, 0L);
        this.check(dr.connect("jdbc:test:false", null) == null);
        this.check(this.meta.getNumericFunctions().length() > 0);
        this.check(this.meta.getStringFunctions().length() > 0);
        this.check(this.meta.getSystemFunctions().length() > 0);
        this.check(this.meta.getTimeDateFunctions().length() > 0);
        this.check(this.meta.allProceduresAreCallable());
        this.check(this.meta.allTablesAreSelectable());
        this.check(this.meta.dataDefinitionCausesTransactionCommit());
        this.checkFalse(this.meta.dataDefinitionIgnoredInTransactions());
        this.checkFalse(this.meta.deletesAreDetected(1003));
        this.checkFalse(this.meta.deletesAreDetected(1004));
        this.checkFalse(this.meta.deletesAreDetected(1005));
        this.checkFalse(this.meta.doesMaxRowSizeIncludeBlobs());
        this.check(this.meta.getCatalogSeparator(), ".");
        this.check(this.meta.getCatalogTerm(), "catalog");
        this.check(this.meta.getConnection() == this.conn);
        if (this.config.jdk14) {
            versionStart = this.meta.getDatabaseMajorVersion() + "." + this.meta.getDatabaseMinorVersion();
            this.check(this.meta.getDatabaseProductVersion().startsWith(versionStart));
            this.check(this.meta.getDriverMajorVersion(), this.meta.getDatabaseMajorVersion());
            this.check(this.meta.getDriverMinorVersion(), this.meta.getDatabaseMinorVersion());
            this.check(this.meta.getJDBCMajorVersion(), 3L);
            this.check(this.meta.getJDBCMinorVersion(), 0L);
        }
        this.check(this.meta.getDatabaseProductName(), "H2");
        this.check(this.meta.getDefaultTransactionIsolation(), 2L);
        this.check(this.meta.getDriverName(), "H2 JDBC Driver");
        versionStart = this.meta.getDriverMajorVersion() + "." + this.meta.getDriverMinorVersion();
        this.check(this.meta.getDriverVersion().startsWith(versionStart));
        this.check(this.meta.getExtraNameCharacters(), "");
        this.check(this.meta.getIdentifierQuoteString(), "\"");
        this.check(this.meta.getMaxBinaryLiteralLength(), 0L);
        this.check(this.meta.getMaxCatalogNameLength(), 0L);
        this.check(this.meta.getMaxCharLiteralLength(), 0L);
        this.check(this.meta.getMaxColumnNameLength(), 0L);
        this.check(this.meta.getMaxColumnsInGroupBy(), 0L);
        this.check(this.meta.getMaxColumnsInIndex(), 0L);
        this.check(this.meta.getMaxColumnsInOrderBy(), 0L);
        this.check(this.meta.getMaxColumnsInSelect(), 0L);
        this.check(this.meta.getMaxColumnsInTable(), 0L);
        this.check(this.meta.getMaxConnections(), 0L);
        this.check(this.meta.getMaxCursorNameLength(), 0L);
        this.check(this.meta.getMaxIndexLength(), 0L);
        this.check(this.meta.getMaxProcedureNameLength(), 0L);
        this.check(this.meta.getMaxRowSize(), 0L);
        this.check(this.meta.getMaxSchemaNameLength(), 0L);
        this.check(this.meta.getMaxStatementLength(), 0L);
        this.check(this.meta.getMaxStatements(), 0L);
        this.check(this.meta.getMaxTableNameLength(), 0L);
        this.check(this.meta.getMaxTablesInSelect(), 0L);
        this.check(this.meta.getMaxUserNameLength(), 0L);
        this.check(this.meta.getProcedureTerm(), "procedure");
        if (this.config.jdk14) {
            this.check(this.meta.getResultSetHoldability(), 2L);
            this.check(this.meta.getSQLStateType(), 2L);
            this.checkFalse(this.meta.locatorsUpdateCopy());
        }
        this.check(this.meta.getSchemaTerm(), "schema");
        this.check(this.meta.getSearchStringEscape(), "\\");
        this.check(this.meta.getSQLKeywords(), "");
        this.check(this.meta.getURL().startsWith("jdbc:h2:"));
        this.check(this.meta.getUserName().length() > 1);
        this.checkFalse(this.meta.insertsAreDetected(1003));
        this.checkFalse(this.meta.insertsAreDetected(1004));
        this.checkFalse(this.meta.insertsAreDetected(1005));
        this.check(this.meta.isCatalogAtStart());
        this.checkFalse(this.meta.isReadOnly());
        this.check(this.meta.nullPlusNonNullIsNull());
        this.checkFalse(this.meta.nullsAreSortedAtEnd());
        this.checkFalse(this.meta.nullsAreSortedAtStart());
        this.checkFalse(this.meta.nullsAreSortedHigh());
        this.check(this.meta.nullsAreSortedLow());
        this.checkFalse(this.meta.othersDeletesAreVisible(1003));
        this.checkFalse(this.meta.othersDeletesAreVisible(1004));
        this.checkFalse(this.meta.othersDeletesAreVisible(1005));
        this.checkFalse(this.meta.othersInsertsAreVisible(1003));
        this.checkFalse(this.meta.othersInsertsAreVisible(1004));
        this.checkFalse(this.meta.othersInsertsAreVisible(1005));
        this.checkFalse(this.meta.othersUpdatesAreVisible(1003));
        this.checkFalse(this.meta.othersUpdatesAreVisible(1004));
        this.checkFalse(this.meta.othersUpdatesAreVisible(1005));
        this.checkFalse(this.meta.ownDeletesAreVisible(1003));
        this.checkFalse(this.meta.ownDeletesAreVisible(1004));
        this.checkFalse(this.meta.ownDeletesAreVisible(1005));
        this.checkFalse(this.meta.ownInsertsAreVisible(1003));
        this.checkFalse(this.meta.ownInsertsAreVisible(1004));
        this.checkFalse(this.meta.ownInsertsAreVisible(1005));
        this.checkFalse(this.meta.ownUpdatesAreVisible(1003));
        this.checkFalse(this.meta.ownUpdatesAreVisible(1004));
        this.checkFalse(this.meta.ownUpdatesAreVisible(1005));
        this.checkFalse(this.meta.storesLowerCaseIdentifiers());
        this.checkFalse(this.meta.storesLowerCaseQuotedIdentifiers());
        this.checkFalse(this.meta.storesMixedCaseIdentifiers());
        this.check(this.meta.storesMixedCaseQuotedIdentifiers());
        this.check(this.meta.storesUpperCaseIdentifiers());
        this.checkFalse(this.meta.storesUpperCaseQuotedIdentifiers());
        this.check(this.meta.supportsAlterTableWithAddColumn());
        this.check(this.meta.supportsAlterTableWithDropColumn());
        this.check(this.meta.supportsANSI92EntryLevelSQL());
        this.checkFalse(this.meta.supportsANSI92IntermediateSQL());
        this.checkFalse(this.meta.supportsANSI92FullSQL());
        this.check(this.meta.supportsBatchUpdates());
        this.checkFalse(this.meta.supportsCatalogsInDataManipulation());
        this.checkFalse(this.meta.supportsCatalogsInIndexDefinitions());
        this.checkFalse(this.meta.supportsCatalogsInPrivilegeDefinitions());
        this.checkFalse(this.meta.supportsCatalogsInProcedureCalls());
        this.checkFalse(this.meta.supportsCatalogsInTableDefinitions());
        this.check(this.meta.supportsColumnAliasing());
        this.check(this.meta.supportsConvert());
        this.check(this.meta.supportsConvert(4, 12));
        this.check(this.meta.supportsCoreSQLGrammar());
        this.check(this.meta.supportsCorrelatedSubqueries());
        this.checkFalse(this.meta.supportsDataDefinitionAndDataManipulationTransactions());
        this.check(this.meta.supportsDataManipulationTransactionsOnly());
        this.checkFalse(this.meta.supportsDifferentTableCorrelationNames());
        this.check(this.meta.supportsExpressionsInOrderBy());
        this.checkFalse(this.meta.supportsExtendedSQLGrammar());
        this.checkFalse(this.meta.supportsFullOuterJoins());
        if (this.config.jdk14) {
            this.check(this.meta.supportsGetGeneratedKeys());
            this.check(this.meta.supportsMultipleOpenResults());
            this.checkFalse(this.meta.supportsNamedParameters());
        }
        this.check(this.meta.supportsGroupBy());
        this.check(this.meta.supportsGroupByBeyondSelect());
        this.check(this.meta.supportsGroupByUnrelated());
        this.check(this.meta.supportsIntegrityEnhancementFacility());
        this.check(this.meta.supportsLikeEscapeClause());
        this.check(this.meta.supportsLimitedOuterJoins());
        this.check(this.meta.supportsMinimumSQLGrammar());
        this.checkFalse(this.meta.supportsMixedCaseIdentifiers());
        this.check(this.meta.supportsMixedCaseQuotedIdentifiers());
        this.checkFalse(this.meta.supportsMultipleResultSets());
        this.check(this.meta.supportsMultipleTransactions());
        this.check(this.meta.supportsNonNullableColumns());
        this.checkFalse(this.meta.supportsOpenCursorsAcrossCommit());
        this.checkFalse(this.meta.supportsOpenCursorsAcrossRollback());
        this.check(this.meta.supportsOpenStatementsAcrossCommit());
        this.check(this.meta.supportsOpenStatementsAcrossRollback());
        this.check(this.meta.supportsOrderByUnrelated());
        this.check(this.meta.supportsOuterJoins());
        this.check(this.meta.supportsPositionedDelete());
        this.check(this.meta.supportsPositionedUpdate());
        this.check(this.meta.supportsResultSetConcurrency(1003, 1007));
        this.check(this.meta.supportsResultSetConcurrency(1003, 1008));
        this.check(this.meta.supportsResultSetConcurrency(1004, 1007));
        this.check(this.meta.supportsResultSetConcurrency(1004, 1008));
        this.checkFalse(this.meta.supportsResultSetConcurrency(1005, 1007));
        this.checkFalse(this.meta.supportsResultSetConcurrency(1005, 1008));
        if (this.config.jdk14) {
            this.checkFalse(this.meta.supportsResultSetHoldability(1));
            this.check(this.meta.supportsResultSetHoldability(2));
            this.check(this.meta.supportsSavepoints());
            this.checkFalse(this.meta.supportsStatementPooling());
        }
        this.check(this.meta.supportsResultSetType(1003));
        this.check(this.meta.supportsResultSetType(1004));
        this.checkFalse(this.meta.supportsResultSetType(1005));
        this.check(this.meta.supportsSchemasInDataManipulation());
        this.check(this.meta.supportsSchemasInIndexDefinitions());
        this.check(this.meta.supportsSchemasInPrivilegeDefinitions());
        this.check(this.meta.supportsSchemasInProcedureCalls());
        this.check(this.meta.supportsSchemasInTableDefinitions());
        this.check(this.meta.supportsSelectForUpdate());
        this.checkFalse(this.meta.supportsStoredProcedures());
        this.check(this.meta.supportsSubqueriesInComparisons());
        this.check(this.meta.supportsSubqueriesInExists());
        this.check(this.meta.supportsSubqueriesInIns());
        this.check(this.meta.supportsSubqueriesInQuantifieds());
        this.check(this.meta.supportsTableCorrelationNames());
        this.check(this.meta.supportsTransactions());
        this.check(this.meta.supportsTransactionIsolationLevel(0));
        this.check(this.meta.supportsTransactionIsolationLevel(2));
        this.check(this.meta.supportsTransactionIsolationLevel(1));
        this.check(this.meta.supportsTransactionIsolationLevel(4));
        this.check(this.meta.supportsTransactionIsolationLevel(8));
        this.check(this.meta.supportsUnion());
        this.check(this.meta.supportsUnionAll());
        this.checkFalse(this.meta.updatesAreDetected(1003));
        this.checkFalse(this.meta.updatesAreDetected(1004));
        this.checkFalse(this.meta.updatesAreDetected(1005));
        this.checkFalse(this.meta.usesLocalFilePerTable());
        this.check(this.meta.usesLocalFiles());
    }

    void test(Connection conn) throws Exception {
        DatabaseMetaData meta = conn.getMetaData();
        Statement stat = conn.createStatement();
        conn.setReadOnly(true);
        conn.setReadOnly(false);
        this.checkFalse(conn.isReadOnly());
        this.check(conn.isReadOnly() == meta.isReadOnly());
        this.check(conn == meta.getConnection());
        conn.setCatalog("XYZ");
        this.trace(conn.getCatalog());
        String product = meta.getDatabaseProductName();
        this.trace("meta.getDatabaseProductName:" + product);
        String version = meta.getDatabaseProductVersion();
        this.trace("meta.getDatabaseProductVersion:" + version);
        int major = meta.getDriverMajorVersion();
        this.trace("meta.getDriverMajorVersion:" + major);
        int minor = meta.getDriverMinorVersion();
        this.trace("meta.getDriverMinorVersion:" + minor);
        String drivername = meta.getDriverName();
        this.trace("meta.getDriverName:" + drivername);
        String driverversion = meta.getDriverVersion();
        this.trace("meta.getDriverVersion:" + driverversion);
        meta.getSearchStringEscape();
        String url = meta.getURL();
        this.trace("meta.getURL:" + url);
        String user = meta.getUserName();
        this.trace("meta.getUserName:" + user);
        this.trace("meta.nullsAreSortedHigh:" + meta.nullsAreSortedHigh());
        this.trace("meta.nullsAreSortedLow:" + meta.nullsAreSortedLow());
        this.trace("meta.nullsAreSortedAtStart:" + meta.nullsAreSortedAtStart());
        this.trace("meta.nullsAreSortedAtEnd:" + meta.nullsAreSortedAtEnd());
        int count = (meta.nullsAreSortedHigh() ? 1 : 0) + (meta.nullsAreSortedLow() ? 1 : 0) + (meta.nullsAreSortedAtStart() ? 1 : 0) + (meta.nullsAreSortedAtEnd() ? 1 : 0);
        this.check(count == 1);
        this.trace("meta.allProceduresAreCallable:" + meta.allProceduresAreCallable());
        this.check(meta.allProceduresAreCallable());
        this.trace("meta.allTablesAreSelectable:" + meta.allTablesAreSelectable());
        this.check(meta.allTablesAreSelectable());
        this.trace("getTables");
        ResultSet rs = meta.getTables(null, "PUBLIC", null, new String[]{"TABLE"});
        this.testResultSetMeta(rs, 6, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "TABLE_TYPE", "REMARKS", "SQL"}, new int[]{12, 12, 12, 12, 12, 12}, null, null);
        if (rs.next()) {
            this.error("Database is not empty after dropping all tables");
        }
        stat.executeUpdate("CREATE TABLE TEST(ID INT PRIMARY KEY,TEXT_V VARCHAR(120),DEC_V DECIMAL(12,3),DATE_V DATETIME,BLOB_V BLOB,CLOB_V CLOB)");
        rs = meta.getTables(null, "PUBLIC", null, new String[]{"TABLE"});
        this.testResultSetOrdered(rs, new String[][]{{this.catalog, "PUBLIC", "TEST", "TABLE", ""}});
        this.trace("getColumns");
        rs = meta.getColumns(null, null, "TEST", null);
        this.testResultSetMeta(rs, 18, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "DATA_TYPE", "TYPE_NAME", "COLUMN_SIZE", "BUFFER_LENGTH", "DECIMAL_DIGITS", "NUM_PREC_RADIX", "NULLABLE", "REMARKS", "COLUMN_DEF", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "CHAR_OCTET_LENGTH", "ORDINAL_POSITION", "IS_NULLABLE"}, new int[]{12, 12, 12, 12, 5, 12, 4, 4, 4, 4, 5, 12, 12, 5, 4, 4, 4, 12}, null, null);
        this.testResultSetOrdered(rs, new String[][]{{this.catalog, "PUBLIC", "TEST", "ID", "4", "INTEGER", "10", "10", "0", "10", "0", "", "", "4", "0", "10", "1", "NO"}, {this.catalog, "PUBLIC", "TEST", "TEXT_V", "12", "VARCHAR", "120", "120", "0", "10", "1", "", "", "12", "0", "120", "2", "YES"}, {this.catalog, "PUBLIC", "TEST", "DEC_V", "3", "DECIMAL", "12", "12", "3", "10", "1", "", "", "3", "0", "12", "3", "YES"}, {this.catalog, "PUBLIC", "TEST", "DATE_V", "93", "TIMESTAMP", "23", "23", "10", "10", "1", "", "", "93", "0", "23", "4", "YES"}, {this.catalog, "PUBLIC", "TEST", "BLOB_V", "2004", "BLOB", "2147483647", "2147483647", "0", "10", "1", "", "", "2004", "0", "2147483647", "5", "YES"}, {this.catalog, "PUBLIC", "TEST", "CLOB_V", "2005", "CLOB", "2147483647", "2147483647", "0", "10", "1", "", "", "2005", "0", "2147483647", "6", "YES"}});
        this.trace("getIndexInfo");
        stat.executeUpdate("CREATE INDEX IDX_TEXT_DEC ON TEST(TEXT_V,DEC_V)");
        stat.executeUpdate("CREATE UNIQUE INDEX IDX_DATE ON TEST(DATE_V)");
        rs = meta.getIndexInfo(null, null, "TEST", false, false);
        this.testResultSetMeta(rs, 13, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"}, new int[]{12, 12, 12, 16, 12, 12, 5, 5, 12, 12, 4, 4, 12}, null, null);
        this.testResultSetOrdered(rs, new String[][]{{this.catalog, "PUBLIC", "TEST", "FALSE", this.catalog, "IDX_DATE", "3", "1", "DATE_V", "A", "0", "0", ""}, {this.catalog, "PUBLIC", "TEST", "FALSE", this.catalog, "PRIMARY_KEY_1", "3", "1", "ID", "A", "0", "0", ""}, {this.catalog, "PUBLIC", "TEST", "TRUE", this.catalog, "IDX_TEXT_DEC", "3", "1", "TEXT_V", "A", "0", "0", ""}, {this.catalog, "PUBLIC", "TEST", "TRUE", this.catalog, "IDX_TEXT_DEC", "3", "2", "DEC_V", "A", "0", "0", ""}});
        stat.executeUpdate("DROP INDEX IDX_TEXT_DEC");
        stat.executeUpdate("DROP INDEX IDX_DATE");
        rs = meta.getIndexInfo(null, null, "TEST", false, false);
        this.testResultSetMeta(rs, 13, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "NON_UNIQUE", "INDEX_QUALIFIER", "INDEX_NAME", "TYPE", "ORDINAL_POSITION", "COLUMN_NAME", "ASC_OR_DESC", "CARDINALITY", "PAGES", "FILTER_CONDITION"}, new int[]{12, 12, 12, 16, 12, 12, 5, 5, 12, 12, 4, 4, 12}, null, null);
        this.testResultSetOrdered(rs, new String[][]{{this.catalog, "PUBLIC", "TEST", "FALSE", this.catalog, "PRIMARY_KEY_1", "3", "1", "ID", "A", "0", "0", ""}});
        this.trace("getPrimaryKeys");
        rs = meta.getPrimaryKeys(null, null, "TEST");
        this.testResultSetMeta(rs, 6, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "KEY_SEQ", "PK_NAME"}, new int[]{12, 12, 12, 12, 5, 12}, null, null);
        this.testResultSetOrdered(rs, new String[][]{{this.catalog, "PUBLIC", "TEST", "ID", "1", "PRIMARY_KEY_1"}});
        this.trace("getTables - using a wildcard");
        stat.executeUpdate("CREATE TABLE T_2(B INT,A VARCHAR(6),C INT,PRIMARY KEY(C,A,B))");
        stat.executeUpdate("CREATE TABLE TX2(B INT,A VARCHAR(6),C INT,PRIMARY KEY(C,A,B))");
        rs = meta.getTables(null, null, "T_2", null);
        this.testResultSetOrdered(rs, new String[][]{{this.catalog, "PUBLIC", "TX2", "TABLE", ""}, {this.catalog, "PUBLIC", "T_2", "TABLE", ""}});
        this.trace("getTables - using a quoted _ character");
        rs = meta.getTables(null, null, "T\\_2", null);
        this.testResultSetOrdered(rs, new String[][]{{this.catalog, "PUBLIC", "T_2", "TABLE", ""}});
        this.trace("getTables - using the % wildcard");
        rs = meta.getTables(null, "PUBLIC", "%", new String[]{"TABLE"});
        this.testResultSetOrdered(rs, new String[][]{{this.catalog, "PUBLIC", "TEST", "TABLE", ""}, {this.catalog, "PUBLIC", "TX2", "TABLE", ""}, {this.catalog, "PUBLIC", "T_2", "TABLE", ""}});
        stat.execute("DROP TABLE TEST");
        this.trace("getColumns - using wildcards");
        rs = meta.getColumns(null, null, "___", "B%");
        this.testResultSetOrdered(rs, new String[][]{{this.catalog, "PUBLIC", "TX2", "B", "4", "INTEGER", "10"}, {this.catalog, "PUBLIC", "T_2", "B", "4", "INTEGER", "10"}});
        this.trace("getColumns - using wildcards");
        rs = meta.getColumns(null, null, "_\\__", "%");
        this.testResultSetOrdered(rs, new String[][]{{this.catalog, "PUBLIC", "T_2", "B", "4", "INTEGER", "10"}, {this.catalog, "PUBLIC", "T_2", "A", "12", "VARCHAR", "6"}, {this.catalog, "PUBLIC", "T_2", "C", "4", "INTEGER", "10"}});
        this.trace("getIndexInfo");
        stat.executeUpdate("CREATE UNIQUE INDEX A_INDEX ON TX2(B,C,A)");
        stat.executeUpdate("CREATE INDEX B_INDEX ON TX2(A,B,C)");
        rs = meta.getIndexInfo(null, null, "TX2", false, false);
        this.testResultSetOrdered(rs, new String[][]{{this.catalog, "PUBLIC", "TX2", "FALSE", this.catalog, "A_INDEX", "3", "1", "B", "A"}, {this.catalog, "PUBLIC", "TX2", "FALSE", this.catalog, "A_INDEX", "3", "2", "C", "A"}, {this.catalog, "PUBLIC", "TX2", "FALSE", this.catalog, "A_INDEX", "3", "3", "A", "A"}, {this.catalog, "PUBLIC", "TX2", "FALSE", this.catalog, "PRIMARY_KEY_3", "3", "1", "C", "A"}, {this.catalog, "PUBLIC", "TX2", "FALSE", this.catalog, "PRIMARY_KEY_3", "3", "2", "A", "A"}, {this.catalog, "PUBLIC", "TX2", "FALSE", this.catalog, "PRIMARY_KEY_3", "3", "3", "B", "A"}, {this.catalog, "PUBLIC", "TX2", "TRUE", this.catalog, "B_INDEX", "3", "1", "A", "A"}, {this.catalog, "PUBLIC", "TX2", "TRUE", this.catalog, "B_INDEX", "3", "2", "B", "A"}, {this.catalog, "PUBLIC", "TX2", "TRUE", this.catalog, "B_INDEX", "3", "3", "C", "A"}});
        this.trace("getPrimaryKeys");
        rs = meta.getPrimaryKeys(null, null, "T_2");
        this.testResultSetOrdered(rs, new String[][]{{this.catalog, "PUBLIC", "T_2", "A", "2", "PRIMARY_KEY_2"}, {this.catalog, "PUBLIC", "T_2", "B", "3", "PRIMARY_KEY_2"}, {this.catalog, "PUBLIC", "T_2", "C", "1", "PRIMARY_KEY_2"}});
        stat.executeUpdate("DROP TABLE TX2");
        stat.executeUpdate("DROP TABLE T_2");
        stat.executeUpdate("CREATE TABLE PARENT(ID INT PRIMARY KEY)");
        stat.executeUpdate("CREATE TABLE CHILD(P_ID INT,ID INT,PRIMARY KEY(P_ID,ID),FOREIGN KEY(P_ID) REFERENCES PARENT(ID))");
        this.trace("getImportedKeys");
        rs = meta.getImportedKeys(null, null, "CHILD");
        this.testResultSetMeta(rs, 14, new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5}, null, null);
        this.trace("getExportedKeys");
        rs = meta.getExportedKeys(null, null, "PARENT");
        this.testResultSetMeta(rs, 14, new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5}, null, null);
        this.trace("getCrossReference");
        rs = meta.getCrossReference(null, null, "PARENT", null, null, "CHILD");
        this.testResultSetMeta(rs, 14, new String[]{"PKTABLE_CAT", "PKTABLE_SCHEM", "PKTABLE_NAME", "PKCOLUMN_NAME", "FKTABLE_CAT", "FKTABLE_SCHEM", "FKTABLE_NAME", "FKCOLUMN_NAME", "KEY_SEQ", "UPDATE_RULE", "DELETE_RULE", "FK_NAME", "PK_NAME", "DEFERRABILITY"}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 5, 5, 5, 12, 12, 5}, null, null);
        rs = meta.getSchemas();
        this.testResultSetMeta(rs, 3, new String[]{"TABLE_SCHEM", "TABLE_CATALOG", "IS_DEFAULT"}, new int[]{12, 12, 16}, null, null);
        this.check(rs.next());
        this.check(rs.getString(1), "INFORMATION_SCHEMA");
        this.check(rs.next());
        this.check(rs.getString(1), "PUBLIC");
        this.checkFalse(rs.next());
        rs = meta.getCatalogs();
        this.testResultSetMeta(rs, 1, new String[]{"TABLE_CAT"}, new int[]{12}, null, null);
        this.testResultSetOrdered(rs, new String[][]{{this.catalog}});
        rs = meta.getTableTypes();
        this.testResultSetMeta(rs, 1, new String[]{"TABLE_TYPE"}, new int[]{12}, null, null);
        this.testResultSetOrdered(rs, new String[][]{{"TABLE"}, {"VIEW"}});
        rs = meta.getTypeInfo();
        this.testResultSetMeta(rs, 18, new String[]{"TYPE_NAME", "DATA_TYPE", "PRECISION", "LITERAL_PREFIX", "LITERAL_SUFFIX", "CREATE_PARAMS", "NULLABLE", "CASE_SENSITIVE", "SEARCHABLE", "UNSIGNED_ATTRIBUTE", "FIXED_PREC_SCALE", "AUTO_INCREMENT", "LOCAL_TYPE_NAME", "MINIMUM_SCALE", "MAXIMUM_SCALE", "SQL_DATA_TYPE", "SQL_DATETIME_SUB", "NUM_PREC_RADIX"}, new int[]{12, 5, 4, 12, 12, 12, 5, 16, 5, 16, 16, 16, 12, 5, 5, 5, 4, 4}, null, null);
        rs = meta.getTablePrivileges(null, null, null);
        this.testResultSetMeta(rs, 7, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"}, new int[]{12, 12, 12, 12, 12, 12, 12, 12}, null, null);
        rs = meta.getColumnPrivileges(null, null, "TEST", null);
        this.testResultSetMeta(rs, 8, new String[]{"TABLE_CAT", "TABLE_SCHEM", "TABLE_NAME", "COLUMN_NAME", "GRANTOR", "GRANTEE", "PRIVILEGE", "IS_GRANTABLE"}, new int[]{12, 12, 12, 12, 12, 12, 12, 12, 12}, null, null);
        this.check(conn.getWarnings() == null);
        conn.clearWarnings();
        this.check(conn.getWarnings() == null);
    }
}

