/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;

public class TestCancel
extends TestBase {
    public void test() throws Exception {
        int i;
        this.deleteDb("cancel");
        Connection conn = this.getConnection("cancel");
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE  MEMORY TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        this.trace("insert");
        int len = this.getSize(1, 1000);
        for (i = 0; i < len; ++i) {
            prep.setInt(1, i);
            prep.setString(2, "hi");
            prep.execute();
        }
        this.trace("inserted");
        i = 1;
        while (true) {
            Statement query = conn.createStatement();
            Canceller canceller = new Canceller(query, i);
            canceller.start();
            Thread.yield();
            int j = 0;
            try {
                ResultSet rs = query.executeQuery("SELECT * FROM TEST");
                while (rs.next()) {
                    ++j;
                }
                this.trace("record count: " + j);
            }
            catch (SQLException e) {
                this.checkNotGeneralException(e);
                this.trace("record count: " + j);
            }
            if (j == 0) {
                i += 10;
                continue;
            }
            if (j == len) break;
        }
        conn.close();
    }

    class Canceller
    extends Thread {
        private Statement cancel;
        private int wait;

        Canceller(Statement cancel, int wait) {
            this.cancel = cancel;
            this.wait = wait;
        }

        public void run() {
            try {
                Thread.sleep(this.wait);
                this.cancel.cancel();
                Thread.yield();
            }
            catch (SQLException e) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

