/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.h2.test.TestBase;

public class TestTransaction
extends TestBase {
    Statement stat;

    public void test() throws Exception {
        this.deleteDb("transaction");
        Connection conn = this.getConnection("transaction");
        this.trace("default TransactionIsolation=" + conn.getTransactionIsolation());
        conn.setTransactionIsolation(2);
        this.check(conn.getTransactionIsolation() == 2);
        conn.setTransactionIsolation(8);
        this.check(conn.getTransactionIsolation() == 8);
        this.stat = conn.createStatement();
        this.check(conn.getAutoCommit());
        conn.setAutoCommit(false);
        this.checkFalse(conn.getAutoCommit());
        conn.setAutoCommit(true);
        this.check(conn.getAutoCommit());
        this.test("CREATE TABLE TEST(ID INT PRIMARY KEY)");
        conn.commit();
        this.test("INSERT INTO TEST VALUES(0)");
        conn.rollback();
        this.testValue("SELECT COUNT(*) FROM TEST", "1");
        conn.setAutoCommit(false);
        this.test("DELETE FROM TEST");
        conn.rollback();
        this.testValue("SELECT COUNT(*) FROM TEST", "1");
        conn.commit();
        conn.setAutoCommit(true);
        this.testNestedResultSets(conn);
        conn.setAutoCommit(false);
        this.testNestedResultSets(conn);
        conn.close();
    }

    void testNestedResultSets(Connection conn) throws Exception {
        String v1;
        ResultSet rs2;
        this.test("CREATE TABLE NEST1(ID INT PRIMARY KEY,VALUE VARCHAR(255))");
        this.test("CREATE TABLE NEST2(ID INT PRIMARY KEY,VALUE VARCHAR(255))");
        DatabaseMetaData meta = conn.getMetaData();
        Vector<String> result = new Vector<String>();
        ResultSet rs1 = meta.getTables(null, null, "NEST%", null);
        while (rs1.next()) {
            String table = rs1.getString("TABLE_NAME");
            rs2 = meta.getColumns(null, null, table, null);
            while (rs2.next()) {
                String column = rs2.getString("COLUMN_NAME");
                this.trace("Table: " + table + " Column: " + column);
                result.add(table + "." + column);
            }
        }
        if (result.size() != 4) {
            this.error("Wrong result, should be NEST1.ID, NEST1.NAME, NEST2.ID, NEST2.NAME but is " + result);
        }
        result = new Vector();
        this.test("INSERT INTO NEST1 VALUES(1,'A')");
        this.test("INSERT INTO NEST1 VALUES(2,'B')");
        this.test("INSERT INTO NEST2 VALUES(1,'1')");
        this.test("INSERT INTO NEST2 VALUES(2,'2')");
        Statement s1 = conn.createStatement();
        Statement s2 = conn.createStatement();
        rs1 = s1.executeQuery("SELECT * FROM NEST1 ORDER BY ID");
        while (rs1.next()) {
            rs2 = s2.executeQuery("SELECT * FROM NEST2 ORDER BY ID");
            while (rs2.next()) {
                v1 = rs1.getString("VALUE");
                String v2 = rs2.getString("VALUE");
                result.add(v1 + "/" + v2);
            }
        }
        if (result.size() != 4) {
            this.error("Wrong result, should be A/1, A/2, B/1, B/2 but is " + result);
        }
        result = new Vector();
        rs1 = s1.executeQuery("SELECT * FROM NEST1 ORDER BY ID");
        rs2 = s1.executeQuery("SELECT * FROM NEST2 ORDER BY ID");
        try {
            rs1.next();
            this.error("next worked on a closed result set");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        rs1.close();
        while (rs2.next()) {
            v1 = rs2.getString("VALUE");
            result.add(v1);
        }
        if (result.size() != 2) {
            this.error("Wrong result, should be A, B but is " + result);
        }
        this.test("DROP TABLE NEST1");
        this.test("DROP TABLE NEST2");
    }

    void testValue(String sql, String data) throws Exception {
        ResultSet rs = this.stat.executeQuery(sql);
        rs.next();
        String s = rs.getString(1);
        if (s == null ? data != null : !s.equals(data)) {
            this.error("s= " + s + " should be: " + data);
        }
    }

    void test(String sql) throws Exception {
        this.trace(sql);
        this.stat.execute(sql);
    }
}

