/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.h2.test.TestAll;
import org.h2.test.TestBase;

public class TestScript
extends TestBase {
    private boolean failFast = false;
    private Connection conn;
    private Statement stat;
    private LineNumberReader in;
    private int line;
    private PrintStream out;
    private ArrayList result = new ArrayList();
    private String putback;
    private StringBuffer errors;
    private ArrayList statements;
    private String fileName = "org/h2/test/test.in.txt";

    public ArrayList getAllStatements(TestAll conf, String file) throws Exception {
        this.config = conf;
        this.fileName = file;
        this.statements = new ArrayList();
        this.test();
        return this.statements;
    }

    public void test() throws Exception {
        this.deleteDb("script");
        String outfile = "test.out.txt";
        String infile = this.fileName;
        this.conn = this.getConnection("script");
        this.stat = this.conn.createStatement();
        this.out = new PrintStream(new FileOutputStream(outfile));
        this.errors = new StringBuffer();
        this.testFile(infile);
        this.conn.close();
        if (this.errors.length() > 0) {
            throw new Exception("errors:\n" + this.errors.toString());
        }
    }

    private String readLine() throws IOException {
        String s;
        if (this.putback != null) {
            String s2 = this.putback;
            this.putback = null;
            return s2;
        }
        do {
            if ((s = this.in.readLine()) != null) continue;
            return s;
        } while ((s = s.trim()).length() <= 0);
        return s;
    }

    private void testFile(String infile) throws Exception {
        String sql;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(infile);
        this.in = new LineNumberReader(new InputStreamReader(is, "Cp1252"));
        StringBuffer buff = new StringBuffer();
        while ((sql = this.readLine()) != null) {
            if (sql.startsWith("--")) {
                this.write(sql);
                continue;
            }
            if (sql.startsWith(">")) continue;
            if (sql.endsWith(";")) {
                this.write(sql);
                buff.append(sql.substring(0, sql.length() - 1));
                sql = buff.toString();
                buff = new StringBuffer();
                this.process(sql);
                continue;
            }
            this.write(sql);
            buff.append(sql);
            buff.append('\n');
        }
    }

    private void process(String sql) throws Exception {
        if (this.statements != null) {
            this.statements.add(sql);
        }
        if (sql.indexOf(63) == -1) {
            this.processStatement(sql);
        } else {
            String param = this.readLine();
            this.write(param);
            if (!param.equals("{")) {
                throw new Error("expected '{', got " + param + " in " + sql);
            }
            try {
                PreparedStatement prep = this.conn.prepareStatement(sql);
                int count = 0;
                while (true) {
                    param = this.readLine();
                    this.write(param);
                    if (param.startsWith("}")) break;
                    count += this.processPrepared(sql, prep, param);
                }
                this.writeResult("update count: " + count, null);
            }
            catch (SQLException e) {
                this.writeException(e);
            }
        }
        this.write("");
    }

    private void setParameter(PreparedStatement prep, int i, String param) throws SQLException {
        if (param.equalsIgnoreCase("null")) {
            param = null;
        }
        prep.setString(i, param);
    }

    private int processPrepared(String sql, PreparedStatement prep, String param) throws Exception {
        try {
            StringBuffer buff = new StringBuffer();
            int index = 0;
            for (int i = 0; i < param.length(); ++i) {
                char c = param.charAt(i);
                if (c == ',') {
                    this.setParameter(prep, ++index, buff.toString());
                    buff = new StringBuffer();
                    continue;
                }
                if (c == '\"') {
                    while ((c = param.charAt(++i)) != '\"') {
                        buff.append(c);
                    }
                    continue;
                }
                if (c <= ' ') continue;
                buff.append(c);
            }
            if (buff.length() > 0) {
                this.setParameter(prep, ++index, buff.toString());
            }
            if (prep.execute()) {
                this.writeResultSet(sql, prep.getResultSet());
                return 0;
            }
            return prep.getUpdateCount();
        }
        catch (SQLException e) {
            this.writeException(e);
            return 0;
        }
    }

    private int processStatement(String sql) throws Exception {
        try {
            if (this.stat.execute(sql)) {
                this.writeResultSet(sql, this.stat.getResultSet());
            } else {
                int count = this.stat.getUpdateCount();
                this.writeResult(count < 1 ? "ok" : "update count: " + count, null);
            }
        }
        catch (SQLException e) {
            this.writeException(e);
        }
        return 0;
    }

    private void writeResultSet(String sql, ResultSet rs) throws Exception {
        int i;
        boolean ordered = sql.toLowerCase().indexOf("order by") >= 0;
        ResultSetMetaData meta = rs.getMetaData();
        int len = meta.getColumnCount();
        int[] max = new int[len];
        String[] head = new String[len];
        for (int i2 = 0; i2 < len; ++i2) {
            String label = meta.getColumnLabel(i2 + 1);
            if (label == null) {
                label = "null";
            }
            max[i2] = label.length();
            head[i2] = label;
        }
        this.result.clear();
        while (rs.next()) {
            String[] row = new String[len];
            for (int i3 = 0; i3 < len; ++i3) {
                String data = rs.getString(i3 + 1);
                if (data == null) {
                    data = "null";
                }
                if (max[i3] < data.length()) {
                    max[i3] = data.length();
                }
                row[i3] = data;
            }
            this.result.add(row);
        }
        rs.close();
        this.writeResult(this.format(head, max), null);
        this.writeResult(this.format(null, max), null);
        String[] array = new String[this.result.size()];
        for (i = 0; i < this.result.size(); ++i) {
            array[i] = this.format((String[])this.result.get(i), max);
        }
        if (!ordered) {
            this.sort(array);
        }
        for (i = 0; i < array.length; ++i) {
            this.writeResult(array[i], null);
        }
        this.writeResult((ordered ? "rows (ordered): " : "rows: ") + i, null);
    }

    private String format(String[] row, int[] max) throws Exception {
        int length = max.length;
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                buff.append(' ');
            }
            if (row == null) {
                for (int j = 0; j < max[i]; ++j) {
                    buff.append('-');
                }
                continue;
            }
            int len = row[i].length();
            buff.append(row[i]);
            if (i >= length - 1) continue;
            for (int j = len; j < max[i]; ++j) {
                buff.append(' ');
            }
        }
        return buff.toString();
    }

    private void writeException(SQLException e) throws Exception {
        this.writeResult("exception", e);
    }

    private void writeResult(String s, SQLException e) throws Exception {
        s = ("> " + s).trim();
        String compare = this.readLine();
        if (compare != null && compare.startsWith(">")) {
            if (!compare.equals(s)) {
                this.errors.append("line: ");
                this.errors.append(this.line);
                this.errors.append("\nexp: ");
                this.errors.append(compare);
                this.errors.append("\ngot: ");
                this.errors.append(s);
                this.errors.append("\n");
                if (e != null) {
                    e.printStackTrace();
                }
                if (this.failFast) {
                    this.conn.close();
                    throw new Exception(this.errors.toString());
                }
            }
        } else {
            this.putback = compare;
        }
        this.write(s);
    }

    private void write(String s) throws Exception {
        ++this.line;
        this.out.println(s);
    }

    private void sort(String[] a) {
        int len = a.length;
        for (int i = 1; i < len; ++i) {
            String t = a[i];
            for (int j = i - 1; j >= 0 && t.compareTo(a[j]) < 0; --j) {
                a[j + 1] = a[j];
            }
            a[j + 1] = t;
        }
    }
}

