/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Random;
import org.h2.test.TestBase;
import org.h2.test.db.TestLobObject;

public class TestLob
extends TestBase {
    public void test() throws Exception {
        if (this.config.memory) {
            return;
        }
        this.testManyLobs();
        this.testClob();
        this.testUpdateLob();
        this.testLobReconnect();
        this.testLob(false);
        this.testLob(true);
        this.testJavaObject();
    }

    private void testManyLobs() throws Exception {
        int l;
        Clob c;
        int i;
        this.deleteDb("lob");
        Connection conn = this.reconnect(null);
        conn.createStatement().execute("CREATE TABLE TEST(ID INT PRIMARY KEY, B BLOB, C CLOB)");
        int len = this.getSize(10, 2000);
        int start = 1;
        int increment = 17;
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(ID, B, C) VALUES(?, ?, ?)");
        for (int i2 = start; i2 < len; i2 += increment) {
            int l2 = Math.max(i2, 2000);
            prep.setInt(1, i2);
            prep.setBinaryStream(2, this.getRandomStream(l2, i2), -1);
            prep.setCharacterStream(3, this.getRandomReader(l2, i2), -1);
            prep.execute();
        }
        conn = this.reconnect(conn);
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM TEST ORDER BY ID");
        while (rs.next()) {
            i = rs.getInt("ID");
            Blob b = rs.getBlob("B");
            c = rs.getClob("C");
            l = Math.max(i, 2000);
            this.check(b.length(), l);
            this.check(c.length(), l);
            this.checkStream(b.getBinaryStream(), this.getRandomStream(l, i), -1);
            this.checkReader(c.getCharacterStream(), this.getRandomReader(l, i), -1);
        }
        prep = conn.prepareStatement("UPDATE TEST SET B=?, C=? WHERE ID=?");
        for (i = start; i < len; i += increment) {
            int l3 = Math.max(i, 2000);
            prep.setBinaryStream(1, this.getRandomStream(l3, -i), -1);
            prep.setCharacterStream(2, this.getRandomReader(l3, -i), -1);
            prep.setInt(3, i);
            prep.execute();
        }
        conn = this.reconnect(conn);
        rs = conn.createStatement().executeQuery("SELECT * FROM TEST ORDER BY ID");
        while (rs.next()) {
            i = rs.getInt("ID");
            Blob b = rs.getBlob("B");
            c = rs.getClob("C");
            l = Math.max(i, 2000);
            this.check(b.length(), l);
            this.check(c.length(), l);
            this.checkStream(b.getBinaryStream(), this.getRandomStream(l, -i), -1);
            this.checkReader(c.getCharacterStream(), this.getRandomReader(l, -i), -1);
        }
        conn.close();
    }

    private void testClob() throws Exception {
        this.deleteDb("lob");
        Connection conn = this.reconnect(null);
        conn.createStatement().execute("CREATE TABLE TEST(ID IDENTITY, C CLOB)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST(C) VALUES(?)");
        prep.setCharacterStream(1, (Reader)new CharArrayReader("Bohlen".toCharArray()), "Bohlen".length());
        prep.execute();
        prep.setCharacterStream(1, (Reader)new CharArrayReader("B\u00f6hlen".toCharArray()), "B\u00f6hlen".length());
        prep.execute();
        prep.setCharacterStream(1, this.getRandomReader(501, 1), -1);
        prep.execute();
        prep.setCharacterStream(1, this.getRandomReader(1501, 2), 401);
        prep.execute();
        conn = this.reconnect(conn);
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM TEST ORDER BY ID");
        rs.next();
        this.check("Bohlen", rs.getString("C"));
        this.checkReader(new CharArrayReader("Bohlen".toCharArray()), rs.getCharacterStream("C"), -1);
        rs.next();
        this.checkReader(new CharArrayReader("B\u00f6hlen".toCharArray()), rs.getCharacterStream("C"), -1);
        rs.next();
        this.checkReader(this.getRandomReader(501, 1), rs.getCharacterStream("C"), -1);
        Clob clob = rs.getClob("C");
        this.checkReader(this.getRandomReader(501, 1), clob.getCharacterStream(), -1);
        this.check(clob.length(), 501L);
        rs.next();
        this.checkReader(this.getRandomReader(401, 2), rs.getCharacterStream("C"), -1);
        this.checkReader(this.getRandomReader(1500, 2), rs.getCharacterStream("C"), 401);
        clob = rs.getClob("C");
        this.checkReader(this.getRandomReader(1501, 2), clob.getCharacterStream(), 401);
        this.checkReader(this.getRandomReader(401, 2), clob.getCharacterStream(), 401);
        this.check(clob.length(), 401L);
        this.checkFalse(rs.next());
        conn.close();
    }

    private Connection reconnect(Connection conn) throws Exception {
        long time = System.currentTimeMillis();
        if (conn != null) {
            conn.close();
        }
        conn = this.getConnection("lob");
        this.trace("re-connect=" + (System.currentTimeMillis() - time));
        return conn;
    }

    void testUpdateLob() throws Exception {
        int i;
        this.deleteDb("lob");
        Connection conn = this.reconnect(null);
        PreparedStatement prep = conn.prepareStatement("CREATE TABLE IF NOT EXISTS p( id int primary key, rawbyte BLOB ); ");
        prep.execute();
        prep.close();
        prep = conn.prepareStatement("INSERT INTO p(id) VALUES(?);");
        for (i = 0; i < 10; ++i) {
            prep.setInt(1, i);
            prep.execute();
        }
        prep.close();
        prep = conn.prepareStatement("UPDATE p set rawbyte=? WHERE id=?");
        for (i = 0; i < 8; ++i) {
            prep.setBinaryStream(1, this.getRandomStream(10000, i), 0);
            prep.setInt(2, i);
            prep.execute();
        }
        prep.close();
        conn.commit();
        conn = this.reconnect(conn);
        conn.setAutoCommit(true);
        prep = conn.prepareStatement("UPDATE p set rawbyte=? WHERE id=?");
        for (i = 8; i < 10; ++i) {
            prep.setBinaryStream(1, this.getRandomStream(10000, i), 0);
            prep.setInt(2, i);
            prep.execute();
        }
        prep.close();
        prep = conn.prepareStatement("SELECT * from p");
        ResultSet rs = prep.executeQuery();
        while (rs.next()) {
            for (int i2 = 1; i2 <= rs.getMetaData().getColumnCount(); ++i2) {
                rs.getMetaData().getColumnName(i2);
                rs.getString(i2);
            }
        }
        conn.close();
    }

    void testLobReconnect() throws Exception {
        this.deleteDb("lob");
        Connection conn = this.reconnect(null);
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, TEXT CLOB)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(1, ?)");
        prep.setBinaryStream(1, this.getRandomStream(10000, 1), 0);
        prep.execute();
        conn = this.reconnect(conn);
        stat = conn.createStatement();
        prep = conn.prepareStatement("UPDATE TEST SET TEXT = ?");
        prep.setBinaryStream(1, this.getRandomStream(10201, 1), 0);
        prep.execute();
        conn = this.reconnect(conn);
        stat = conn.createStatement();
        ResultSet rs = stat.executeQuery("SELECT * FROM TEST WHERE ID=1");
        rs.next();
        this.checkStream(this.getRandomStream(10201, 1), rs.getBinaryStream("TEXT"), -1);
        stat.execute("DROP TABLE IF EXISTS TEST");
        conn.close();
    }

    void testLob(boolean clob) throws Exception {
        int size;
        int i;
        this.deleteDb("lob");
        Connection conn = this.reconnect(null);
        conn = this.reconnect(conn);
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, VALUE " + (clob ? "CLOB" : "BLOB") + ")");
        int len = this.getSize(1, 1000);
        long time = System.currentTimeMillis();
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, ?)");
        for (i = 0; i < len; i += i + 1) {
            prep.setInt(1, i);
            size = i * i;
            if (clob) {
                prep.setCharacterStream(2, this.getRandomReader(size, i), 0);
            } else {
                prep.setBinaryStream(2, this.getRandomStream(size, i), 0);
            }
            prep.execute();
        }
        this.trace("insert=" + (System.currentTimeMillis() - time));
        this.traceMemory();
        conn = this.reconnect(conn);
        time = System.currentTimeMillis();
        prep = conn.prepareStatement("SELECT ID, VALUE FROM TEST");
        ResultSet rs = prep.executeQuery();
        while (rs.next()) {
            int id = rs.getInt("ID");
            size = id * id;
            if (clob) {
                Reader rt = rs.getCharacterStream(2);
                this.checkReader(rt, this.getRandomReader(size, id), -1);
                this.checkReader((Reader)rs.getObject(2), this.getRandomReader(size, id), -1);
                continue;
            }
            InputStream in = rs.getBinaryStream(2);
            this.checkStream(in, this.getRandomStream(size, id), -1);
            this.checkStream((InputStream)rs.getObject(2), this.getRandomStream(size, id), -1);
        }
        this.trace("select=" + (System.currentTimeMillis() - time));
        this.traceMemory();
        conn = this.reconnect(conn);
        time = System.currentTimeMillis();
        prep = conn.prepareStatement("DELETE FROM TEST WHERE ID=?");
        for (i = 0; i < len; ++i) {
            prep.setInt(1, i);
            prep.executeUpdate();
        }
        this.trace("delete=" + (System.currentTimeMillis() - time));
        this.traceMemory();
        conn = this.reconnect(conn);
        conn.setAutoCommit(false);
        prep = conn.prepareStatement("INSERT INTO TEST VALUES(1, ?)");
        if (clob) {
            prep.setCharacterStream(1, this.getRandomReader(0, 0), 0);
        } else {
            prep.setBinaryStream(1, this.getRandomStream(0, 0), 0);
        }
        prep.execute();
        conn.rollback();
        prep.execute();
        conn.commit();
        conn.createStatement().execute("DELETE FROM TEST WHERE ID=1");
        conn.rollback();
        conn.createStatement().execute("DELETE FROM TEST WHERE ID=1");
        conn.commit();
        conn.createStatement().execute("DROP TABLE TEST");
        conn.close();
    }

    void testJavaObject() throws Exception {
        this.deleteDb("lob");
        Connection conn = this.getConnection("lob");
        conn.createStatement().execute("CREATE TABLE TEST(ID INT PRIMARY KEY, DATA BINARY)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(1, ?)");
        prep.setObject(1, new TestLobObject("abc"));
        prep.execute();
        ResultSet rs = conn.createStatement().executeQuery("SELECT * FROM TEST");
        rs.next();
        Object oa = rs.getObject(2);
        TestLobObject a = (TestLobObject)oa;
        Object ob = rs.getObject("DATA");
        TestLobObject b = (TestLobObject)ob;
        this.check(a.data, "abc");
        this.check(b.data, "abc");
        this.checkFalse(rs.next());
        conn.close();
    }

    private void checkStream(InputStream a, InputStream b, int len) throws Exception {
        a.read(new byte[0]);
        b.read(new byte[0]);
        a.read(new byte[10], 3, 0);
        b.read(new byte[10], 0, 0);
        for (int i = 0; len < 0 || i < len; ++i) {
            int ca = a.read();
            a.read(new byte[0]);
            int cb = b.read();
            this.check(ca, cb);
            if (ca == -1) break;
        }
        a.read(new byte[10], 3, 0);
        b.read(new byte[10], 0, 0);
        a.read(new byte[0]);
        b.read(new byte[0]);
        a.close();
        b.close();
    }

    private void checkReader(Reader a, Reader b, int len) throws Exception {
        for (int i = 0; len < 0 || i < len; ++i) {
            int ca = a.read();
            int cb = b.read();
            this.check(ca, cb);
            if (ca == -1) break;
        }
        a.close();
        b.close();
    }

    private Reader getRandomReader(int len, int seed) {
        Random random = new Random(seed);
        char[] buff = new char[len];
        for (int i = 0; i < len; ++i) {
            char ch;
            while ((ch = (char)random.nextInt(65535)) >= '\ud800' && ch <= '\udfff') {
            }
            buff[i] = (char)random.nextInt(10000);
        }
        return new CharArrayReader(buff);
    }

    private InputStream getRandomStream(int len, int seed) {
        Random random = new Random(seed);
        byte[] buff = new byte[len];
        random.nextBytes(buff);
        return new ByteArrayInputStream(buff);
    }
}

