/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.h2.test.TestBase;

public class TestLinkedTable
extends TestBase {
    public void test() throws Exception {
        this.deleteDb("linked1");
        this.deleteDb("linked2");
        Class.forName("org.h2.Driver");
        Connection conn = DriverManager.getConnection("jdbc:h2:" + BASE_DIR + "/linked1", "sa1", "abc");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TEMP TABLE TEST_TEMP(ID INT PRIMARY KEY)");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255), XT TINYINT, XD DECIMAL(10,2), XTS TIMESTAMP, XBY BINARY(255), XBO BIT, XSM SMALLINT, XBI BIGINT, XBL BLOB, XDA DATE, XTI TIME, XCL CLOB, XDO DOUBLE)");
        stat.execute("CREATE INDEX IDXNAME ON TEST(NAME)");
        stat.execute("INSERT INTO TEST VALUES(0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)");
        stat.execute("INSERT INTO TEST VALUES(1, 'Hello', -1, 10.30, '2001-02-03 11:22:33.4455', X'FF0102', TRUE, 3000, 1234567890123456789, X'1122AA', DATE '0002-01-01', TIME '00:00:00', 'J\u00fcrg', 2.25)");
        this.testRow(stat, "TEST");
        stat.execute("INSERT INTO TEST VALUES(2, 'World', 30, 100.05, '2005-12-31 12:34:56.789', X'FFEECC33', FALSE, 1, -1234567890123456789, X'4455FF', DATE '9999-12-31', TIME '23:59:59', 'George', -2.5)");
        this.testRow(stat, "TEST");
        stat.execute("SELECT * FROM TEST_TEMP");
        conn.close();
        conn = DriverManager.getConnection("jdbc:h2:" + BASE_DIR + "/linked1", "sa1", "abc");
        stat = conn.createStatement();
        this.testRow(stat, "TEST");
        try {
            stat.execute("SELECT * FROM TEST_TEMP");
            this.error("temp table must not be persistent");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        conn.close();
        conn = DriverManager.getConnection("jdbc:h2:" + BASE_DIR + "/linked2", "sa2", "def");
        stat = conn.createStatement();
        stat.execute("CREATE LINKED TABLE IF NOT EXISTS LINK_TEST('org.h2.Driver', 'jdbc:h2:" + BASE_DIR + "/linked1', 'sa1', 'abc', 'TEST')");
        stat.execute("CREATE LINKED TABLE IF NOT EXISTS LINK_TEST('org.h2.Driver', 'jdbc:h2:" + BASE_DIR + "/linked1', 'sa1', 'abc', 'TEST')");
        this.testRow(stat, "LINK_TEST");
        conn.close();
        conn = DriverManager.getConnection("jdbc:h2:" + BASE_DIR + "/linked2", "sa2", "def");
        stat = conn.createStatement();
        stat.execute("INSERT INTO LINK_TEST VALUES(3, 'Link Test', 30, 100.05, '2005-12-31 12:34:56.789', X'FFEECC33', FALSE, 1, -1234567890123456789, X'4455FF', DATE '9999-12-31', TIME '23:59:59', 'George', -2.5)");
        ResultSet rs = stat.executeQuery("SELECT COUNT(*) FROM LINK_TEST");
        rs.next();
        this.check(rs.getInt(1), 4L);
        rs = stat.executeQuery("SELECT COUNT(*) FROM LINK_TEST WHERE NAME='Link Test'");
        rs.next();
        this.check(rs.getInt(1), 1L);
        int uc = stat.executeUpdate("DELETE FROM LINK_TEST WHERE ID=3");
        this.check(uc, 1L);
        rs = stat.executeQuery("SELECT COUNT(*) FROM LINK_TEST");
        rs.next();
        this.check(rs.getInt(1), 3L);
        rs = stat.executeQuery("SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME='LINK_TEST'");
        rs.next();
        this.check(rs.getString("TABLE_TYPE"), "TABLE LINK");
        rs.next();
        rs = stat.executeQuery("SELECT * FROM LINK_TEST WHERE ID=0");
        rs.next();
        this.check(rs.getString("NAME") == null && rs.wasNull());
        this.check(rs.getString("XT") == null && rs.wasNull());
        this.check(rs.getInt("ID") == 0 && !rs.wasNull());
        this.check(rs.getBigDecimal("XD") == null && rs.wasNull());
        this.check(rs.getTimestamp("XTS") == null && rs.wasNull());
        this.check(rs.getBytes("XBY") == null && rs.wasNull());
        this.check(!rs.getBoolean("XBO") && rs.wasNull());
        this.check(rs.getShort("XSM") == 0 && rs.wasNull());
        this.check(rs.getLong("XBI") == 0L && rs.wasNull());
        this.check(rs.getString("XBL") == null && rs.wasNull());
        this.check(rs.getString("XDA") == null && rs.wasNull());
        this.check(rs.getString("XTI") == null && rs.wasNull());
        this.check(rs.getString("XCL") == null && rs.wasNull());
        this.check(rs.getString("XDO") == null && rs.wasNull());
        this.checkFalse(rs.next());
        stat.execute("DROP TABLE LINK_TEST");
        conn.close();
        this.deleteDb("linked1");
        this.deleteDb("linked2");
    }

    void testRow(Statement stat, String name) throws Exception {
        ResultSet rs = stat.executeQuery("SELECT * FROM " + name + " WHERE ID=1");
        rs.next();
        this.check(rs.getString("NAME"), "Hello");
        this.check(rs.getByte("XT"), -1L);
        BigDecimal bd = rs.getBigDecimal("XD");
        this.check(bd.equals(new BigDecimal("10.30")));
        Timestamp ts = rs.getTimestamp("XTS");
        String s = ts.toString();
        this.check(s, "2001-02-03 11:22:33.4455");
        this.check(ts.equals(Timestamp.valueOf("2001-02-03 11:22:33.4455")));
        this.check(rs.getBytes("XBY"), new byte[]{-1, 1, 2});
        this.check(rs.getBoolean("XBO"));
        this.check(rs.getShort("XSM"), 3000L);
        this.check(rs.getLong("XBI"), 1234567890123456789L);
        this.check(rs.getString("XBL"), "1122aa");
        this.check(rs.getString("XDA"), "0002-01-01");
        this.check(rs.getString("XTI"), "00:00:00");
        this.check(rs.getString("XCL"), "J\u00fcrg");
        this.check(rs.getString("XDO"), "2.25");
    }
}

