/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.coverage;

import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.LineNumberReader;

public class Profile
extends Thread {
    public static final boolean LIST_UNVISITED = true;
    public static final boolean FAST = false;
    public static final boolean TRACE = false;
    public static int current;
    public static Profile main;
    private BufferedWriter trace;
    public int[] count;
    public int[] time;
    boolean stop;
    int maxIndex;
    int lastIndex;
    long lastTime;
    static int top;

    public static void visit(int i) {
        main.addVisit(i);
    }

    public void run() {
        Profile.list();
    }

    public static void startCollecting() {
        Profile.main.stop = false;
        Profile.main.lastTime = System.currentTimeMillis();
    }

    public static void stopCollecting() {
        Profile.main.stop = true;
    }

    public static void list() {
        if (Profile.main.lastIndex == 0) {
            return;
        }
        try {
            main.listUnvisited();
            main.listTop("MOST CALLED", Profile.main.count, top);
            main.listTop("MOST TIME USED", Profile.main.time, top);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    Profile() {
        try {
            LineNumberReader r = new LineNumberReader(new FileReader("profile.txt"));
            while (r.readLine() != null) {
            }
            this.maxIndex = r.getLineNumber();
            this.count = new int[this.maxIndex];
            this.time = new int[this.maxIndex];
            this.lastTime = System.currentTimeMillis();
            Runtime.getRuntime().addShutdownHook(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    void addVisit(int i) {
        if (this.stop) {
            return;
        }
        long now = System.currentTimeMillis();
        int n = i;
        this.count[n] = this.count[n] + 1;
        int n2 = this.lastIndex;
        this.time[n2] = this.time[n2] + (int)(now - this.lastTime);
        this.lastTime = now;
        this.lastIndex = i;
    }

    void listUnvisited() throws Exception {
        this.printLine('=');
        this.print("NOT COVERED");
        this.printLine('-');
        LineNumberReader r = new LineNumberReader(new FileReader("profile.txt"));
        BufferedWriter writer = new BufferedWriter(new FileWriter("notcovered.txt"));
        int unvisited = 0;
        int unvisitedthrow = 0;
        for (int i = 0; i < this.maxIndex; ++i) {
            String line = r.readLine();
            if (this.count[i] != 0) continue;
            if (!line.endsWith("throw")) {
                writer.write(line + "\r\n");
                this.print(line + "\r\n");
                ++unvisited;
                continue;
            }
            ++unvisitedthrow;
        }
        writer.close();
        int percent = 100 * unvisited / this.maxIndex;
        this.print("Not covered: " + percent + " % " + " (" + unvisited + " of " + this.maxIndex + "; throw=" + unvisitedthrow + ")");
    }

    void listTop(String title, int[] list, int max) throws Exception {
        int i;
        this.printLine('-');
        int total = 0;
        int totallines = 0;
        for (int j = 0; j < this.maxIndex; ++j) {
            int l = list[j];
            if (l <= 0) continue;
            total += list[j];
            ++totallines;
        }
        if (max == 0) {
            max = totallines;
        }
        this.print(title);
        this.print("Total: " + total);
        this.printLine('-');
        String[] text = new String[max];
        int[] index = new int[max];
        for (int i2 = 0; i2 < max; ++i2) {
            int big = list[0];
            int bigIndex = 0;
            for (int j = 1; j < this.maxIndex; ++j) {
                int l = list[j];
                if (l <= big) continue;
                big = l;
                bigIndex = j;
            }
            list[bigIndex] = -(big + 1);
            index[i2] = bigIndex;
        }
        LineNumberReader r = new LineNumberReader(new FileReader("profile.txt"));
        for (i = 0; i < this.maxIndex; ++i) {
            String line = r.readLine();
            int k = list[i];
            if (k >= 0) continue;
            list[i] = k = -(k + 1);
            for (int j = 0; j < max; ++j) {
                if (index[j] != i) continue;
                int percent = 100 * k / total;
                text[j] = k + " " + percent + "%: " + line;
            }
        }
        for (i = 0; i < max; ++i) {
            this.print(text[i]);
        }
    }

    void print(String s) {
        System.out.println(s);
    }

    void printLine(char c) {
        for (int i = 0; i < 60; ++i) {
            System.out.print(c);
        }
        this.print("");
    }

    static {
        main = new Profile();
        top = 15;
        try {
            String s = System.getProperty("profile.top");
            if (s != null) {
                top = Integer.parseInt(s);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

