/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.h2.command.Parser;
import org.h2.engine.Mode;
import org.h2.engine.Schema;
import org.h2.engine.Sequence;
import org.h2.engine.Session;
import org.h2.expression.Expression;
import org.h2.expression.SequenceValue;
import org.h2.expression.ValueExpression;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.table.Table;
import org.h2.table.TableFilter;
import org.h2.value.DataType;
import org.h2.value.Value;
import org.h2.value.ValueInt;
import org.h2.value.ValueNull;
import org.h2.value.ValueString;
import org.h2.value.ValueTime;
import org.h2.value.ValueTimestamp;

public class Column {
    private Table table;
    private String name;
    private int type;
    private long precision;
    private int scale;
    private int columnId;
    private boolean nullable = true;
    private Expression defaultExpression;
    private String originalSQL;
    private boolean autoIncrement;
    private long start;
    private long increment;
    private boolean convertNullToDefault;
    private Sequence sequence;
    private boolean isComputed;
    private TableFilter computeTableFilter;
    private int selectivity;

    public Column(String name, int type, long precision, int scale) {
        this.name = name;
        this.type = type;
        this.precision = precision;
        this.scale = scale;
    }

    public boolean getComputed() {
        return this.isComputed;
    }

    public Value computeValue(Session session, Row row) throws SQLException {
        if (this.computeTableFilter == null) {
            this.computeTableFilter = new TableFilter(session, this.table, null, false);
        }
        this.computeTableFilter.setSession(session);
        this.computeTableFilter.set(row);
        this.defaultExpression.mapColumns(this.computeTableFilter, 0);
        this.defaultExpression = this.defaultExpression.optimize(session);
        return this.defaultExpression.getValue(session);
    }

    public void setComputed(boolean computed, Expression expression) {
        this.isComputed = computed;
        this.defaultExpression = expression;
    }

    void setTable(Table table, int columnId) {
        this.table = table;
        this.columnId = columnId;
    }

    public Table getTable() {
        return this.table;
    }

    public void setDefaultExpression(Session session, Expression defaultExpression) throws SQLException {
        if (defaultExpression != null && (defaultExpression = defaultExpression.optimize(session)).isConstant()) {
            defaultExpression = ValueExpression.get(defaultExpression.getValue(session));
        }
        this.defaultExpression = defaultExpression;
    }

    public int getColumnId() {
        return this.columnId;
    }

    public String getSQL() {
        return Parser.quoteIdentifier(this.name);
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public long getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public void setNullable(boolean b) {
        this.nullable = b;
    }

    public Value validateConvertUpdateSequence(Session session, Value value) throws SQLException {
        if (value == null) {
            value = this.defaultExpression == null ? ValueNull.INSTANCE : this.defaultExpression.getValue(session).convertTo(this.type);
        }
        if (value == ValueNull.INSTANCE) {
            if (this.convertNullToDefault) {
                value = this.defaultExpression.getValue(session).convertTo(this.type);
            }
            if (value == ValueNull.INSTANCE && !this.nullable) {
                if (Mode.getCurrentMode().convertInsertNullToZero) {
                    DataType dt = DataType.getDataType(this.type);
                    value = dt.decimal ? ValueInt.get(0).convertTo(this.type) : (dt.type == 11 ? ValueTimestamp.get(new Timestamp(System.currentTimeMillis())) : (dt.type == 9 ? ValueTime.get(Time.valueOf("0:0:0")) : (dt.type == 10 ? ValueTimestamp.get(new Timestamp(System.currentTimeMillis())).convertTo(dt.type) : ValueString.get("").convertTo(this.type))));
                } else {
                    throw Message.getSQLException(90007, this.name);
                }
            }
        }
        value = value.convertScale(Mode.getCurrentMode().convertOnlyToSmallerScale, this.scale);
        if (this.precision > 0L && value.getPrecision() > this.precision) {
            throw Message.getSQLException(90006, this.name);
        }
        this.updateSequenceIfRequired(session, value);
        return value;
    }

    private void updateSequenceIfRequired(Session session, Value value) throws SQLException {
        if (this.sequence != null) {
            long current = this.sequence.getCurrentValue();
            long increment = this.sequence.getIncrement();
            long now = value.getLong();
            boolean update = false;
            if (increment > 0L && now > current) {
                update = true;
            } else if (increment < 0L && now < current) {
                update = true;
            }
            if (update) {
                this.sequence.setStartValue(now + increment);
                session.setLastIdentity(now);
                session.getDatabase().update(session, this.sequence);
            }
        }
    }

    public void convertAutoIncrementToSequence(Session session, Schema schema, int id) throws SQLException {
        String sequenceName;
        if (!this.getAutoIncrement()) {
            throw Message.internal();
        }
        if (this.originalSQL.equals("IDENTITY")) {
            this.originalSQL = "BIGINT";
        }
        int i = 0;
        while (schema.findSequence(sequenceName = "SYSTEM_SEQUENCE_" + i) != null) {
            ++i;
        }
        Sequence sequence = new Sequence(schema, id, sequenceName, true);
        sequence.setStartValue(this.start);
        sequence.setIncrement(this.increment);
        session.getDatabase().addSchemaObject(session, sequence);
        this.setAutoIncrement(false, 0L, 0L);
        SequenceValue seq = new SequenceValue(sequence);
        this.setDefaultExpression(session, seq);
        this.setSequence(sequence);
    }

    public String getCreateSQL() {
        String sql;
        StringBuffer buff = new StringBuffer();
        if (this.name != null) {
            buff.append(Parser.quoteIdentifier(this.name));
            buff.append(' ');
        }
        if (this.originalSQL != null) {
            buff.append(this.originalSQL);
        } else {
            buff.append(DataType.getTypeName(this.type));
            switch (this.type) {
                case 6: {
                    buff.append("(");
                    buff.append(this.precision);
                    buff.append(", ");
                    buff.append(this.scale);
                    buff.append(")");
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    buff.append("(");
                    buff.append(this.precision);
                    buff.append(")");
                }
            }
        }
        if (this.defaultExpression != null && (sql = this.defaultExpression.getSQL()) != null) {
            if (this.isComputed) {
                buff.append(" AS ");
                buff.append(sql);
            } else if (this.defaultExpression != null) {
                buff.append(" DEFAULT ");
                buff.append(sql);
            }
        }
        if (!this.nullable) {
            buff.append(" NOT NULL");
        }
        if (this.convertNullToDefault) {
            buff.append(" NULL_TO_DEFAULT");
        }
        if (this.sequence != null) {
            buff.append(" SEQUENCE ");
            buff.append(this.sequence.getSQL());
        }
        if (this.selectivity != 0) {
            buff.append(" SELECTIVITY ");
            buff.append(this.selectivity);
        }
        return buff.toString();
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setOriginalSQL(String original) {
        this.originalSQL = original;
    }

    public Expression getDefaultExpression() {
        return this.defaultExpression;
    }

    public boolean getAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoInc, long start, long increment) {
        this.autoIncrement = autoInc;
        this.start = start;
        this.increment = increment;
        this.nullable = false;
        if (autoInc) {
            this.convertNullToDefault = true;
        }
    }

    public void setConvertNullToDefault(boolean convert) {
        this.convertNullToDefault = convert;
    }

    public void rename(String newName) {
        this.name = newName;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public Column getClone() {
        Column newColumn = new Column(this.name, this.type, this.precision, this.scale);
        newColumn.nullable = this.nullable;
        newColumn.defaultExpression = this.defaultExpression;
        newColumn.originalSQL = this.originalSQL;
        newColumn.convertNullToDefault = this.convertNullToDefault;
        newColumn.sequence = this.sequence;
        return newColumn;
    }

    public int getSelectivity() {
        return this.selectivity == 0 ? 50 : this.selectivity;
    }

    public void setSelectivity(int selectivity) {
        this.selectivity = selectivity = selectivity < 0 ? 0 : (selectivity > 100 ? 100 : selectivity);
    }
}

