/*
 * Decompiled with CFR 0.152.
 */
package org.h2.server;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashSet;
import org.h2.server.OdbcServerThread;
import org.h2.server.Service;
import org.h2.server.TcpServerThread;
import org.h2.util.NetUtils;

public class OdbcServer
implements Service {
    static final int DEFAULT_PORT = 9083;
    private String driver = "org.h2.Driver";
    private int port = 9083;
    private boolean stop;
    private boolean log = true;
    private ServerSocket serverSocket;
    private HashSet running = new HashSet();
    private String baseDir;
    private String url;
    private boolean allowOthers;
    private boolean ifExists;

    boolean getLog() {
        return this.log;
    }

    void log(String s) {
        if (this.log) {
            System.out.println(s);
        }
    }

    void logError(Exception e) {
        if (this.log) {
            e.printStackTrace();
        }
    }

    public void init(String[] args) throws Exception {
        this.port = 9083;
        for (int i = 0; i < args.length; ++i) {
            String a = args[i];
            if (a.equals("-log")) {
                this.log = Boolean.valueOf(args[++i]);
                continue;
            }
            if (a.equals("-odbcPort")) {
                this.port = Integer.parseInt(args[++i]);
                continue;
            }
            if (a.equals("-baseDir")) {
                this.baseDir = args[++i];
                continue;
            }
            if (a.equals("-odbcAllowOthers")) {
                this.allowOthers = Boolean.valueOf(args[++i]);
                continue;
            }
            if (!a.equals("-ifExists")) continue;
            this.ifExists = Boolean.valueOf(args[++i]);
        }
        Class.forName(this.driver);
        this.url = "tcp://localhost:" + this.port;
    }

    public String getURL() {
        return this.url;
    }

    boolean allow(Socket socket) {
        if (this.allowOthers) {
            return true;
        }
        return socket.getInetAddress().isLoopbackAddress();
    }

    public void start() throws Exception {
        this.serverSocket = NetUtils.createServerSocket(this.port, false);
    }

    public void listen() throws Exception {
        block4: {
            String threadName = Thread.currentThread().getName();
            try {
                while (!this.stop) {
                    Socket s = this.serverSocket.accept();
                    if (!this.allow(s)) {
                        this.log("Connection not allowed");
                        s.close();
                        continue;
                    }
                    OdbcServerThread c = new OdbcServerThread(s, this);
                    this.running.add(c);
                    Thread thread = new Thread(c);
                    thread.setName(threadName + " thread");
                    c.setThread(thread);
                    thread.start();
                }
            }
            catch (Exception e) {
                if (this.stop) break block4;
                e.printStackTrace();
            }
        }
    }

    public void stop() {
        if (!this.stop) {
            this.stop = true;
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.serverSocket = null;
            }
        }
        ArrayList list = new ArrayList(this.running);
        for (int i = 0; i < list.size(); ++i) {
            TcpServerThread c = (TcpServerThread)list.get(i);
            c.close();
            try {
                c.getThread().join(100L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isRunning() {
        if (this.serverSocket == null) {
            return false;
        }
        try {
            Socket s = new Socket(this.serverSocket.getInetAddress(), this.serverSocket.getLocalPort());
            s.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public boolean getAllowOthers() {
        return this.allowOthers;
    }

    public String getType() {
        return "ODBC";
    }

    public boolean getIfExists() {
        return this.ifExists;
    }
}

