/*
 * Decompiled with CFR 0.152.
 */
package org.h2.samples;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.api.DatabaseEventListener;
import org.h2.jdbc.JdbcConnection;

public class ShowProgress
implements DatabaseEventListener {
    private long last;
    private long start;

    public ShowProgress() {
        this.start = this.last = System.currentTimeMillis();
    }

    public static void main(String[] args) throws Exception {
        new ShowProgress().test();
    }

    void test() throws Exception {
        Class.forName("org.h2.Driver");
        Connection conn = DriverManager.getConnection("jdbc:h2:test;log=2", "sa", "");
        Statement stat = conn.createStatement();
        stat.execute("DROP TABLE IF EXISTS TEST");
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR)");
        PreparedStatement prep = conn.prepareStatement("INSERT INTO TEST VALUES(?, 'Test' || SPACE(100))");
        long time = System.currentTimeMillis();
        int len = 1000;
        for (int i = 0; i < len; ++i) {
            long last = System.currentTimeMillis();
            if (last > time + 1000L) {
                time = last;
                System.out.println("Inserting " + 100L * (long)i / (long)len + "%");
            }
            prep.setInt(1, i);
            prep.execute();
        }
        boolean abnormalTermination = true;
        if (abnormalTermination) {
            ((JdbcConnection)conn).setPowerOffCount(1);
            try {
                stat.execute("INSERT INTO TEST VALUES(-1, 'Test' || SPACE(100))");
            }
            catch (SQLException e) {}
        } else {
            conn.close();
        }
        System.out.println("Open connection...");
        time = System.currentTimeMillis();
        conn = DriverManager.getConnection("jdbc:h2:test;log=2;database_event_listener='" + this.getClass().getName() + "'", "sa", "");
        time = System.currentTimeMillis() - time;
        System.out.println("Done after " + time + " ms");
        conn.close();
    }

    public void diskSpaceIsLow(long stillAvailable) throws SQLException {
        System.out.println("diskSpaceIsLow stillAvailable=" + stillAvailable);
    }

    public void exceptionThrown(SQLException e) {
        e.printStackTrace();
    }

    public void setProgress(int state, String name, int current, int max) {
        long time = System.currentTimeMillis();
        if (time < this.last + 500L) {
            return;
        }
        this.last = time;
        String stateName = "?";
        switch (state) {
            case 0: {
                stateName = "Scan " + name;
                break;
            }
            case 1: {
                stateName = "Create Index " + name;
                break;
            }
            case 2: {
                stateName = "Recover";
            }
        }
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        System.out.println("State: " + stateName + " " + 100 * current / max + "% (" + current + " of " + max + ") " + (time - this.start) + " ms");
    }

    public void closingDatabase() {
        System.out.println("Closing the database");
    }
}

