/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.sql.SQLException;
import java.text.Collator;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.engine.Constants;
import org.h2.engine.Database;
import org.h2.engine.Mode;
import org.h2.engine.Setting;
import org.h2.message.Message;
import org.h2.table.Table;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;

public class Set
extends Prepared {
    public static final int IGNORECASE = 1;
    public static final int MAX_LOG_SIZE = 2;
    public static final int MODE = 3;
    public static final int READONLY = 4;
    public static final int LOCK_TIMEOUT = 5;
    public static final int DEFAULT_LOCK_TIMEOUT = 6;
    public static final int DEFAULT_TABLE_TYPE = 7;
    public static final int CACHE_SIZE = 8;
    public static final int TRACE_LEVEL_SYSTEM_OUT = 9;
    public static final int TRACE_LEVEL_FILE = 10;
    public static final int TRACE_MAX_FILE_SIZE = 11;
    public static final int COLLATION = 12;
    public static final int CLUSTER = 13;
    public static final int WRITE_DELAY = 14;
    public static final int DATABASE_EVENT_LISTENER = 15;
    public static final int MAX_MEMORY_ROWS = 16;
    public static final int LOCK_MODE = 17;
    public static final int ASSERT = 18;
    public static final int DB_CLOSE_DELAY = 19;
    public static final int LOG = 20;
    public static final int THROTTLE = 21;
    private int type;
    private int value;
    private String stringValue;
    private static ObjectArray types = new ObjectArray();

    private static void setType(int type, String name) {
        while (types.size() <= type) {
            types.add(null);
        }
        types.set(type, name);
    }

    public static int getType(String name) {
        for (int i = 0; i < types.size(); ++i) {
            if (!name.equals(types.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static String getTypeName(int type) {
        return (String)types.get(type);
    }

    public Set(Parser parser, int type) {
        super(parser);
        this.type = type;
    }

    public void setInt(int value) {
        this.value = value;
    }

    public void setString(String v) {
        this.stringValue = v;
    }

    public boolean isTransactional() {
        return false;
    }

    public int update() throws SQLException {
        Database database = this.session.getDatabase();
        String name = Set.getTypeName(this.type);
        switch (this.type) {
            case 2: {
                this.session.getUser().checkAdmin();
                this.session.getDatabase().getLog().setMaxLogSize(this.value * 1024 * 1024);
                this.addOrUpdateSetting(name, null, this.value);
                break;
            }
            case 5: {
                this.session.setLockTimeout(this.value);
                break;
            }
            case 17: {
                this.session.getUser().checkAdmin();
                database.setLockMode(this.value);
                this.addOrUpdateSetting(name, null, this.value);
                break;
            }
            case 6: {
                this.session.getUser().checkAdmin();
                this.addOrUpdateSetting(name, null, this.value);
                break;
            }
            case 7: {
                this.session.getUser().checkAdmin();
                this.addOrUpdateSetting(name, null, this.value);
                break;
            }
            case 9: {
                this.session.getUser().checkAdmin();
                database.getTraceSystem().setLevelSystemOut(this.value);
                this.addOrUpdateSetting(name, null, this.value);
                break;
            }
            case 10: {
                this.session.getUser().checkAdmin();
                database.getTraceSystem().setLevelFile(this.value);
                this.addOrUpdateSetting(name, null, this.value);
                break;
            }
            case 11: {
                this.session.getUser().checkAdmin();
                int size = this.value * 1024 * 1024;
                database.getTraceSystem().setMaxFileSize(size);
                this.addOrUpdateSetting(name, null, this.value);
                break;
            }
            case 8: {
                this.session.getUser().checkAdmin();
                database.setCacheSize(this.value);
                this.addOrUpdateSetting(name, null, this.value);
                break;
            }
            case 3: {
                this.session.getUser().checkAdmin();
                Mode mode = Mode.getMode(this.stringValue);
                if (mode == null) {
                    throw Message.getSQLException(90088, this.stringValue);
                }
                Mode.setCurrentMode(mode);
                break;
            }
            case 12: {
                CompareMode compareMode;
                this.session.getUser().checkAdmin();
                ObjectArray array = database.getAllSchemaObjects(0);
                for (int i = 0; i < array.size(); ++i) {
                    Table table = (Table)array.get(i);
                    if (table.getCreateSQL() == null) continue;
                    throw Message.getSQLException(90089, table.getSQL());
                }
                StringBuffer buff = new StringBuffer(this.stringValue);
                if (this.stringValue.equals("OFF")) {
                    compareMode = new CompareMode(null);
                } else {
                    Collator coll = CompareMode.getCollator(this.stringValue);
                    compareMode = new CompareMode(coll);
                    buff.append(" STRENGTH ");
                    if (this.value == 3) {
                        buff.append("IDENTICAL");
                    } else if (this.value == 0) {
                        buff.append("PRIMARY");
                    } else if (this.value == 1) {
                        buff.append("SECONDARY");
                    } else if (this.value == 2) {
                        buff.append("TERTIARY");
                    }
                    coll.setStrength(this.value);
                }
                this.addOrUpdateSetting(name, buff.toString(), 0);
                database.setCompareMode(compareMode);
                break;
            }
            case 13: {
                this.session.getUser().checkAdmin();
                database.setCluster(StringUtils.quoteStringSQL(this.stringValue));
                this.addOrUpdateSetting(name, StringUtils.quoteStringSQL(this.stringValue), 0);
                break;
            }
            case 14: {
                this.session.getUser().checkAdmin();
                database.setWriteDelay(this.value);
                this.addOrUpdateSetting(name, null, this.value);
                break;
            }
            case 15: {
                this.session.getUser().checkAdmin();
                database.setEventListener(this.stringValue);
                break;
            }
            case 16: {
                this.session.getUser().checkAdmin();
                database.setMaxMemoryRows(this.value);
                this.addOrUpdateSetting(name, null, this.value);
                break;
            }
            case 18: {
                this.session.getUser().checkAdmin();
                Constants.CHECK = this.value == 1;
                break;
            }
            case 19: {
                this.session.getUser().checkAdmin();
                database.setCloseDelay(this.value);
                this.addOrUpdateSetting(name, null, this.value);
                break;
            }
            case 20: {
                if (this.value < 0 || this.value > 2) {
                    throw Message.getInvalidValueException("" + this.value, "LOG");
                }
                if (this.value == 0) {
                    this.session.getUser().checkAdmin();
                }
                database.setLog(this.value);
                break;
            }
            case 21: {
                if (this.value < 0) {
                    throw Message.getInvalidValueException("" + this.value, "THROTTLE");
                }
                this.session.setThrottle(this.value);
                break;
            }
            default: {
                throw Message.internal("type=" + this.type);
            }
        }
        return 0;
    }

    private void addOrUpdateSetting(String name, String s, int v) throws SQLException {
        Database database = this.session.getDatabase();
        if (database.getReadOnly()) {
            return;
        }
        Setting setting = database.findSetting(name);
        boolean addNew = false;
        if (setting == null) {
            addNew = true;
            int id = this.getObjectId(false, true);
            setting = new Setting(database, id, name);
        }
        if (s != null) {
            if (!addNew && setting.getStringValue().equals(s)) {
                return;
            }
            setting.setStringValue(s);
        } else {
            if (!addNew && setting.getIntValue() == v) {
                return;
            }
            setting.setIntValue(v);
        }
        if (addNew) {
            database.addDatabaseObject(this.session, setting);
        } else {
            database.update(this.session, setting);
        }
    }

    public boolean needRecompile() {
        return false;
    }

    static {
        Set.setType(1, "IGNORECASE");
        Set.setType(2, "MAX_LOG_SIZE");
        Set.setType(3, "MODE");
        Set.setType(4, "READONLY");
        Set.setType(5, "LOCK_TIMEOUT");
        Set.setType(6, "DEFAULT_LOCK_TIMEOUT");
        Set.setType(7, "DEFAULT_TABLE_TYPE");
        Set.setType(8, "CACHE_SIZE");
        Set.setType(9, "TRACE_LEVEL_SYSTEM_OUT");
        Set.setType(10, "TRACE_LEVEL_FILE");
        Set.setType(11, "TRACE_MAX_FILE_SIZE");
        Set.setType(12, "COLLATION");
        Set.setType(13, "CLUSTER");
        Set.setType(14, "WRITE_DELAY");
        Set.setType(15, "DATABASE_EVENT_LISTENER");
        Set.setType(16, "MAX_MEMORY_ROWS");
        Set.setType(17, "LOCK_MODE");
        Set.setType(18, "ASSERT");
        Set.setType(19, "DB_CLOSE_DELAY");
        Set.setType(20, "LOG");
        Set.setType(21, "THROTTLE");
    }
}

