/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Schema;
import org.h2.message.Message;
import org.h2.table.Table;

public class DropView
extends SchemaCommand {
    private String viewName;
    private boolean ifExists;

    public DropView(Parser parser, Schema schema) {
        super(parser, schema);
    }

    public void setIfExists(boolean b) {
        this.ifExists = b;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public int update() throws SQLException {
        this.session.commit();
        Table view = this.getSchema().findTableOrView(this.session, this.viewName);
        if (view == null) {
            if (!this.ifExists) {
                throw Message.getSQLException(90037, this.viewName);
            }
        } else {
            this.session.getUser().checkRight(view, 15);
            view.lock(this.session, true);
            this.session.getDatabase().removeSchemaObject(this.session, view);
        }
        return 0;
    }
}

