/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Schema;
import org.h2.message.Message;
import org.h2.table.Table;

public class AlterTableRename
extends SchemaCommand {
    private Table oldTable;
    private String newTableName;

    public AlterTableRename(Parser parser, Schema schema) {
        super(parser, schema);
    }

    public void setOldTable(Table table) {
        this.oldTable = table;
    }

    public void setNewTableName(String name) {
        this.newTableName = name;
    }

    public int update() throws SQLException {
        this.session.commit();
        Database db = this.session.getDatabase();
        if (this.getSchema().findTableOrView(this.session, this.newTableName) != null || this.newTableName.equals(this.oldTable.getName())) {
            throw Message.getSQLException(42101, this.newTableName);
        }
        this.session.getUser().checkRight(this.oldTable, 15);
        db.renameSchemaObject(this.session, this.oldTable, this.newTableName);
        return 0;
    }
}

