/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.pudl;

import de.tu_darmstadt.sp.paul.PDFDictionary;
import de.tu_darmstadt.sp.paul.PDFName;
import de.tu_darmstadt.sp.pudl.Annotation;
import de.tu_darmstadt.sp.pudl.LinkAnnotation;
import de.tu_darmstadt.sp.pudl.TextAnnotation;
import de.tu_darmstadt.sp.pudl.UnknownAnnotation;

public class AnnotationFactory {
    static AnnotationFactory currentFactory = new AnnotationFactory();

    Annotation createAnnot(PDFDictionary dict) {
        PDFName subtype = (PDFName)dict.get(PDFName.SUBTYPE);
        if (subtype.equals(PDFName.TEXT)) {
            return new TextAnnotation(dict);
        }
        if (subtype.equals(PDFName.LINK)) {
            return new LinkAnnotation(dict);
        }
        return new UnknownAnnotation(dict);
    }

    public static Annotation createAnnotation(PDFDictionary dict) {
        return currentFactory.createAnnot(dict);
    }

    public AnnotationFactory getFactory() {
        return currentFactory;
    }

    public static void setFactory(AnnotationFactory factory) {
        currentFactory = factory;
    }
}

