/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.unit;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.h2.test.TestBase;
import org.h2.tools.ChangePassword;
import org.h2.tools.DeleteDbFiles;
import org.h2.tools.Server;
import org.h2.util.Resources;

public class TestTools
extends TestBase {
    public void test() throws Exception {
        this.deleteDb("utils");
        Resources.main(new String[]{"."});
        Class.forName("org.h2.Driver");
        Connection conn = DriverManager.getConnection("jdbc:h2:" + BASE_DIR + "/utils;CIPHER=XTEA;STORAGE=TEXT", "sa", "abc 123");
        Statement stat = conn.createStatement();
        stat.execute("CREATE TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        conn.close();
        String[] args = new String[]{"-dir", BASE_DIR, "-db", "utils", "-cipher", "XTEA", "-decrypt", "abc", "-quiet"};
        ChangePassword.main(args);
        args = new String[]{"-dir", BASE_DIR, "-db", "utils", "-cipher", "AES", "-encrypt", "def", "-quiet"};
        ChangePassword.main(args);
        conn = DriverManager.getConnection("jdbc:h2:" + BASE_DIR + "/utils;CIPHER=AES", "sa", "def 123");
        stat = conn.createStatement();
        stat.execute("SELECT * FROM TEST");
        conn.close();
        args = new String[]{"-dir", BASE_DIR, "-db", "utils", "-quiet"};
        DeleteDbFiles.main(args);
        Server server = Server.startTcpServer(new String[]{"-ifExists", "false"});
        conn = DriverManager.getConnection("jdbc:h2:tcp://localhost/test", "sa", "");
        conn.close();
        server.stop();
        server = Server.startTcpServer(new String[]{"-ifExists", "true", "-tcpPassword", "abc"});
        try {
            conn = DriverManager.getConnection("jdbc:h2:tcp://localhost/test2", "sa", "");
            this.error("may not create new db");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
        conn = DriverManager.getConnection("jdbc:h2:tcp://localhost/test", "sa", "");
        conn.close();
        Server.shutdownTcpServer("tcp://localhost", "", true);
        conn = DriverManager.getConnection("jdbc:h2:tcp://localhost/test", "sa", "");
        conn.close();
        Server.shutdownTcpServer("tcp://localhost", "abc", true);
        try {
            conn = DriverManager.getConnection("jdbc:h2:tcp://localhost/test", "sa", "");
            this.error("server must have been closed");
        }
        catch (SQLException e) {
            this.checkNotGeneralException(e);
        }
    }
}

