/*
 * Decompiled with CFR 0.152.
 */
package org.h2.store;

import java.sql.SQLException;
import org.h2.engine.Constants;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.DataPage;

public class DataPageText
extends DataPage {
    public DataPageText(DataHandler handler, byte[] data) {
        super(handler, data);
    }

    public void setInt(int pos, int x) {
        int i = 7;
        while (i >= 0) {
            this.data[i] = (byte)Character.forDigit(x & 0xF, 16);
            --i;
            x >>>= 4;
        }
    }

    public void updateChecksum() {
        int x = this.handler.getChecksum(this.data, 0, this.pos - 2);
        this.data[this.pos - 2] = (byte)(97 + ((x ^ x >> 4) & 0xF));
    }

    public void check(int len) throws SQLException {
        int x = this.handler.getChecksum(this.data, 0, len - 2);
        if (this.data[len - 2] == (byte)(97 + ((x ^ x >> 4) & 0xF))) {
            return;
        }
        this.handler.handleInvalidChecksum();
    }

    public int getFillerLength() {
        return 2;
    }

    public void writeInt(int x) {
        if (Constants.CHECK) {
            this.checkCapacity(8);
        }
        int i = 7;
        while (i >= 0) {
            this.data[this.pos + i] = (byte)Character.forDigit(x & 0xF, 16);
            --i;
            x >>>= 4;
        }
        this.pos += 8;
    }

    public int readInt() {
        int x = 0;
        if (this.data[this.pos] == 32) {
            this.pos += 8;
            return 0;
        }
        for (int i = 8; i > 0; --i) {
            byte c;
            x <<= 4;
            x |= (c = this.data[this.pos++]) >= 97 ? c - 97 + 10 : c - 48;
        }
        return x;
    }

    public int getIntLen() {
        return 8;
    }

    public int getLongLen(long x) {
        return 16;
    }

    public int getStringLen(String s) {
        int len = 2 + s.length() + 1;
        block3: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\"': 
                case '\\': {
                    ++len;
                    continue block3;
                }
                default: {
                    int ch = c & 0xFFFF;
                    if (ch >= 32 && ch <= 255) continue block3;
                    len += 5;
                }
            }
        }
        return len;
    }

    public String readString() {
        char x;
        StringBuffer buff = new StringBuffer(32);
        if (Constants.CHECK && this.data[this.pos] != 34) {
            throw Message.internal("\" expected");
        }
        ++this.pos;
        block10: while ((x = (char)(this.data[this.pos++] & 0xFF)) != '\"') {
            if (x == '\\') {
                x = (char)this.data[this.pos++];
                switch (x) {
                    case 't': {
                        buff.append('\t');
                        continue block10;
                    }
                    case 'r': {
                        buff.append('\r');
                        continue block10;
                    }
                    case 'n': {
                        buff.append('\n');
                        continue block10;
                    }
                    case 'b': {
                        buff.append('\b');
                        continue block10;
                    }
                    case 'f': {
                        buff.append('\f');
                        continue block10;
                    }
                    case '\"': {
                        buff.append('\"');
                        continue block10;
                    }
                    case '\\': {
                        buff.append('\\');
                        continue block10;
                    }
                    case 'u': {
                        x = '\u0000';
                        for (int i = 3; i >= 0; --i) {
                            byte c;
                            x = (char)(x << 4);
                            x = (char)(x | ((c = this.data[this.pos++]) >= 97 ? c - 97 + 10 : c - 48));
                        }
                        buff.append(x);
                        continue block10;
                    }
                }
                throw Message.internal("unexpected " + x);
            }
            buff.append(x);
        }
        ++this.pos;
        return buff.toString();
    }

    public void writeString(String s) {
        this.checkCapacity(s.length() * 6 + 2);
        this.data[this.pos++] = 34;
        block9: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\t': {
                    this.data[this.pos++] = 92;
                    this.data[this.pos++] = 116;
                    continue block9;
                }
                case '\r': {
                    this.data[this.pos++] = 92;
                    this.data[this.pos++] = 114;
                    continue block9;
                }
                case '\n': {
                    this.data[this.pos++] = 92;
                    this.data[this.pos++] = 110;
                    continue block9;
                }
                case '\b': {
                    this.data[this.pos++] = 92;
                    this.data[this.pos++] = 98;
                    continue block9;
                }
                case '\f': {
                    this.data[this.pos++] = 92;
                    this.data[this.pos++] = 102;
                    continue block9;
                }
                case '\"': {
                    this.data[this.pos++] = 92;
                    this.data[this.pos++] = 34;
                    continue block9;
                }
                case '\\': {
                    this.data[this.pos++] = 92;
                    this.data[this.pos++] = 92;
                    continue block9;
                }
                default: {
                    int ch = c & 0xFFFF;
                    if (ch >= 32 && ch <= 255) {
                        this.data[this.pos++] = (byte)ch;
                        continue block9;
                    }
                    this.data[this.pos++] = 92;
                    this.data[this.pos++] = 117;
                    int j = 3;
                    while (j >= 0) {
                        this.data[this.pos + j] = (byte)Character.forDigit(ch & 0xF, 16);
                        --j;
                        ch >>>= 4;
                    }
                    this.pos += 4;
                }
            }
        }
        this.data[this.pos++] = 34;
        this.data[this.pos++] = 32;
    }

    public void fill(int len) {
        if (this.pos > len) {
            this.pos = len;
        }
        this.checkCapacity(len - this.pos);
        while (this.pos < len) {
            this.data[this.pos++] = 32;
        }
        this.data[this.pos - 1] = 10;
    }
}

