/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class Subsequence
extends OXMLFunction {
    private int numParams;

    Subsequence(int n) {
        this.numParams = n;
    }

    public String getFunctionName() {
        return "subsequence";
    }

    public int getNumberArgs() {
        return this.numParams;
    }

    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.ITEM_ZERO_OR_MORE;
    }

    public OXMLSequenceType getArgType(int n) {
        if (n == 0) {
            return OXMLSequenceType.ITEM_ZERO_OR_MORE;
        }
        if (n == 1) {
            return OXMLSequenceType.TDOUBLE;
        }
        if (n == 2) {
            return OXMLSequenceType.TDOUBLE;
        }
        return null;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence, OXMLSequence oXMLSequence2) throws XQException {
        OXMLSequence oXMLSequence3 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = FNUtil.getSingleItem(oXMLSequence2);
        double d = oXMLItem.getDouble();
        if (Double.isNaN(d)) {
            return oXMLSequence3;
        }
        int n = (int)Math.floor(d + 0.5);
        n = n < 1 ? 1 : n;
        int n2 = 1;
        while (oXMLSequence.next()) {
            if (n2 >= n) {
                OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
                oXMLItem2.copyItem(oXMLSequence.getItem());
                oXMLSequence3.appendItem(oXMLItem2);
            }
            ++n2;
        }
        return oXMLSequence3;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length != this.numParams) {
            throw new XQException("FORT0001");
        }
        if (oXMLSequenceArray.length == 3) {
            OXMLSequence oXMLSequence = oXMLFunctionContext.createSequence();
            OXMLItem oXMLItem = FNUtil.getSingleItem(oXMLSequenceArray[1]);
            double d = oXMLItem.getDouble();
            OXMLItem oXMLItem2 = FNUtil.getSingleItem(oXMLSequenceArray[2]);
            double d2 = oXMLItem2.getDouble();
            if (Double.isNaN(d) || Double.isNaN(d2) || d2 < 0.0) {
                return oXMLSequence;
            }
            int n = (int)Math.floor(d + 0.5);
            n = n < 1 ? 1 : n;
            int n2 = (int)Math.floor(d2 + 0.5);
            int n3 = 1;
            while (oXMLSequenceArray[0].next()) {
                if (n3 >= n && n3 < n + n2) {
                    OXMLItem oXMLItem3 = oXMLFunctionContext.createItem();
                    oXMLItem3.copyItem(oXMLSequenceArray[0].getItem());
                    oXMLSequence.appendItem(oXMLItem3);
                }
                ++n3;
            }
            return oXMLSequence;
        }
        return this.invoke(oXMLFunctionContext, oXMLSequenceArray[0], oXMLSequenceArray[1]);
    }
}

