/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.pobjects.security.SecurityManager;

public class HexStringObject
implements StringObject {
    private static Logger logger = Logger.getLogger(HexStringObject.class.toString());
    private StringBuffer stringData;
    Reference reference;

    public HexStringObject(byte[] byArray) {
        this(new StringBuffer(byArray.length).append(new String(byArray)));
    }

    public HexStringObject(StringBuffer stringBuffer) {
        stringBuffer.deleteCharAt(0);
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        this.stringData = new StringBuffer(stringBuffer.length());
        this.stringData.append(HexStringObject.normalizeHex(stringBuffer).toString());
    }

    public int getUnsignedInt(int n, int n2) {
        int n3;
        block3: {
            if (n < 0 || this.stringData.length() < n + n2) {
                return 0;
            }
            n3 = 0;
            try {
                n3 = Integer.parseInt(this.stringData.substring(n, n + n2), 16);
            }
            catch (NumberFormatException numberFormatException) {
                if (!logger.isLoggable(Level.FINE)) break block3;
                logger.warning("Number Format Exception " + n3);
            }
        }
        return n3;
    }

    public String toString() {
        return this.getLiteralString();
    }

    public String getHexString() {
        return this.stringData.toString();
    }

    public StringBuffer getHexStringBuffer() {
        return this.stringData;
    }

    public StringBuffer getLiteralStringBuffer() {
        return this.hexToString(this.stringData);
    }

    public String getLiteralString() {
        return this.hexToString(this.stringData).toString();
    }

    public StringBuffer getLiteralStringBuffer(int n, FontFile fontFile) {
        if (n == 1) {
            int n2 = 2;
            int n3 = this.getLength();
            StringBuffer stringBuffer = new StringBuffer(n3);
            int n4 = 0;
            for (int i = 0; i < n3; i += n2) {
                int n5 = this.getUnsignedInt(i - n4, n4 + n2);
                if (n5 > 0 && fontFile.canDisplayEchar((char)n5)) {
                    stringBuffer.append((char)n5);
                    n4 = 0;
                    continue;
                }
                n4 += n2;
            }
            return stringBuffer;
        }
        if (n == 2) {
            int n6 = 4;
            int n7 = this.getLength();
            StringBuffer stringBuffer = new StringBuffer(n7);
            for (int i = 0; i < n7; i += n6) {
                int n8 = this.getUnsignedInt(i, n6);
                if (!fontFile.canDisplayEchar((char)n8)) continue;
                stringBuffer.append((char)n8);
            }
            return stringBuffer;
        }
        return null;
    }

    public int getLength() {
        return this.stringData.length();
    }

    private static StringBuffer normalizeHex(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        for (int i = 0; i < n; ++i) {
            if (!HexStringObject.isNoneHexChar(stringBuffer.charAt(i))) continue;
            stringBuffer.deleteCharAt(i);
            --n;
            --i;
        }
        n = stringBuffer.length();
        if (n % 2 != 0) {
            stringBuffer.append('0');
        }
        if (n > 2 && n % 4 != 0) {
            stringBuffer.append("00");
        }
        return stringBuffer;
    }

    private static boolean isNoneHexChar(char c) {
        return !(c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f');
    }

    private StringBuffer hexToString(StringBuffer stringBuffer) {
        if (!(stringBuffer.charAt(0) == 'F' | stringBuffer.charAt(0) == 'f' && stringBuffer.charAt(1) == 'E' | stringBuffer.charAt(1) == 'e' && stringBuffer.charAt(2) == 'F' | stringBuffer.charAt(2) == 'f' && stringBuffer.charAt(3) == 'F' | stringBuffer.charAt(3) == 'f')) {
            int n = stringBuffer.length();
            StringBuffer stringBuffer2 = new StringBuffer(n / 2);
            for (int i = 0; i < n; i += 2) {
                String string = stringBuffer.substring(i, i + 2);
                stringBuffer2.append((char)Integer.parseInt(string, 16));
            }
            return stringBuffer2;
        }
        int n = stringBuffer.length();
        StringBuffer stringBuffer3 = new StringBuffer(n / 4);
        for (int i = 0; i < n; i += 4) {
            String string = stringBuffer.substring(i, i + 4);
            stringBuffer3.append((char)Integer.parseInt(string, 16));
        }
        return stringBuffer3;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }

    public String getDecryptedLiteralString(SecurityManager securityManager) {
        if (securityManager != null && this.reference != null) {
            byte[] byArray = securityManager.getDecryptionKey();
            byte[] byArray2 = new byte[this.stringData.length()];
            int n = byArray2.length;
            for (int i = 0; i < n; ++i) {
                byArray2[i] = (byte)this.stringData.charAt(i);
            }
            byArray2 = securityManager.decrypt(this.reference, byArray, byArray2);
            return new String(byArray2);
        }
        return this.getLiteralString();
    }
}

