/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlrpc.util;

import java.util.ArrayList;
import java.util.List;

public class ThreadPool {
    private final ThreadGroup threadGroup;
    private final int maxSize;
    private final List waitingThreads = new ArrayList();
    private final List runningThreads = new ArrayList();
    private final List waitingTasks = new ArrayList();
    private int num;

    public ThreadPool(int pMaxSize, String pName) {
        this.maxSize = pMaxSize;
        this.threadGroup = new ThreadGroup(pName);
    }

    synchronized void discard(MyThread pThread) {
        pThread.shutdown();
        if (!this.runningThreads.remove(pThread)) {
            throw new IllegalStateException("The list of running threads didn't contain the thread " + pThread.getName());
        }
    }

    synchronized void repool(MyThread pThread) {
        if (this.maxSize != 0 && this.runningThreads.size() + this.waitingThreads.size() > this.maxSize) {
            this.discard(pThread);
        } else if (this.waitingTasks.size() > 0) {
            pThread.setTask((Task)this.waitingTasks.remove(0));
        } else {
            pThread.setTask(null);
            if (!this.runningThreads.remove(pThread)) {
                throw new IllegalStateException("The list of running threads didn't contain the thread " + pThread.getName());
            }
            this.waitingThreads.add(pThread);
        }
    }

    public synchronized boolean startTask(Task pTask) {
        MyThread t;
        if (this.maxSize != 0 && this.runningThreads.size() > this.maxSize) {
            return false;
        }
        if (this.waitingThreads.size() > 0) {
            t = (MyThread)this.waitingThreads.remove(this.waitingThreads.size() - 1);
        } else {
            t = new MyThread();
            t.start();
        }
        this.runningThreads.add(t);
        t.setTask(pTask);
        return true;
    }

    public synchronized boolean addTask(Task pTask) {
        if (this.startTask(pTask)) {
            return true;
        }
        this.waitingTasks.add(pTask);
        return false;
    }

    public synchronized void shutdown() {
        MyThread t;
        int i;
        for (i = 0; i < this.waitingThreads.size(); ++i) {
            t = (MyThread)this.waitingThreads.get(i);
            t.shutdown();
        }
        for (i = 0; i < this.runningThreads.size(); ++i) {
            t = (MyThread)this.runningThreads.get(i);
            t.shutdown();
        }
    }

    public int getMaxThreads() {
        return this.maxSize;
    }

    public int getNumThreads() {
        return this.num;
    }

    private class MyThread
    extends Thread {
        private boolean shuttingDown;
        private int numTasks;
        private Task task;

        MyThread() {
            super(ThreadPool.this.threadGroup, ThreadPool.this.threadGroup.getName() + "-" + ThreadPool.this.num++);
            this.setDaemon(true);
        }

        synchronized void shutdown() {
            this.shuttingDown = true;
            this.notify();
        }

        synchronized boolean isShuttingDown() {
            return this.shuttingDown;
        }

        synchronized void waitForNotification() {
            if (this.getTask() != null) {
                return;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        synchronized int getNumTasks() {
            return this.numTasks;
        }

        synchronized Task getTask() {
            return this.task;
        }

        synchronized void setTask(Task pTask) {
            this.task = pTask;
            if (this.task != null) {
                this.notify();
            }
        }

        synchronized void runTask() {
            Throwable t;
            Task tsk = this.getTask();
            if (tsk == null) {
                return;
            }
            ++this.numTasks;
            try {
                tsk.run();
                t = null;
            }
            catch (Throwable th) {
                t = th;
            }
            if (t == null) {
                ThreadPool.this.repool(this);
            } else {
                ThreadPool.this.discard(this);
            }
        }

        public void run() {
            while (!this.isShuttingDown()) {
                if (this.getTask() == null) {
                    this.waitForNotification();
                    continue;
                }
                this.runTask();
            }
        }
    }

    public static interface Task {
        public void run() throws Throwable;
    }
}

