<?php
//
// Created on: <06-Oct-2002 16:01:10 amos>
//
// SOFTWARE NAME: eZ Publish
// SOFTWARE RELEASE: 4.1.3
// BUILD VERSION: 23650
// COPYRIGHT NOTICE: Copyright (C) 1999-2009 eZ Systems AS
// SOFTWARE LICENSE: GNU General Public License v2.0
// NOTICE: >
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of version 2.0  of the GNU General
//   Public License as published by the Free Software Foundation.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//   GNU General Public License for more details.
//
//   You should have received a copy of version 2.0 of the GNU General
//   Public License along with this program; if not, write to the Free
//   Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
//   MA 02110-1301, USA.
//
//

/*! \file
*/

$FunctionList = array();

$FunctionList['object'] = array( 'name' => 'object',
                                 'operation_types' => array( 'read' ),
                                 'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                         'method' => 'fetchContentObject' ),
                                 'parameter_type' => 'standard',
                                 'parameters' => array( array( 'name' => 'object_id',
                                                               'type' => 'integer',
                                                               'default' => false,
                                                               'required' => false ),
                                                        array( 'name' => 'remote_id',
                                                               'type' => 'integer',
                                                               'default' => false,
                                                               'required' => false ) ) );
$FunctionList['version'] = array( 'name' => 'version',
                                  'operation_types' => array( 'read' ),
                                  'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                          'method' => 'fetchContentVersion' ),
                                  'parameter_type' => 'standard',
                                  'parameters' => array( array( 'name' => 'object_id',
                                                                'type' => 'integer',
                                                                'required' => true ),
                                                         array( 'name' => 'version_id',
                                                                'type' => 'integer',
                                                                'default' => false,
                                                                'required' => true ) ) );
$FunctionList['node'] = array( 'name' => 'node',
                               'operation_types' => array( 'read' ),
                               'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                       'method' => 'fetchContentNode' ),
                               'parameter_type' => 'standard',
                               'parameters' => array( array( 'name' => 'node_id',
                                                             'type' => 'integer',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'node_path',
                                                             'type' => 'string',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'language_code',
                                                             'type' => 'string',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'remote_id',
                                                             'type' => 'integer',
                                                             'default' => false,
                                                             'required' => false )  ) );
$FunctionList['locale_list'] = array( 'name' => 'locale_list',
                                      'operation_types' => array( 'read' ),
                                      'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                              'method' => 'fetchLocaleList' ),
                                      'parameter_type' => 'standard',
                                      'parameters' => array( array( 'name' => 'with_variations',
                                                                    'type' => 'boolean',
                                                                    'required' => false,
                                                                    'default' => true ) ) );
$FunctionList['locale'] = array( 'name' => 'locale',
                                      'operation_types' => array( 'read' ),
                                      'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                              'method' => 'fetchLocale' ),
                                      'parameter_type' => 'standard',
                                      'parameters' => array( array( 'name' => 'locale_code',
                                                                    'type' => 'string',
                                                                    'required' => false,
                                                                    'default' => false ) ) );

$FunctionList['prioritized_languages'] = array( 'name' => 'prioritized_languages',
                                                'operation_types' => array( 'read' ),
                                                'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                        'method' => 'fetchPrioritizedLanguages' ),
                                                'parameter_type' => 'standard',
                                                'parameters' => array( ) );
$FunctionList['prioritized_language_codes'] = array( 'name' => 'prioritized_language_codes',
                                                     'operation_types' => array( 'read' ),
                                                     'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                             'method' => 'fetchPrioritizedLanguageCodes' ),
                                                     'parameter_type' => 'standard',
                                                     'parameters' => array( ) );
$FunctionList['translation_list'] = array( 'name' => 'translation_list',
                                           'operation_types' => array( 'read' ),
                                           'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                   'method' => 'fetchTranslationList' ),
                                           'parameter_type' => 'standard',
                                           'parameters' => array( ) );
$FunctionList['non_translation_list'] = array( 'name' => 'object',
                                               'operation_types' => array( 'read' ),
                                               'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                       'method' => 'fetchNonTranslationList' ),
                                               'parameter_type' => 'standard',
                                               'parameters' => array( array( 'name' => 'object_id',
                                                                             'type' => 'integer',
                                                                             'required' => true ),
                                                                      array( 'name' => 'version',
                                                                             'type' => 'integer',
                                                                             'required' => true ) ) );
$FunctionList['class'] = array( 'name' => 'object',
                                'operation_types' => array( 'read' ),
                                'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                        'method' => 'fetchClass' ),
                                'parameter_type' => 'standard',
                                'parameters' => array( array( 'name' => 'class_id',
                                                              'type' => 'integer,string',
                                                              'required' => true ) ) );
$FunctionList['class_attribute_list'] = array( 'name' => 'object',
                                               'operation_types' => array( 'read' ),
                                               'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                       'method' => 'fetchClassAttributeList' ),
                                               'parameter_type' => 'standard',
                                               'parameters' => array( array( 'name' => 'class_id',
                                                                             'type' => 'integer',
                                                                             'required' => true ),
                                                                      array( 'name' => 'version_id',
                                                                             'type' => 'integer',
                                                                             'required' => false,
                                                                             'default' => 0 ) ) );
$FunctionList['class_attribute'] = array( 'name' => 'object',
                                          'operation_types' => array( 'read' ),
                                          'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                  'method' => 'fetchClassAttribute' ),
                                          'parameter_type' => 'standard',
                                          'parameters' => array( array( 'name' => 'attribute_id',
                                                                        'type' => 'integer',
                                                                        'required' => true ),
                                                                 array( 'name' => 'version_id',
                                                                        'type' => 'integer',
                                                                        'required' => false,
                                                                        'default' => 0 ) ) );
$FunctionList['calendar'] = array( 'name' => 'calendar',
                                   'operation_types' => array( 'read' ),
                                   'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                           'method' => 'calendar' ),
                                   'parameter_type' => 'standard',
                                   'parameters' => array( array( 'name' => 'parent_node_id',
                                                                 'type' => 'integer',
                                                                 'required' => true ),
                                                          array( 'name' => 'offset',
                                                                 'type' => 'integer',
                                                                 'required' => false,
                                                                 'default' => false ),
                                                          array( 'name' => 'limit',
                                                                 'type' => 'integer',
                                                                 'required' => false,
                                                                 'default' => false ),
                                                          array( 'name' => 'depth',
                                                                 'type' => 'integer',
                                                                 'required' => false,
                                                                 'default' => 1 ),
                                                          array( 'name' => 'depth_operator',
                                                                 'type' => 'string',
                                                                 'required' => false,
                                                                 'default' => 'le' ),
                                                          array( 'name' => 'class_id',
                                                                 'type' => 'integer',
                                                                 'required' => false,
                                                                 'default' => false ),
                                                          array( 'name' => 'attribute_filter',
                                                                 'type' => 'mixed',
                                                                 'required' => false,
                                                                 'default' => false ),
                                                          array( 'name' => 'extended_attribute_filter',
                                                                 'type' => 'mixed',
                                                                 'required' => false,
                                                                 'default' => false ),
                                                          array( 'name' => 'class_filter_type',
                                                                 'type' => 'string',
                                                                 'required' => false,
                                                                 'default' => false ),
                                                          array( 'name' => 'class_filter_array',
                                                                 'type' => 'array',
                                                                 'required' => false,
                                                                 'default' => false ),
                                                          array( 'name' => 'group_by',
                                                                 'type' => 'array',
                                                                 'required' => false,
                                                                 'default' => false ),
                                                          array( 'name' => 'main_node_only',
                                                                 'type' => 'bool',
                                                                 'required' => false,
                                                                 'default' => false ),
                                                          array( 'name' => 'ignore_visibility',
                                                                 'type' => 'bool',
                                                                 'required' => false,
                                                                 'default' => false ),
                                                          array( 'name' => 'limitation',
                                                                 'type' => 'array',
                                                                 'required' => false,
                                                                 'default' => null ) ) );

$FunctionList['list'] = array( 'name' => 'list',
                               'operation_types' => array( 'read' ),
                               'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                       'method' => 'fetchObjectTree' ),
                               'parameter_type' => 'standard',
                               'parameters' => array( array( 'name' => 'parent_node_id',
                                                             'type' => 'integer',
                                                             'required' => true ),
                                                      array( 'name' => 'sort_by',
                                                             'type' => 'array',
                                                             'required' => false,
                                                             'default' => array() ),
                                                      array( 'name' => 'only_translated',
                                                             'type' => 'bool',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'language',
                                                             'type' => 'string',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'offset',
                                                             'type' => 'integer',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'limit',
                                                             'type' => 'integer',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'depth',
                                                             'type' => 'integer',
                                                             'required' => false,
                                                             'default' => 1 ),
                                                      array( 'name' => 'depth_operator',
                                                             'type' => 'string',
                                                             'required' => false,
                                                             'default' => 'le' ),
                                                      array( 'name' => 'class_id',
                                                             'type' => 'integer',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'attribute_filter',
                                                             'type' => 'mixed',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'extended_attribute_filter',
                                                             'type' => 'mixed',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'class_filter_type',
                                                             'type' => 'string',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'class_filter_array',
                                                             'type' => 'array',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'group_by',
                                                             'type' => 'array',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'main_node_only',
                                                             'type' => 'bool',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'ignore_visibility',
                                                             'type' => 'bool',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'limitation',
                                                             'type' => 'array',
                                                             'required' => false,
                                                             'default' => null ),
                                                      array( 'name' => 'as_object',
                                                             'type' => 'bool',
                                                             'required' => false,
                                                             'default' => null ),
                                                      array( 'name' => 'objectname_filter',
                                                             'type' => 'string',
                                                             'required' => false,
                                                             'default' => null ),
                                                      array( 'name' => 'load_data_map',
                                                             'type' => 'bool',
                                                             'required' => false,
                                                             'default' => null ) ) );
$FunctionList['list_count'] = array( 'name' => 'list_count',
                                     'operation_types' => array( 'read' ),
                                     'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                             'method' => 'fetchObjectTreeCount' ),
                                     'parameter_type' => 'standard',
                                     'parameters' => array( array( 'name' => 'parent_node_id',
                                                                   'type' => 'integer',
                                                                   'required' => true ),
                                                            array( 'name' => 'only_translated',
                                                                   'type' => 'bool',
                                                                   'required' => false,
                                                                   'default' => false ),
                                                            array( 'name' => 'language',
                                                                   'type' => 'string',
                                                                   'required' => false,
                                                                   'default' => false ),
                                                            array( 'name' => 'class_filter_type',
                                                                   'type' => 'string',
                                                                   'required' => false,
                                                                   'default' => false ),
                                                            array( 'name' => 'class_filter_array',
                                                                   'type' => 'array',
                                                                   'required' => false,
                                                                   'default' => false ),
                                                            array( 'name' => 'attribute_filter',
                                                                   'type' => 'mixed',
                                                                   'required' => false,
                                                                   'default' => false ),
                                                            array( 'name' => 'depth',
                                                                   'type' => 'string',
                                                                   'required' => false,
                                                                   'default' => 1 ),
                                                            array( 'name' => 'depth_operator',
                                                                   'type' => 'string',
                                                                   'required' => false,
                                                                   'default' => 'le' ),
                                                            array( 'name' => 'ignore_visibility',
                                                                   'type' => 'bool',
                                                                   'required' => false,
                                                                   'default' => false ),
                                                            array( 'name' => 'limitation',
                                                                   'type' => 'array',
                                                                   'required' => false,
                                                                   'default' => null ),
                                                            array( 'name' => 'main_node_only',
                                                                   'type' => 'bool',
                                                                   'required' => false,
                                                                   'default' => false ),
                                                            array( 'name' => 'extended_attribute_filter',
                                                                   'type' => 'mixed',
                                                                   'required' => false,
                                                                   'default' => false ),
                                                            array( 'name' => 'objectname_filter',
                                                                   'type' => 'string',
                                                                   'required' => false,
                                                                   'default' => null ) ) );
$FunctionList['tree'] = array( 'name' => 'tree',
                               'operation_types' => array( 'read' ),
                               'call_method' => array(
                                                       'class' => 'eZContentFunctionCollection',
                                                       'method' => 'fetchObjectTree' ),
                               'parameter_type' => 'standard',
                               'parameters' => array( array( 'name' => 'parent_node_id',
                                                             'type' => 'integer',
                                                             'required' => true ),
                                                      array( 'name' => 'sort_by',
                                                             'type' => 'array',
                                                             'required' => false,
                                                             'default' => array() ),
                                                      array( 'name' => 'only_translated',
                                                             'type' => 'bool',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'language',
                                                             'type' => 'string',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'offset',
                                                             'type' => 'integer',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'limit',
                                                             'type' => 'integer',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'depth',
                                                             'type' => 'integer',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'depth_operator',
                                                             'type' => 'integer',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'class_id',
                                                             'type' => 'integer',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'attribute_filter',
                                                             'type' => 'mixed',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'extended_attribute_filter',
                                                             'type' => 'mixed',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'class_filter_type',
                                                             'type' => 'string',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'class_filter_array',
                                                             'type' => 'array',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'group_by',
                                                             'type' => 'array',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'main_node_only',
                                                             'type' => 'bool',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'ignore_visibility',
                                                             'type' => 'bool',
                                                             'required' => false,
                                                             'default' => false ),
                                                      array( 'name' => 'limitation',
                                                             'type' => 'array',
                                                             'required' => false,
                                                             'default' => null ),
                                                      array( 'name' => 'as_object',
                                                             'type' => 'bool',
                                                             'required' => false,
                                                             'default' => null ),
                                                      array( 'name' => 'objectname_filter',
                                                             'type' => 'string',
                                                             'required' => false,
                                                             'default' => null ),
                                                      array( 'name' => 'load_data_map',
                                                             'type' => 'bool',
                                                             'required' => false,
                                                             'default' => null ) ) );

$FunctionList['tree_count'] = array( 'name' => 'tree_count',
                                     'operation_types' => array( 'read' ),
                                     'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                             'method' => 'fetchObjectTreeCount' ),
                                     'parameter_type' => 'standard',
                                     'parameters' => array( array( 'name' => 'parent_node_id',
                                                                   'type' => 'integer',
                                                                   'required' => true ),
                                                            array( 'name' => 'only_translated',
                                                                   'type' => 'bool',
                                                                   'required' => false,
                                                                   'default' => false ),
                                                            array( 'name' => 'language',
                                                                   'type' => 'string',
                                                                   'required' => false,
                                                                   'default' => false ),
                                                            array( 'name' => 'class_filter_type',
                                                                   'type' => 'string',
                                                                   'required' => false,
                                                                   'default' => false ),
                                                            array( 'name' => 'class_filter_array',
                                                                   'type' => 'array',
                                                                   'required' => false,
                                                                   'default' => false ),
                                                            array( 'name' => 'attribute_filter',
                                                                   'type' => 'mixed',
                                                                   'required' => false,
                                                                   'default' => false ),
                                                            array( 'name' => 'depth',
                                                                   'type' => 'string',
                                                                   'required' => false,
                                                                   'default' => false ),
                                                            array( 'name' => 'depth_operator',
                                                                   'type' => 'string',
                                                                   'required' => false,
                                                                   'default' => false ),
                                                            array( 'name' => 'ignore_visibility',
                                                                   'type' => 'bool',
                                                                   'required' => false,
                                                                   'default' => false ),
                                                            array( 'name' => 'limitation',
                                                                   'type' => 'array',
                                                                   'required' => false,
                                                                   'default' => null ),
                                                            array( 'name' => 'main_node_only',
                                                                   'type' => 'bool',
                                                                   'required' => false,
                                                                   'default' => false ),
                                                            array( 'name' => 'extended_attribute_filter',
                                                                   'type' => 'mixed',
                                                                   'required' => false,
                                                                   'default' => false ),
                                                            array( 'name' => 'objectname_filter',
                                                                   'type' => 'string',
                                                                   'required' => false,
                                                                   'default' => null ) ) );

$FunctionList['search'] = array( 'name' => 'search',
                                 'operation_types' => array( 'read' ),
                                 'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                         'method' => 'fetchContentSearch' ),
                                 'parameter_type' => 'standard',
                                 'parameters' => array( array( 'name' => 'text',
                                                               'type' => 'string',
                                                               'required' => true ),
                                                        array( 'name' => 'subtree_array',
                                                               'type' => 'array',
                                                               'default' => false,
                                                               'required' => false ),
                                                        array( 'name' => 'offset',
                                                               'type' => 'integer',
                                                               'required' => false,
                                                               'default' => false ),
                                                        array( 'name' => 'limit',
                                                               'type' => 'integer',
                                                               'required' => false,
                                                               'default' => false ),
                                                        array( 'name' => 'publish_timestamp',
                                                               'type' => 'mixed',
                                                               'required' => false,
                                                               'default' => false ),
                                                        array( 'name' => 'publish_date',
                                                               'type' => 'integer',
                                                               'required' => false,
                                                               'default' => false ),
                                                        array( 'name' => 'section_id',
                                                               'type' => 'integer',
                                                               'required' => false,
                                                               'default' => false ),
                                                        array( 'name' => 'class_id',
                                                               'type' => 'integer',
                                                               'required' => false,
                                                               'default' => false ),
                                                        array( 'name' => 'class_attribute_id',
                                                               'type' => 'integer',
                                                               'required' => false,
                                                               'default' => false ),
                                                        array( 'name' => 'ignore_visibility',
                                                               'type' => 'bool',
                                                               'required' => false,
                                                               'default' => false ),
                                                        array( 'name' => 'limitation',
                                                               'type' => 'array',
                                                               'required' => false,
                                                               'default' => null ),
                                                        array( 'name' => 'sort_by',
                                                               'type' => 'mixed',
                                                               'required' => false,
                                                               'default' => false ) ) );

$FunctionList['trash_count'] = array( 'name' => 'trash_count',
                                      'operation_types' => array( 'read' ),
                                      'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                              'method' => 'fetchTrashObjectCount' ),
                                      'parameter_type' => 'standard',
                                      'parameters' => array( array( 'name' => 'objectname_filter',
                                                                    'type' => 'string',
                                                                    'required' => false,
                                                                    'default' => null ),
                                                            array( 'name' => 'attribute_filter',
                                                                    'type' => 'mixed',
                                                                    'required' => false,
                                                                    'default' => false ) ) );

$FunctionList['trash_object_list'] = array( 'name' => 'trash_object_list',
                                            'operation_types' => array( 'read' ),
                                            'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                    'method' => 'fetchTrashObjectList' ),
                                            'parameter_type' => 'standard',
                                            'parameters' => array( array( 'name' => 'offset',
                                                                          'type' => 'integer',
                                                                          'required' => false,
                                                                          'default' => false ),
                                                                   array( 'name' => 'limit',
                                                                          'type' => 'integer',
                                                                          'required' => false,
                                                                          'default' => false ),
                                                                   array( 'name' => 'objectname_filter',
                                                                          'type' => 'string',
                                                                          'required' => false,
                                                                          'default' => null ),
                                                                   array( 'name' => 'attribute_filter',
                                                                          'type' => 'mixed',
                                                                          'required' => false,
                                                                          'default' => false ),
                                                                   array( 'name' => 'sort_by',
                                                                          'type' => 'mixed',
                                                                          'required' => false,
                                                                          'default' => false ),
                                                                   array( 'name' => 'as_object',
                                                                          'type' => 'bool',
                                                                          'required' => false,
                                                                          'default' => true ) ) );

$FunctionList['draft_count'] = array( 'name' => 'draft_count',
                                      'operation_types' => array( 'read' ),
                                      'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                              'method' => 'fetchDraftVersionCount' ),
                                      'parameter_type' => 'standard',
                                      'parameters' => array(  ) );

$FunctionList['draft_version_list'] = array( 'name' => 'draft_version_list',
                                             'operation_types' => array( 'read' ),
                                             'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                     'method' => 'fetchDraftVersionList' ),
                                             'parameter_type' => 'standard',
                                             'parameters' => array( array( 'name' => 'offset',
                                                                           'type' => 'integer',
                                                                           'required' => false,
                                                                           'default' => false ),
                                                                    array( 'name' => 'limit',
                                                                           'type' => 'integer',
                                                                           'required' => false,
                                                                           'default' => false ) ) );

$FunctionList['pending_count'] = array( 'name' => 'pending_count',
                                        'operation_types' => array( 'read' ),
                                        'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                'method' => 'fetchPendingCount' ),
                                        'parameter_type' => 'standard',
                                        'parameters' => array(  ) );

$FunctionList['pending_list'] = array( 'name' => 'pending_list',
                                       'operation_types' => array( 'read' ),
                                       'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                               'method' => 'fetchPendingList' ),
                                       'parameter_type' => 'standard',
                                       'parameters' => array( array( 'name' => 'offset',
                                                                     'type' => 'integer',
                                                                     'required' => false,
                                                                     'default' => false ),
                                                              array( 'name' => 'limit',
                                                                     'type' => 'integer',
                                                                     'required' => false,
                                                                     'default' => false ) ) );

$FunctionList['version_count'] = array( 'name' => 'version_count',
                                      'operation_types' => array( 'read' ),
                                      'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                              'method' => 'fetchVersionCount' ),
                                      'parameter_type' => 'standard',
                                      'parameters' => array( array( 'name' => 'contentobject',
                                                                           'type' => 'object',
                                                                           'required' => true) ) );

$FunctionList['version_list'] = array( 'name' => 'version_list',
                                             'operation_types' => array( 'read' ),
                                             'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                     'method' => 'fetchVersionList' ),
                                             'parameter_type' => 'standard',
                                             'parameters' => array( array( 'name' => 'contentobject',
                                                                           'type' => 'object',
                                                                           'required' => true),
                                                                    array( 'name' => 'offset',
                                                                           'type' => 'integer',
                                                                           'required' => false,
                                                                           'default' => false ),
                                                                    array( 'name' => 'limit',
                                                                           'type' => 'integer',
                                                                           'required' => false,
                                                                           'default' => false ),
                                                                    array( 'name' => 'sorts',
                                                                           'type' => 'array',
                                                                           'required' => false,
                                                                           'default' => null ) ) );



$FunctionList['can_instantiate_class_list'] = array( 'name' => 'can_instantiate_class_list',
                                                     'operation_types' => array( 'read' ),
                                                     'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                             'method' => 'canInstantiateClassList' ),
                                                     'parameter_type' => 'standard',
                                                     'parameters' => array( array( 'name' => 'group_id',
                                                                                   'type' => 'array',
                                                                                   'required' => false,
                                                                                   'default' => 0 ),
                                                                            array( 'name' => 'parent_node',
                                                                                   'type' => 'object',
                                                                                   'required' => false,
                                                                                   'default' => 0 ),
                                                                            array( 'name' => 'filter_type',
                                                                                   'type' => 'string',
                                                                                   'required' => false,
                                                                                   'default' => 'include' ),
                                                                            array( 'name' => 'fetch_id',
                                                                                   'type' => 'string',
                                                                                   'required' => false,
                                                                                   'default' => false ),
                                                                            array( 'name' => 'as_object',
                                                                                   'type' => 'bool',
                                                                                   'required' => false,
                                                                                   'default' => true ) ) );

$FunctionList['can_instantiate_classes'] = array( 'name' => 'can_instantiate_classes',
                                                  'operation_types' => array( 'read' ),
                                                  'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                          'method' => 'canInstantiateClasses' ),
                                                  'parameter_type' => 'standard',
                                                  'parameters' => array( array( 'name' => 'parent_node',
                                                                                'type' => 'object',
                                                                                'required' => false,
                                                                                'default' => 0 ) ) );
$FunctionList['contentobject_attributes'] = array( 'name' => 'contentobject_attributes',
                                                   'operation_types' => array( 'read' ),
                                                   'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                           'method' => 'contentobjectAttributes' ),
                                                   'parameter_type' => 'standard',
                                                   'parameters' => array( array( 'name' => 'version',
                                                                                 'type' => 'object',
                                                                                 'required' => false,
                                                                                 'default' => 0 ),
                                                                          array( 'name' => 'language_code',
                                                                                 'type' => 'string',
                                                                                 'required' => false,
                                                                                 'default' => '' ) ) );

$FunctionList['bookmarks'] = array( 'name' => 'bookmarks',
                                    'operation_types' => array( 'read' ),
                                    'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                            'method' => 'fetchBookmarks' ),
                                    'parameter_type' => 'standard',
                                    'parameters' => array( array( 'name' => 'offset',
                                                                  'type' => 'integer',
                                                                  'required' => false,
                                                                  'default' => false ),
                                                           array( 'name' => 'limit',
                                                                  'type' => 'integer',
                                                                  'required' => false,
                                                                  'default' => false ) ) );

$FunctionList['recent'] = array( 'name' => 'recent',
                                 'operation_types' => array( 'read' ),
                                 'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                         'method' => 'fetchRecent' ),
                                 'parameter_type' => 'standard',
                                 'parameters' => array( ) );

$FunctionList['section_list'] = array( 'name' => 'section_list',
                                       'operation_types' => array( 'read' ),
                                       'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                               'method' => 'fetchSectionList' ),
                                       'parameter_type' => 'standard',
                                       'parameters' => array( ) );

$FunctionList['tipafriend_top_list'] = array( 'name' => 'tipafriend_top_list',
                                              'operation_types' => array( 'read' ),
                                              'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                      'method' => 'fetchTipafriendTopList' ),
                                              'parameter_type' => 'standard',
                                              'parameters' => array( array( 'name' => 'offset',
                                                                            'type' => 'integer',
                                                                            'required' => false,
                                                                            'default' => false ),
                                                                     array( 'name' => 'limit',
                                                                            'type' => 'integer',
                                                                            'required' => false,
                                                                            'default' => false ),
                                                                     array( 'name' => 'start_time',
                                                                            'type' => 'integer',
                                                                            'required' => false,
                                                                            'default' => false ),
                                                                     array( 'name' => 'end_time',
                                                                            'type' => 'integer',
                                                                            'required' => false,
                                                                            'default' => false ),
                                                                     array( 'name' => 'duration',
                                                                            'type' => 'integer',
                                                                            'required' => false,
                                                                            'default' => false ),
                                                                     array( 'name' => 'ascending',
                                                                            'type' => 'boolean',
                                                                            'required' => false,
                                                                            'default' => false ),
                                                                     array( 'name' => 'extended',
                                                                            'type' => 'boolean',
                                                                            'required' => false,
                                                                            'default' => false ) ) );

$FunctionList['view_top_list'] = array( 'name' => 'view_top_list',
                                        'operation_types' => array( 'read' ),
                                        'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                'method' => 'fetchMostViewedTopList' ),
                                        'parameter_type' => 'standard',
                                        'parameters' => array( array( 'name' => 'class_id',
                                                                      'type' => 'integer',
                                                                      'required' => false,
                                                                      'default' => false ),
                                                               array( 'name' => 'section_id',
                                                                      'type' => 'integer',
                                                                      'required' => false,
                                                                      'default' => false ),
                                                               array( 'name' => 'offset',
                                                                      'type' => 'integer',
                                                                      'required' => false,
                                                                      'default' => false ),
                                                               array( 'name' => 'limit',
                                                                      'type' => 'integer',
                                                                      'required' => false,
                                                                      'default' => false ) ) );

$FunctionList['collected_info_count'] = array( 'name' => 'collected_info_count',
                                               'operation_types' => array( 'read' ),
                                               'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                       'method' => 'fetchCollectedInfoCount' ),
                                               'parameter_type' => 'standard',
                                               'parameters' => array( array( 'name' => 'object_attribute_id',
                                                                             'type' => 'integer',
                                                                             'required' => false,
                                                                             'default' => false ),
                                                                      array( 'name' => 'object_id',
                                                                             'type' => 'integer',
                                                                             'required' => false,
                                                                             'default' => false ),
                                                                      array( 'name' => 'value',
                                                                             'type' => 'integer',
                                                                             'required' => false,
                                                                             'default' => false ),
                                                                      array( 'name' => 'creator_id',
                                                                             'type' => 'integer',
                                                                             'required' => false,
                                                                             'default' => false ),
                                                                      array( 'name' => 'user_identifier',
                                                                             'type' => 'string',
                                                                             'required' => false,
                                                                             'default' => false ) ) );

$FunctionList['collected_info_count_list'] = array( 'name' => 'collected_info_count_list',
                                               'operation_types' => array( 'read' ),
                                               'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                       'method' => 'fetchCollectedInfoCountList' ),
                                               'parameter_type' => 'standard',
                                               'parameters' => array( array( 'name' => 'object_attribute_id',
                                                                             'type' => 'integer',
                                                                             'required' => true,
                                                                             'default' => false ) ) );


$FunctionList['collected_info_collection'] = array( 'name' => 'collected_info_collection',
                                                    'operation_types' => array( 'read' ),
                                                    'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                            'method' => 'fetchCollectedInfoCollection' ),
                                                    'parameter_type' => 'standard',
                                                    'parameters' => array( array( 'name' => 'collection_id',
                                                                                  'type' => 'integer',
                                                                                  'required' => false,
                                                                                  'default' => false ),
                                                                           array( 'name' => 'contentobject_id',
                                                                                  'type' => 'integer',
                                                                                  'required' => false,
                                                                                  'default' => false ) ) );

$FunctionList['collected_info_list'] = array( 'name' => 'collected_info_list',
                                                    'operation_types' => array( 'read' ),
                                                    'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                            'method' => 'fetchCollectionsList' ),
                                                    'parameter_type' => 'standard',
                                                    'parameters' => array( array( 'name' => 'object_id',
                                                                                  'type' => 'integer',
                                                                                  'required' => false,
                                                                                  'default' => false ),
                                                                           array( 'name' => 'creator_id',
                                                                                  'type' => 'integer',
                                                                                  'required' => false,
                                                                                  'default' => false ),
                                                                           array( 'name' => 'user_identifier',
                                                                                  'type' => 'string',
                                                                                  'required' => false,
                                                                                  'default' => false ),
                                                                           array( 'name' => 'limit',
                                                                                  'type' => 'integer',
                                                                                  'required' => false,
                                                                                  'default' => false ),
                                                                           array( 'name' => 'offset',
                                                                                  'type' => 'integer',
                                                                                  'required' => false,
                                                                                  'default' => false ),
                                                                           array( 'name' => 'sort_by',
                                                                                  'type' => 'array',
                                                                                  'required' => false,
                                                                                  'default' => array() ) ) );

$FunctionList['object_by_attribute'] = array( 'name' => 'object_by_attribute',
                                              'operation_types' => array( 'read' ),
                                              'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                      'method' => 'fetchObjectByAttribute' ),
                                              'parameter_type' => 'standard',
                                              'parameters' => array( array( 'name' => 'identifier',
                                                                            'type' => 'string',
                                                                            'required' => true,
                                                                            'default' => false ) ) );

$FunctionList['object_count_by_user_id'] = array( 'name' => 'object_count_by_user_id',
                                                  'operation_types' => array( 'read' ),
                                                  'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                          'method' => 'fetchObjectCountByUserID' ),
                                              'parameter_type' => 'standard',
                                              'parameters' => array( array( 'name' => 'class_id',
                                                                            'type' => 'integer',
                                                                            'required' => true,
                                                                            'default' => false ),
                                                                     array( 'name' => 'user_id',
                                                                            'type' => 'integer',
                                                                            'required' => true,
                                                                            'default' => false ) ) );

$FunctionList['same_classattribute_node'] = array( 'name' => 'same_classattribute_node',
                                     'operation_types' => array( 'read' ),
                                     'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                             'method' => 'fetchSameClassAttributeNodeList' ),
                                     'parameter_type' => 'standard',
                                     'parameters' => array( array( 'name' => 'classattribute_id',
                                                                   'type' => 'integer',
                                                                   'required' => true ),
                                                            array( 'name' => 'value',
                                                                   'type' => 'mixed',
                                                                   'required' => true ),
                                                            array( 'name' => 'datatype',
                                                                   'type' => 'string',
                                                                   'required' => true ) ) );

$FunctionList['keyword'] = array( 'name' => 'keyword',
                                  'operation_types' => array( 'read' ),
                                  'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                          'method' => 'fetchKeyword' ),
                                  'parameter_type' => 'standard',
                                  'parameters' => array( array( 'name' => 'alphabet',
                                                                'type' => 'string',
                                                                'required' => true ),
                                                         array( 'name' => 'classid',
                                                                'type' => 'mixed',
                                                                'required' => false,
                                                                'default' => false ),
                                                         array( 'name' => 'offset',
                                                                'type' => 'integer',
                                                                'required' => false,
                                                                'default' => false ),
                                                         array( 'name' => 'limit',
                                                                'type' => 'integer',
                                                                'required' => false,
                                                                'default' => false ),
                                                         array( 'name' => 'owner',
                                                                'type' => 'integer',
                                                                'required' => false,
                                                                'default' => false ),
                                                         array( 'name' => 'sort_by',
                                                                'type' => 'array',
                                                                'required' => false,
                                                                'default' => array() ),
                                                         array( 'name' => 'parent_node_id',
                                                                'type' => 'integer',
                                                                'required' => false,
                                                                'default' => false ),
                                                        array( 'name' => 'include_duplicates',
                                                                'type' => 'bool',
                                                                'required' => false,
                                                                'default' => true ),
                                                         array( 'name' => 'strict_matching',
                                                                 'type' => 'bool',
                                                                 'required' => false,
                                                                 'default' => false ) ) );


$FunctionList['keyword_count'] = array( 'name' => 'keyword_count',
                                        'operation_types' => array( 'read' ),
                                        'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                'method' => 'fetchKeywordCount' ),
                                        'parameter_type' => 'standard',
                                        'parameters' => array( array( 'name' => 'alphabet',
                                                                      'type' => 'string',
                                                                      'required' => true ),
                                                               array( 'name' => 'classid',
                                                                      'type' => 'mixed',
                                                                      'required' => false,
                                                                      'default' => false ),
                                                               array( 'name' => 'owner',
                                                                      'type' => 'integer',
                                                                      'required' => false,
                                                                      'default' => false ),
                                                               array( 'name' => 'parent_node_id',
                                                                      'type' => 'integer',
                                                                      'required' => false,
                                                                      'default' => false ),
                                                               array( 'name' => 'include_duplicates',
                                                                      'type' => 'bool',
                                                                      'required' => false,
                                                                      'default' => true ),
                                                               array( 'name' => 'strict_matching',
                                                                      'type' => 'bool',
                                                                      'required' => false,
                                                                      'default' => false ) ) );

$FunctionList['access'] = array( 'name' => 'access',
                                 'operation_types' => array( 'read' ),
                                 'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                         'method' => 'checkAccess' ),
                                 'parameter_type' => 'standard',
                                 'parameters' => array( array( 'name' => 'access',
                                                               'type' => 'string',
                                                               'required' => true ),
                                                        array( 'name' => 'contentobject',
                                                               'type' => 'object', // eZContentObject or eZContentObjectTreeNode
                                                               'required' => true ),
                                                        array( 'name' => 'contentclass_id',
                                                               'type' => 'integer',
                                                               'required' => false,
                                                               'default' => false ),
                                                        array( 'name' => 'parent_contentclass_id',
                                                               'type' => 'integer',
                                                               'required' => false,
                                                               'default' => false ),
                                                        array( 'name' => 'language',
                                                               'type' => 'string',
                                                               'required' => false,
                                                               'default' => false ) ) );

// Fetches all navigation parts as an array
$FunctionList['navigation_parts'] = array( 'name' => 'navigation_parts',
                                           'operation_types' => array( 'read' ),
                                           'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                   'method' => 'fetchNavigationParts' ),
                                           'parameter_type' => 'standard',
                                           'parameters' => array() );

// Fetches one navigation part by identifier
$FunctionList['navigation_part'] = array( 'name' => 'navigation_part',
                                          'operation_types' => array( 'read' ),
                                          'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                  'method' => 'fetchNavigationPart' ),
                                          'parameter_type' => 'standard',
                                          'parameters' => array( array( 'name' => 'identifier',
                                                                        'type' => 'string',
                                                                        'required' => true ) ) );

// Fetches related objects array
$FunctionList['related_objects'] = array( 'name' => 'object',
                                 'operation_types' => array( 'read' ),
                                 'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                         'method' => 'fetchRelatedObjects' ),
                                 'parameter_type' => 'standard',
                                 'parameters' => array( array( 'name' => 'object_id',
                                                               'type' => 'integer',
                                                               'required' => true ),
                                                        array( 'name' => 'attribute_identifier',
                                                               'type' => 'string',
                                                               'required' => false,
                                                               'default' => '0' ),
                                                        array( 'name' => 'all_relations',
                                                               'type' => 'boolean',
                                                               'required' => false,
                                                               'default' => false ),
                                                        array( 'name' => 'group_by_attribute',
                                                               'type' => 'boolean',
                                                               'required' => false,
                                                               'default' => false ),
                                                        array( 'name' => 'sort_by',
                                                               'type' => 'array',
                                                               'required' => false,
                                                               'default' => array() ),
                                                        array( 'name' => 'limit',
                                                               'type' => 'integer',
                                                               'required' => false,
                                                               'default' => false ),
                                                        array( 'name' => 'offset',
                                                               'type' => 'integer',
                                                               'required' => false,
                                                               'default' => false ),
                                                        array( 'name' => 'as_object',
                                                               'type' => 'boolean',
                                                               'required' => false,
                                                               'default' => true ),
                                                        array( 'name' => 'load_data_map',
                                                               'type' => 'boolean',
                                                               'required' => false,
                                                               'default' => false ),
                                                        array( 'name' => 'ignore_visibility',
                                                               'type' => 'boolean',
                                                               'required' => false,
                                                               'default' => null ) ) );

$FunctionList['related_objects_count'] = array( 'name' => 'object',
                                 'operation_types' => array( 'read' ),
                                 'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                         'method' => 'fetchRelatedObjectsCount' ),
                                 'parameter_type' => 'standard',
                                 'parameters' => array( array( 'name' => 'object_id',
                                                               'type' => 'integer',
                                                               'required' => true ),
                                                        array( 'name' => 'attribute_identifier',
                                                               'type' => 'string',
                                                               'required' => false,
                                                               'default' => '0' ),
                                                        array( 'name' => 'all_relations',
                                                               'type' => 'boolean',
                                                               'required' => false,
                                                               'default' => false ) ) );
// Fetches reverse related objects array
$FunctionList['reverse_related_objects'] = array( 'name' => 'object',
                                 'operation_types' => array( 'read' ),
                                 'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                         'method' => 'fetchReverseRelatedObjects' ),
                                 'parameter_type' => 'standard',
                                 'parameters' => array( array( 'name' => 'object_id',
                                                               'type' => 'integer',
                                                               'required' => true ),
                                                        array( 'name' => 'attribute_identifier',
                                                               'type' => 'string',
                                                               'required' => false ),
                                                        array( 'name' => 'all_relations',
                                                               'type' => 'boolean',
                                                               'required' => false,
                                                               'default' => false ),
                                                        array( 'name' => 'group_by_attribute',
                                                               'type' => 'boolean',
                                                               'required' => false,
                                                               'default' => false ),
                                                        array( 'name' => 'sort_by',
                                                               'type' => 'array',
                                                               'required' => false,
                                                               'default' => array() ),
                                                        array( 'name' => 'ignore_visibility',
                                                               'type' => 'boolean',
                                                               'required' => false,
                                                               'default' => null ),
                                                        array( 'name' => 'limit',
                                                               'type' => 'integer',
                                                               'required' => false,
                                                               'default' => false ),
                                                        array( 'name' => 'offset',
                                                               'type' => 'integer',
                                                               'required' => false,
                                                               'default' => false ),
                                                       array( 'name' => 'as_object',
                                                               'type' => 'boolean',
                                                               'required' => false,
                                                               'default' => true ),
                                                        array( 'name' => 'load_data_map',
                                                               'type' => 'boolean',
                                                               'required' => false,
                                                               'default' => false ) ) );

$FunctionList['reverse_related_objects_count'] = array( 'name' => 'object',
                                 'operation_types' => array( 'read' ),
                                 'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                         'method' => 'fetchReverseRelatedObjectsCount' ),
                                 'parameter_type' => 'standard',
                                 'parameters' => array( array( 'name' => 'object_id',
                                                               'type' => 'integer',
                                                               'required' => true ),
                                                        array( 'name' => 'attribute_identifier',
                                                               'type' => 'string',
                                                               'required' => false ),
                                                        array( 'name' => 'all_relations',
                                                               'type' => 'boolean',
                                                               'required' => false,
                                                               'default' => false ),
                                                        array( 'name' => 'ignore_visibility',
                                                               'type' => 'boolean',
                                                               'required' => false,
                                                               'default' => null ) ) );

$FunctionList['available_sort_fields'] = array( 'name' => 'available_sort_fields',
                                                'operation_types' => array( 'read' ),
                                                'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                        'method' => 'fetchAvailableSortFieldList' ),
                                                'parameter_type' => 'standard',
                                                'parameters' => array() );

$FunctionList['country_list'] = array( 'name' => 'country',
                                       'operation_types' => array( 'read' ),
                                       'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                               'method' => 'fetchCountryList' ),
                                       'parameter_type' => 'standard',
                                       'parameters' => array( array( 'name' => 'filter',
                                                                     'type' => 'string',
                                                                     'required' => false ),
                                                              array( 'name' => 'value',
                                                                     'type' => 'string',
                                                                     'required' => false ) ) );

$FunctionList['related_objects_ids'] = array( 'name' => 'object',
                                 'operation_types' => array( 'read' ),
                                 'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                         'method' => 'fetchRelatedObjectsID' ),
                                 'parameter_type' => 'standard',
                                 'parameters' => array( array( 'name' => 'object_id',
                                                               'type' => 'integer',
                                                               'required' => true ),
                                                        array( 'name' => 'attribute_identifier',
                                                               'type' => 'string',
                                                               'required' => false,
                                                               'default' => '0' ),
                                                        array( 'name' => 'all_relations',
                                                               'type' => 'array',
                                                               'required' => false,
                                                               'default' => false ) ) );

$FunctionList['reverse_related_objects_ids'] = array( 'name' => 'object',
                                 'operation_types' => array( 'read' ),
                                 'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                         'method' => 'fetchReverseRelatedObjectsID' ),
                                 'parameter_type' => 'standard',
                                 'parameters' => array( array( 'name' => 'object_id',
                                                               'type' => 'integer',
                                                               'required' => true ),
                                                        array( 'name' => 'attribute_identifier',
                                                               'type' => 'string',
                                                               'required' => false,
                                                               'default' => '0' ),
                                                        array( 'name' => 'all_relations',
                                                               'type' => 'array',
                                                               'required' => false,
                                                               'default' => false ) ) );

$FunctionList['content_tree_menu_expiry'] = array( 'name' => 'content_tree_menu_expiry',
                                                   'operation_types' => array( 'read' ),
                                                   'call_method' => array( 'class' => 'eZContentFunctionCollection',
                                                                           'method' => 'fetchContentTreeMenuExpiry' ),
                                                   'parameter_type' => 'standard',
                                                   'parameters' => array() );

?>
