/*
 * Decompiled with CFR 0.152.
 */
package org.h2.util;

import java.sql.SQLException;
import java.util.Comparator;
import org.h2.engine.Constants;
import org.h2.message.Message;
import org.h2.util.CacheHead;
import org.h2.util.CacheObject;
import org.h2.util.CacheWriter;
import org.h2.util.ObjectArray;

public class Cache {
    private int len;
    private int maxSize;
    private CacheObject[] values;
    private int mask;
    private CacheWriter writer;
    private int size;
    private CacheObject head = new CacheHead();

    public Cache(CacheWriter writer, int maxSize) {
        this.writer = writer;
        this.len = maxSize / 2;
        this.mask = this.len - 1;
        this.maxSize = maxSize;
        this.clear();
    }

    public void put(CacheObject rec) throws SQLException {
        if (Constants.CHECK) {
            for (int i = 0; i < rec.getBlockCount(); ++i) {
                CacheObject old = this.getNoMoveToFront(rec.getPos() + i);
                if (old == null) continue;
                throw Message.internal("try to add a record twice");
            }
        }
        int index = rec.getPos() & this.mask;
        rec.chained = this.values[index];
        this.values[index] = rec;
        ++this.size;
        this.addToFront(rec);
        this.removeOld();
    }

    private void removeOld() throws SQLException {
        if (this.size <= this.maxSize + 1000) {
            return;
        }
        int i = 0;
        ObjectArray changed = new ObjectArray();
        while (this.size > this.maxSize) {
            CacheObject last = this.head.next;
            if (i++ >= this.size) break;
            if (Constants.CHECK && last == this.head) {
                throw Message.internal("try to remove head");
            }
            if (!last.canRemove()) {
                this.removeFromLinkedList(last);
                this.addToFront(last);
                continue;
            }
            this.remove(last.getPos());
            if (!last.isChanged()) continue;
            changed.add(last);
        }
        if (changed.size() > 0) {
            this.sort(changed);
            for (i = 0; i < changed.size(); ++i) {
                CacheObject rec = (CacheObject)changed.get(i);
                this.writer.writeBack(rec);
            }
        }
    }

    private void addToFront(CacheObject rec) {
        if (Constants.CHECK && rec == this.head) {
            throw Message.internal("try to move head");
        }
        rec.next = this.head;
        rec.previous = this.head.previous;
        rec.previous.next = rec;
        rec.next.previous = rec;
    }

    private void removeFromLinkedList(CacheObject rec) {
        if (Constants.CHECK && rec == this.head) {
            throw Message.internal("try to remove head");
        }
        rec.previous.next = rec.next;
        rec.next.previous = rec.previous;
        rec.next = null;
        rec.previous = null;
    }

    public void remove(int pos) {
        int index = pos & this.mask;
        CacheObject rec = this.values[index];
        if (rec.getPos() == pos) {
            this.values[index] = rec.chained;
        } else {
            do {
                CacheObject last = rec;
            } while ((rec = rec.chained).getPos() != pos);
            last.chained = rec.chained;
        }
        --this.size;
        this.removeFromLinkedList(rec);
        if (Constants.CHECK) {
            rec.chained = null;
            if (this.get(pos) != null) {
                throw Message.internal("not removed!");
            }
        }
    }

    public CacheObject getNoMoveToFront(int pos) {
        CacheObject rec = this.values[pos & this.mask];
        while (rec != null && rec.getPos() != pos) {
            rec = rec.chained;
        }
        return rec;
    }

    public CacheObject get(int pos) {
        CacheObject rec = this.getNoMoveToFront(pos);
        if (rec != null) {
            this.removeFromLinkedList(rec);
            this.addToFront(rec);
        }
        return rec;
    }

    public ObjectArray getAllChanged() {
        ObjectArray list = new ObjectArray();
        block0: for (int i = 0; i < this.len; ++i) {
            CacheObject rec = this.values[i];
            while (rec != null) {
                if (rec.isChanged()) {
                    list.add(rec);
                    if (list.size() >= this.size) {
                        if (!Constants.CHECK) continue block0;
                        if (list.size() > this.size) {
                            throw Message.internal("cache chain error");
                        }
                    }
                }
                rec = rec.chained;
            }
        }
        this.sort(list);
        return list;
    }

    private void sort(ObjectArray recordList) {
        recordList.sort(new Comparator(){

            public int compare(Object a, Object b) {
                int pb;
                int pa = ((CacheObject)a).getPos();
                return pa == (pb = ((CacheObject)b).getPos()) ? 0 : (pa < pb ? -1 : 1);
            }
        });
    }

    public void clear() {
        this.head.next = this.head.previous = this.head;
        this.values = new CacheObject[this.len];
        this.size = 0;
    }

    public void setMaxSize(int newSize) throws SQLException {
        this.maxSize = newSize < 0 ? 0 : newSize;
        this.removeOld();
    }
}

