/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.util.ArrayList;
import org.h2.test.TestBase;
import org.h2.test.synth.Command;
import org.h2.test.synth.DbConnection;
import org.h2.test.synth.DbInterface;
import org.h2.test.synth.DbState;
import org.h2.test.synth.RandomGen;
import org.h2.test.synth.Result;
import org.h2.test.synth.Table;

public class TestSynth
extends TestBase {
    static final int H2 = 0;
    static final int H2_MEM = 1;
    static final int HSQLDB = 2;
    static final int MYSQL = 3;
    static final int POSTGRESQL = 4;
    private DbState db = new DbState(this);
    private ArrayList databases;
    private ArrayList commands;
    private RandomGen random = new RandomGen(this);
    private boolean showError;
    private boolean showLog;
    private boolean stopImmediately;
    private int mode;
    private String DIR = "synth";

    public boolean is(int isType) {
        return this.mode == isType;
    }

    public RandomGen random() {
        return this.random;
    }

    public String randomIdentifier() {
        int len = this.random.getLog(8) + 2;
        return this.random.randomString(len);
    }

    private void add(Command command) throws Exception {
        command.run(this.db);
        this.commands.add(command);
    }

    private void addRandomCommands() throws Exception {
        switch (this.random.getInt(20)) {
            case 0: {
                this.add(Command.getDisconnect(this));
                this.add(Command.getConnect(this));
                break;
            }
            case 1: {
                Table table = Table.newRandomTable(this);
                this.add(Command.getCreateTable(this, table));
                break;
            }
            case 2: {
                Table table = this.randomTable();
                this.add(Command.getCreateIndex(this, table.newRandomIndex()));
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                Table table = this.randomTable();
                this.add(Command.getRandomInsert(this, table));
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                Table table = this.randomTable();
                this.add(Command.getRandomUpdate(this, table));
                break;
            }
            case 9: 
            case 10: {
                Table table = this.randomTable();
                this.add(Command.getRandomDelete(this, table));
                break;
            }
            default: {
                Table table = this.randomTable();
                this.add(Command.getRandomSelect(this, table));
            }
        }
    }

    private void testRun(int seed) throws Exception {
        Command command;
        boolean stop;
        int i;
        this.random.setSeed(seed);
        this.commands = new ArrayList();
        this.add(Command.getConnect(this));
        this.add(Command.getReset(this));
        for (i = 0; i < 1; ++i) {
            Table table = Table.newRandomTable(this);
            this.add(Command.getCreateTable(this, table));
            this.add(Command.getCreateIndex(this, table.newRandomIndex()));
        }
        for (i = 0; i < 30; ++i) {
            this.addRandomCommands();
        }
        this.add(Command.getDisconnect(this));
        this.add(Command.getEnd(this));
        for (i = 0; i < this.commands.size() && !(stop = this.process(seed, i, command = (Command)this.commands.get(i))); ++i) {
        }
    }

    private boolean process(int seed, int id, Command command) throws Exception {
        try {
            ArrayList<Result> results = new ArrayList<Result>();
            for (int i = 0; i < this.databases.size(); ++i) {
                DbInterface db = (DbInterface)this.databases.get(i);
                Result result = command.run(db);
                results.add(result);
                if (this.showError && i != 0) continue;
            }
            this.compareResults(results);
        }
        catch (Error e) {
            if (this.showError) {
                e.printStackTrace();
            }
            System.out.println("testRun(" + seed + "); // id=" + id + " " + e.toString());
            if (this.stopImmediately) {
                System.exit(0);
            }
            return true;
        }
        return false;
    }

    private void compareResults(ArrayList results) {
        Result original = (Result)results.get(0);
        for (int i = 1; i < results.size(); ++i) {
            Result copy = (Result)results.get(i);
            if (original.compareTo(copy) == 0) continue;
            if (this.showError) {
                throw new Error("Results don't match: original (0): \r\n" + original + "\r\nother:\r\n" + copy);
            }
            throw new Error("Results don't match");
        }
    }

    public Table randomTable() {
        return this.db.randomTable();
    }

    public void log(int id, String s) {
        if (this.showLog && id == 0) {
            System.out.println(s);
        }
    }

    private void addDatabase(String className, String url, String user, String password, boolean useSentinel) {
        DbConnection db = new DbConnection(this, className, url, user, password, this.databases.size(), useSentinel);
        this.databases.add(db);
    }

    public void test() throws Exception {
        int i;
        BASE_DIR = "dataSynth";
        this.deleteDb("synth");
        this.databases = new ArrayList();
        this.mode = 1;
        Class.forName("org.h2.Driver");
        this.addDatabase("org.h2.Driver", "jdbc:h2:mem:synth", "sa", "", true);
        this.addDatabase("org.h2.Driver", "jdbc:h2:" + BASE_DIR + "/" + this.DIR + "/synth", "sa", "", false);
        for (i = 0; i < this.databases.size(); ++i) {
            DbConnection conn = (DbConnection)this.databases.get(i);
            System.out.println(i + " = " + conn.toString());
        }
        this.showError = true;
        this.showLog = false;
        this.stopImmediately = true;
        this.showLog = true;
        this.testRun(110600);
        System.exit(0);
        for (i = 101620; i < Integer.MAX_VALUE; ++i) {
            if (i % 10 == 0) {
                TestSynth.printTime("TestSynth " + i);
            }
            try {
                if (i % 10 == 0) {
                    this.trace("delete db");
                    this.deleteDb(BASE_DIR, this.DIR + "/synth");
                }
                this.testRun(i);
                continue;
            }
            catch (Error e) {
                System.out.println(e.toString());
                e.printStackTrace();
                System.exit(0);
            }
        }
        BASE_DIR = "data";
    }

    public int getMode() {
        return this.mode;
    }
}

