/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Random;
import org.h2.test.TestBase;

public class TestMemoryUsage
extends TestBase {
    private Connection conn;

    private void reconnect() throws Exception {
        if (this.conn != null) {
            this.conn.close();
        }
        this.conn = this.getConnection("memoryUsage");
    }

    public void test() throws Exception {
        this.deleteDb("memoryUsage");
        this.reconnect();
        this.insertUpdateSelectDelete();
        this.reconnect();
        this.insertUpdateSelectDelete();
        this.conn.close();
    }

    void insertUpdateSelectDelete() throws Exception {
        int i;
        int i2;
        Statement stat = this.conn.createStatement();
        int len = this.getSize(1, 2000);
        long time = System.currentTimeMillis();
        stat.execute("DROP TABLE IF EXISTS TEST");
        this.trace("drop=" + (System.currentTimeMillis() - time));
        stat.execute("CREATE CACHED TABLE TEST(ID INT PRIMARY KEY, NAME VARCHAR(255))");
        PreparedStatement prep = this.conn.prepareStatement("INSERT INTO TEST VALUES(?, 'Hello World')");
        this.printTimeMemory("start", 0L);
        time = System.currentTimeMillis();
        for (i2 = 0; i2 < len; ++i2) {
            prep.setInt(1, i2);
            prep.execute();
            if (i2 % 50000 != 0) continue;
            this.trace("  " + 100 * i2 / len + "%");
        }
        this.printTimeMemory("insert", System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        prep = this.conn.prepareStatement("UPDATE TEST SET NAME='Hallo Welt' WHERE ID = ?");
        for (i2 = 0; i2 < len; ++i2) {
            prep.setInt(1, i2);
            prep.execute();
            if (i2 % 50000 != 0) continue;
            this.trace("  " + 100 * i2 / len + "%");
        }
        this.printTimeMemory("update", System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        prep = this.conn.prepareStatement("SELECT * FROM TEST WHERE ID = ?");
        for (i2 = 0; i2 < len; ++i2) {
            prep.setInt(1, i2);
            ResultSet rs = prep.executeQuery();
            rs.next();
            if (rs.next()) {
                this.error("one row expected, got more");
            }
            if (i2 % 50000 != 0) continue;
            this.trace("  " + 100 * i2 / len + "%");
        }
        this.printTimeMemory("select", System.currentTimeMillis() - time);
        Random random = new Random(1L);
        time = System.currentTimeMillis();
        prep = this.conn.prepareStatement("SELECT * FROM TEST WHERE ID = ?");
        for (i = 0; i < len; ++i) {
            prep.setInt(1, random.nextInt(len));
            ResultSet rs = prep.executeQuery();
            rs.next();
            if (rs.next()) {
                this.error("one row expected, got more");
            }
            if (i % 50000 != 0) continue;
            this.trace("  " + 100 * i / len + "%");
        }
        this.printTimeMemory("select randomized", System.currentTimeMillis() - time);
        time = System.currentTimeMillis();
        prep = this.conn.prepareStatement("DELETE FROM TEST WHERE ID = ?");
        for (i = 0; i < len; ++i) {
            prep.setInt(1, random.nextInt(len));
            prep.executeUpdate();
            if (i % 50000 != 0) continue;
            this.trace("  " + 100 * i / len + "%");
        }
        this.printTimeMemory("delete", System.currentTimeMillis() - time);
    }
}

