/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.parser.v2.XMLParser;
import oracle.xml.xpath.AdditiveExpr;
import oracle.xml.xpath.RangeExpr;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExpr;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLTContext;

class ComparisonExpr
extends XSLExprBase {
    short compType;
    static short GENERALCOMP = 1;
    static short VALUECOMP = (short)2;
    static short NODECOMP = (short)3;
    static short ORDERCOMP = (short)4;

    ComparisonExpr() {
        super.setExprType(4);
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        boolean bl = XSLExpr.isXPath20Compatible(xSLParseString);
        XSLExprBase xSLExprBase = bl ? RangeExpr.parse(xSLParseString) : AdditiveExpr.parse(xSLParseString);
        if (xSLParseString.peekToken() == 105) {
            ComparisonExpr comparisonExpr = new ComparisonExpr();
            comparisonExpr.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
            int n = xSLParseString.getOperator();
            if (ComparisonExpr.isGeneralCompOp(n)) {
                comparisonExpr.compType = GENERALCOMP;
            } else if (ComparisonExpr.isValueCompOp(n)) {
                comparisonExpr.compType = VALUECOMP;
            } else if (ComparisonExpr.isNodeCompOp(n)) {
                comparisonExpr.compType = NODECOMP;
            } else if (ComparisonExpr.isOrderCompOp(n)) {
                comparisonExpr.compType = ORDERCOMP;
            } else {
                return xSLExprBase;
            }
            xSLParseString.nextToken();
            comparisonExpr.operator = n;
            comparisonExpr.leftExpr = xSLExprBase;
            comparisonExpr.rightExpr = bl ? RangeExpr.parse(xSLParseString) : ComparisonExpr.parse(xSLParseString);
            xSLExprBase = comparisonExpr;
            if (xSLParseString.isCachingExpr() && !xSLExprBase.canCacheExpr()) {
                xSLExprBase.cacheSubExpr();
            }
        }
        return xSLExprBase;
    }

    static boolean isGeneralCompOp(int n) {
        return n == 216 || n == 217 || n == 218 || n == 219 || n == 220 || n == 221;
    }

    static boolean isValueCompOp(int n) {
        return n == 210 || n == 211 || n == 212 || n == 213 || n == 214 || n == 215;
    }

    static boolean isNodeCompOp(int n) {
        if (XMLParser.getIs1010Compatible()) {
            return n == 208 || n == 209;
        }
        return n == 208;
    }

    static boolean isOrderCompOp(int n) {
        return n == 222 || n == 223;
    }

    void cacheSubExpr() throws XQException {
        if (this.leftExpr.canCacheExpr()) {
            this.leftExpr = this.leftExpr.createCachedExpr();
        }
        if (this.rightExpr.canCacheExpr()) {
            this.rightExpr = this.rightExpr.createCachedExpr();
        }
    }

    boolean canCacheExpr() {
        return this.leftExpr.canCacheExpr() && this.rightExpr.canCacheExpr();
    }

    String getNormalizedExpr() throws XQException {
        StringBuffer stringBuffer = new StringBuffer(this.leftExpr.getNormalizedExpr());
        stringBuffer.append(this.operator);
        stringBuffer.append(this.rightExpr.getNormalizedExpr());
        return stringBuffer.toString();
    }

    boolean checkPosLastFN() {
        return this.leftExpr.checkPosLastFN() || this.rightExpr.checkPosLastFN();
    }

    public void evaluate(XSLTContext xSLTContext) throws XSLException, XQException {
        xSLTContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        this.leftExpr.evaluate(xSLTContext);
        OXMLSequence oXMLSequence = xSLTContext.peekExprValue();
        this.rightExpr.evaluate(xSLTContext);
        if (this.compType == GENERALCOMP) {
            boolean bl = this.getXSLTVersion() == 10 && !this.isForwardCompatibilityMode() || this.getXSLTVersion() == 20 && this.isBackwardCompatibilityMode();
            XPathSequence.compareGeneral(oXMLSequence, xSLTContext.popExprValue(), this.operator, bl);
        }
        if (this.compType == VALUECOMP) {
            XPathSequence.compareValue(oXMLSequence, xSLTContext.popExprValue(), this.operator);
        } else if (this.compType == NODECOMP || this.compType == ORDERCOMP) {
            XPathSequence.compareNodeAndOrder(oXMLSequence, xSLTContext.popExprValue(), this.operator);
        }
    }
}

