/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.db;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.h2.test.TestBase;

public class TestBatchUpdates
extends TestBase {
    static final String COFFEE_UPDATE = "UPDATE TEST SET PRICE=PRICE*20 WHERE TYPE_ID=?";
    static final String COFFEE_SELECT = "SELECT PRICE FROM TEST WHERE KEY_ID=?";
    static final String COFFEE_QUERY = "SELECT COF_NAME,PRICE FROM TEST WHERE TYPE_ID=?";
    static final String COFFEE_DELETE = "DELETE FROM TEST WHERE KEY_ID=?";
    static final String COFFEE_INSERT1 = "INSERT INTO TEST VALUES(9,'COFFEE-9',9.0,5)";
    static final String COFFEE_DELETE1 = "DELETE FROM TEST WHERE KEY_ID=9";
    static final String COFFEE_UPDATE1 = "UPDATE TEST SET PRICE=PRICE*20 WHERE TYPE_ID=1";
    static final String COFFEE_SELECT1 = "SELECT PRICE FROM TEST WHERE KEY_ID>4";
    static final String COFFEE_UPDATE_SET = "UPDATE TEST SET KEY_ID=?, COF_NAME=? WHERE COF_NAME=?";
    static final String COFFEE_SELECT_CONTINUED = "SELECT COUNT(*) FROM TEST WHERE COF_NAME='Continue-1'";
    int coffeeSize = 10;
    int coffeeType = 11;
    Connection conn;
    Statement stat;
    PreparedStatement prep;

    public void test() throws Exception {
        this.deleteDb("batchUpdates");
        this.conn = this.getConnection("batchUpdates");
        this.stat = this.conn.createStatement();
        DatabaseMetaData meta = this.conn.getMetaData();
        if (!meta.supportsBatchUpdates()) {
            this.error("does not support BatchUpdates");
        }
        this.stat.executeUpdate("CREATE TABLE TEST(KEY_ID INT PRIMARY KEY,COF_NAME VARCHAR(255),PRICE DECIMAL(20,2),TYPE_ID INT)");
        String newName = null;
        float newPrice = 0.0f;
        int newType = 0;
        this.prep = this.conn.prepareStatement("INSERT INTO TEST VALUES(?,?,?,?)");
        int newKey = 1;
        for (int i = 1; i <= this.coffeeType && newKey <= this.coffeeSize; ++i) {
            for (int j = 1; j <= i && newKey <= this.coffeeSize; ++newKey, ++j) {
                newName = "COFFEE-" + newKey;
                newPrice = (float)newKey + 0.0f;
                newType = i;
                this.prep.setInt(1, newKey);
                this.prep.setString(2, newName);
                this.prep.setFloat(3, newPrice);
                this.prep.setInt(4, newType);
                this.prep.execute();
            }
        }
        this.trace("Inserted the Rows ");
        this.testAddBatch01();
        this.testAddBatch02();
        this.testClearBatch01();
        this.testClearBatch02();
        this.testExecuteBatch01();
        this.testExecuteBatch02();
        this.testExecuteBatch03();
        this.testExecuteBatch04();
        this.testExecuteBatch05();
        this.testExecuteBatch06();
        this.testExecuteBatch07();
        this.testContinueBatch01();
        this.conn.close();
    }

    public void testAddBatch01() throws Exception {
        this.trace("testAddBatch01");
        int i = 0;
        int[] retValue = new int[]{0, 0, 0};
        String sPrepStmt = COFFEE_UPDATE;
        this.trace("Prepared Statement String :" + sPrepStmt);
        this.prep = this.conn.prepareStatement(sPrepStmt);
        this.prep.setInt(1, 2);
        this.prep.addBatch();
        this.prep.setInt(1, 3);
        this.prep.addBatch();
        this.prep.setInt(1, 4);
        this.prep.addBatch();
        int[] updateCount = this.prep.executeBatch();
        int updateCountlen = updateCount.length;
        this.trace("updateCount Length :" + updateCountlen);
        if (updateCountlen != 3) {
            this.error("addBatch");
        } else {
            this.trace("addBatch add the SQL statements to Batch ");
        }
        String query1 = "SELECT COUNT(*) FROM TEST WHERE TYPE_ID=2";
        String query2 = "SELECT COUNT(*) FROM TEST WHERE TYPE_ID=3";
        String query3 = "SELECT COUNT(*) FROM TEST WHERE TYPE_ID=4";
        ResultSet rs = this.stat.executeQuery(query1);
        rs.next();
        retValue[i++] = rs.getInt(1);
        rs = this.stat.executeQuery(query2);
        rs.next();
        retValue[i++] = rs.getInt(1);
        rs = this.stat.executeQuery(query3);
        rs.next();
        retValue[i++] = rs.getInt(1);
        for (int j = 0; j < updateCount.length; ++j) {
            this.trace("UpdateCount :" + updateCount[j]);
            if (updateCount[j] == retValue[j]) continue;
            this.error("j=" + j + " right:" + retValue[j]);
        }
    }

    public void testAddBatch02() throws Exception {
        this.trace("testAddBatch02");
        int i = 0;
        int[] retValue = new int[]{0, 0, 0};
        int updCountLength = 0;
        String sUpdCoffee = COFFEE_UPDATE1;
        String sDelCoffee = COFFEE_DELETE1;
        String sInsCoffee = COFFEE_INSERT1;
        this.stat.addBatch(sUpdCoffee);
        this.stat.addBatch(sDelCoffee);
        this.stat.addBatch(sInsCoffee);
        int[] updateCount = this.stat.executeBatch();
        updCountLength = updateCount.length;
        this.trace("updateCount Length :" + updCountLength);
        if (updCountLength != 3) {
            this.error("addBatch");
        } else {
            this.trace("addBatch add the SQL statements to Batch ");
        }
        String query1 = "SELECT COUNT(*) FROM TEST WHERE TYPE_ID=1";
        ResultSet rs = this.stat.executeQuery(query1);
        rs.next();
        retValue[i++] = rs.getInt(1);
        retValue[i++] = 1;
        retValue[i++] = 1;
        this.trace("ReturnValue count : " + retValue.length);
        for (int j = 0; j < updateCount.length; ++j) {
            this.trace("Update Count :" + updateCount[j]);
            this.trace("Returned Value : " + retValue[j]);
            if (updateCount[j] == retValue[j]) continue;
            this.error("j=" + j + " right:" + retValue[j]);
        }
    }

    public void testClearBatch01() throws Exception {
        this.trace("testClearBatch01");
        String sPrepStmt = COFFEE_UPDATE;
        this.trace("Prepared Statement String :" + sPrepStmt);
        this.prep = this.conn.prepareStatement(sPrepStmt);
        this.prep.setInt(1, 2);
        this.prep.addBatch();
        this.prep.setInt(1, 3);
        this.prep.addBatch();
        this.prep.setInt(1, 4);
        this.prep.addBatch();
        this.prep.clearBatch();
        int[] updateCount = this.prep.executeBatch();
        int updCountLength = updateCount.length;
        if (updCountLength == 0) {
            this.trace("clearBatch Method clears the current Batch ");
        } else {
            this.error("clearBatch");
        }
    }

    public void testClearBatch02() throws Exception {
        this.trace("testClearBatch02");
        int updCountLength = 0;
        String sUpdCoffee = COFFEE_UPDATE1;
        String sInsCoffee = COFFEE_INSERT1;
        String sDelCoffee = COFFEE_DELETE1;
        this.stat.addBatch(sUpdCoffee);
        this.stat.addBatch(sDelCoffee);
        this.stat.addBatch(sInsCoffee);
        this.stat.clearBatch();
        int[] updateCount = this.stat.executeBatch();
        updCountLength = updateCount.length;
        this.trace("updateCount Length :" + updCountLength);
        if (updCountLength == 0) {
            this.trace("clearBatch Method clears the current Batch ");
        } else {
            this.error("clearBatch");
        }
    }

    public void testExecuteBatch01() throws Exception {
        this.trace("testExecuteBatch01");
        int i = 0;
        int[] retValue = new int[]{0, 0, 0};
        int updCountLength = 0;
        String sPrepStmt = COFFEE_UPDATE;
        this.trace("Prepared Statement String :" + sPrepStmt);
        this.prep = this.conn.prepareStatement(sPrepStmt);
        this.prep.setInt(1, 1);
        this.prep.addBatch();
        this.prep.setInt(1, 2);
        this.prep.addBatch();
        this.prep.setInt(1, 3);
        this.prep.addBatch();
        int[] updateCount = this.prep.executeBatch();
        updCountLength = updateCount.length;
        this.trace("Successfully Updated");
        this.trace("updateCount Length :" + updCountLength);
        if (updCountLength != 3) {
            this.error("executeBatch");
        } else {
            this.trace("executeBatch executes the Batch of SQL statements");
        }
        String query1 = "SELECT COUNT(*) FROM TEST WHERE TYPE_ID=1";
        String query2 = "SELECT COUNT(*) FROM TEST WHERE TYPE_ID=2";
        String query3 = "SELECT COUNT(*) FROM TEST WHERE TYPE_ID=3";
        ResultSet rs = this.stat.executeQuery(query1);
        rs.next();
        retValue[i++] = rs.getInt(1);
        rs = this.stat.executeQuery(query2);
        rs.next();
        retValue[i++] = rs.getInt(1);
        rs = this.stat.executeQuery(query3);
        rs.next();
        retValue[i++] = rs.getInt(1);
        this.trace("retvalue length : " + retValue.length);
        for (int j = 0; j < updateCount.length; ++j) {
            this.trace("UpdateCount Value :" + updateCount[j]);
            this.trace("Retvalue : " + retValue[j]);
            if (updateCount[j] == retValue[j]) continue;
            this.error("j=" + j + " right:" + retValue[j]);
        }
    }

    public void testExecuteBatch02() throws Exception {
        this.trace("testExecuteBatch02");
        String sPrepStmt = COFFEE_UPDATE;
        this.trace("Prepared Statement String :" + sPrepStmt);
        this.prep = this.conn.prepareStatement(sPrepStmt);
        this.prep.setInt(1, 1);
        this.prep.setInt(1, 2);
        this.prep.setInt(1, 3);
        int[] updateCount = this.prep.executeBatch();
        int updCountLength = updateCount.length;
        this.trace("UpdateCount Length : " + updCountLength);
        if (updCountLength == 0) {
            this.trace("executeBatch does not execute Empty Batch");
        } else {
            this.error("executeBatch");
        }
    }

    public void testExecuteBatch03() throws Exception {
        this.trace("testExecuteBatch03");
        boolean bexpflag = false;
        String sPrepStmt = COFFEE_SELECT;
        this.trace("Prepared Statement String :" + sPrepStmt);
        this.prep = this.conn.prepareStatement(sPrepStmt);
        this.prep.setInt(1, 1);
        this.prep.addBatch();
        try {
            int[] updateCount = this.prep.executeBatch();
            this.trace("Update Count" + updateCount.length);
        }
        catch (BatchUpdateException b) {
            bexpflag = true;
        }
        if (bexpflag) {
            this.trace("select not allowed; correct");
        } else {
            this.error("executeBatch select");
        }
    }

    public void testExecuteBatch04() throws Exception {
        this.trace("testExecuteBatch04");
        int i = 0;
        int[] retValue = new int[]{0, 0, 0};
        int updCountLength = 0;
        String sUpdCoffee = COFFEE_UPDATE1;
        String sInsCoffee = COFFEE_INSERT1;
        String sDelCoffee = COFFEE_DELETE1;
        this.stat.addBatch(sUpdCoffee);
        this.stat.addBatch(sDelCoffee);
        this.stat.addBatch(sInsCoffee);
        int[] updateCount = this.stat.executeBatch();
        updCountLength = updateCount.length;
        this.trace("Successfully Updated");
        this.trace("updateCount Length :" + updCountLength);
        if (updCountLength != 3) {
            this.error("executeBatch");
        } else {
            this.trace("executeBatch executes the Batch of SQL statements");
        }
        String query1 = "SELECT COUNT(*) FROM TEST WHERE TYPE_ID=1";
        ResultSet rs = this.stat.executeQuery(query1);
        rs.next();
        retValue[i++] = rs.getInt(1);
        retValue[i++] = 1;
        retValue[i++] = 1;
        for (int j = 0; j < updateCount.length; ++j) {
            this.trace("Update Count : " + updateCount[j]);
            if (updateCount[j] == retValue[j]) continue;
            this.error("j=" + j + " right:" + retValue[j]);
        }
    }

    public void testExecuteBatch05() throws Exception {
        this.trace("testExecuteBatch05");
        int updCountLength = 0;
        int[] updateCount = this.stat.executeBatch();
        updCountLength = updateCount.length;
        this.trace("updateCount Length :" + updCountLength);
        if (updCountLength == 0) {
            this.trace("executeBatch Method does not execute the Empty Batch ");
        } else {
            this.error("executeBatch 0!=" + updCountLength);
        }
    }

    public void testExecuteBatch06() throws Exception {
        this.trace("testExecuteBatch06");
        boolean bexpflag = false;
        String sInsCoffee = COFFEE_INSERT1;
        String sDelCoffee = COFFEE_DELETE1;
        this.stat.addBatch(sInsCoffee);
        this.stat.addBatch(sInsCoffee);
        this.stat.addBatch(sDelCoffee);
        try {
            this.stat.executeBatch();
        }
        catch (BatchUpdateException b) {
            bexpflag = true;
            int[] updCounts = b.getUpdateCounts();
            for (int i = 0; i < updCounts.length; ++i) {
                this.trace("Update counts :" + updCounts[i]);
            }
        }
        if (bexpflag) {
            this.trace("executeBatch insert duplicate; correct");
        } else {
            this.error("executeBatch");
        }
    }

    public void testExecuteBatch07() throws Exception {
        this.trace("testExecuteBatch07");
        boolean bexpflag = false;
        String sSelCoffee = COFFEE_SELECT1;
        this.trace("sSelCoffee = " + sSelCoffee);
        Statement stmt = this.conn.createStatement();
        stmt.addBatch(sSelCoffee);
        try {
            int[] updateCount = stmt.executeBatch();
            this.trace("updateCount Length : " + updateCount.length);
        }
        catch (BatchUpdateException be) {
            bexpflag = true;
        }
        if (bexpflag) {
            this.trace("executeBatch select");
        } else {
            this.error("executeBatch");
        }
    }

    public void testContinueBatch01() throws Exception {
        this.trace("testContinueBatch01");
        int[] batchUpdates = new int[]{0, 0, 0};
        int buCountlen = 0;
        try {
            String sPrepStmt = COFFEE_UPDATE_SET;
            this.trace("Prepared Statement String :" + sPrepStmt);
            this.prep = this.conn.prepareStatement(sPrepStmt);
            this.prep.setInt(1, 1);
            this.prep.setString(2, "Continue-1");
            this.prep.setString(3, "COFFEE-1");
            this.prep.addBatch();
            this.prep.setInt(1, 1);
            this.prep.setString(2, "Invalid");
            this.prep.setString(3, "COFFEE-3");
            this.prep.addBatch();
            this.prep.setInt(1, 2);
            this.prep.setString(2, "Continue-2");
            this.prep.setString(3, "COFFEE-2");
            this.prep.addBatch();
            this.prep.executeBatch();
        }
        catch (BatchUpdateException b) {
            this.trace("expected BatchUpdateException");
            batchUpdates = b.getUpdateCounts();
            buCountlen = batchUpdates.length;
        }
        if (buCountlen == 1) {
            this.trace("no continued updates - OK");
            return;
        }
        if (buCountlen == 3) {
            this.trace("Driver supports continued updates.");
            String query = COFFEE_SELECT_CONTINUED;
            this.trace("Query is: " + query);
            ResultSet rs = this.stat.executeQuery(query);
            rs.next();
            int count = rs.getInt(1);
            rs.close();
            this.stat.close();
            this.trace("Count val is: " + count);
            if (batchUpdates[1] != -3 || count != 1) {
                this.error("insert failed");
            }
        }
    }
}

