/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.Schema;
import org.h2.message.Message;

public class DropSchema
extends DefineCommand {
    private String schemaName;

    public DropSchema(Parser parser) {
        super(parser);
    }

    public void setSchemaName(String name) {
        this.schemaName = name;
    }

    public int update() throws SQLException {
        this.session.getUser().checkAdmin();
        this.session.commit();
        Database db = this.session.getDatabase();
        if (this.schemaName.equals("INFORMATION_SCHEMA") || this.schemaName.equals("PUBLIC")) {
            throw Message.getSQLException(90090, this.schemaName);
        }
        Schema schema = db.findSchema(this.schemaName);
        if (schema == null) {
            throw Message.getSQLException(90079, this.schemaName);
        }
        db.removeDatabaseObject(this.session, schema);
        return 0;
    }
}

