/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLDrawableHelper;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.geom.Rectangle2D;
import java.beans.Beans;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.opengl.AWTGraphicsConfiguration;
import javax.media.opengl.AWTGraphicsDevice;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesChooser;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.Threading;

public class GLCanvas
extends Canvas
implements GLAutoDrawable {
    private static final boolean DEBUG = Debug.debug("GLCanvas");
    private GLDrawableHelper drawableHelper = new GLDrawableHelper();
    private GLDrawable drawable;
    private GLContext context;
    private boolean autoSwapBufferMode = true;
    private boolean sendReshape = false;
    private GraphicsConfiguration chosen;
    private GLCapabilities glCaps;
    private GLCapabilitiesChooser glCapChooser;
    private InitAction initAction = new InitAction();
    private DisplayAction displayAction = new DisplayAction();
    private SwapBuffersAction swapBuffersAction = new SwapBuffersAction();
    private DisplayOnEventDispatchThreadAction displayOnEventDispatchThreadAction = new DisplayOnEventDispatchThreadAction();
    private SwapBuffersOnEventDispatchThreadAction swapBuffersOnEventDispatchThreadAction = new SwapBuffersOnEventDispatchThreadAction();
    private DestroyAction destroyAction = new DestroyAction();
    private static boolean disableBackgroundEraseInitialized;
    private static Method disableBackgroundEraseMethod;
    static /* synthetic */ Class class$java$awt$Canvas;

    public GLCanvas() {
        this((GLCapabilities)null);
    }

    public GLCanvas(GLCapabilities gLCapabilities) {
        this(gLCapabilities, null, null, null);
    }

    public GLCanvas(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext, GraphicsDevice graphicsDevice) {
        this.chosen = GLCanvas.chooseGraphicsConfiguration(gLCapabilities, gLCapabilitiesChooser, graphicsDevice);
        if (this.chosen != null) {
            this.glCapChooser = gLCapabilitiesChooser;
            this.glCaps = gLCapabilities;
        }
        if (!Beans.isDesignTime()) {
            this.drawable = GLDrawableFactory.getFactory().getGLDrawable(this, gLCapabilities, gLCapabilitiesChooser);
            this.context = this.drawable.createContext(gLContext);
            this.context.setSynchronized(true);
        }
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsConfiguration graphicsConfiguration = super.getGraphicsConfiguration();
        if (graphicsConfiguration != null && this.chosen != null && !this.chosen.equals(graphicsConfiguration)) {
            GraphicsConfiguration graphicsConfiguration2;
            if (!this.chosen.getDevice().getIDstring().equals(graphicsConfiguration.getDevice().getIDstring()) && (graphicsConfiguration2 = GLCanvas.chooseGraphicsConfiguration(this.glCaps, this.glCapChooser, graphicsConfiguration.getDevice())) != null) {
                this.chosen = graphicsConfiguration2;
            }
            return this.chosen;
        }
        if (graphicsConfiguration == null) {
            return this.chosen;
        }
        return graphicsConfiguration;
    }

    public GLContext createContext(GLContext gLContext) {
        return this.drawable.createContext(gLContext);
    }

    public void setRealized(boolean bl) {
    }

    public void display() {
        this.maybeDoSingleThreadedWorkaround(this.displayOnEventDispatchThreadAction, this.displayAction);
    }

    public void paint(Graphics graphics) {
        if (Beans.isDesignTime()) {
            int n;
            graphics.setColor(Color.BLACK);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            String string = this.getName();
            if (string == null && (n = (string = this.getClass().getName()).lastIndexOf(46)) >= 0) {
                string = string.substring(n + 1);
            }
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
            graphics.setColor(Color.WHITE);
            graphics.drawString(string, (int)(((double)this.getWidth() - rectangle2D.getWidth()) / 2.0), (int)(((double)this.getHeight() + rectangle2D.getHeight()) / 2.0));
            return;
        }
        this.display();
    }

    public void addNotify() {
        super.addNotify();
        if (!Beans.isDesignTime()) {
            this.disableBackgroundErase();
            this.drawable.setRealized(true);
        }
        if (DEBUG) {
            System.err.println("GLCanvas.addNotify()");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeNotify() {
        if (Beans.isDesignTime()) {
            super.removeNotify();
            return;
        }
        try {
            if (Threading.isSingleThreaded() && !Threading.isOpenGLThread()) {
                if (Threading.isAWTMode() && Thread.holdsLock(this.getTreeLock())) {
                    this.destroyAction.run();
                } else {
                    Threading.invokeOnOpenGLThread(this.destroyAction);
                }
            } else {
                this.destroyAction.run();
            }
            Object var2_1 = null;
            this.drawable.setRealized(false);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.drawable.setRealized(false);
            super.removeNotify();
            if (!DEBUG) throw throwable;
            System.err.println("GLCanvas.removeNotify()");
            throw throwable;
        }
        super.removeNotify();
        if (!DEBUG) return;
        System.err.println("GLCanvas.removeNotify()");
    }

    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
        this.sendReshape = true;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void addGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.addGLEventListener(gLEventListener);
    }

    public void removeGLEventListener(GLEventListener gLEventListener) {
        this.drawableHelper.removeGLEventListener(gLEventListener);
    }

    public GLContext getContext() {
        return this.context;
    }

    public GL getGL() {
        if (Beans.isDesignTime()) {
            return null;
        }
        return this.getContext().getGL();
    }

    public void setGL(GL gL) {
        if (!Beans.isDesignTime()) {
            this.getContext().setGL(gL);
        }
    }

    public void setAutoSwapBufferMode(boolean bl) {
        this.drawableHelper.setAutoSwapBufferMode(bl);
    }

    public boolean getAutoSwapBufferMode() {
        return this.drawableHelper.getAutoSwapBufferMode();
    }

    public void swapBuffers() {
        this.maybeDoSingleThreadedWorkaround(this.swapBuffersOnEventDispatchThreadAction, this.swapBuffersAction);
    }

    public GLCapabilities getChosenGLCapabilities() {
        if (this.drawable == null) {
            return null;
        }
        return this.drawable.getChosenGLCapabilities();
    }

    private void maybeDoSingleThreadedWorkaround(Runnable runnable, Runnable runnable2) {
        if (Threading.isSingleThreaded() && !Threading.isOpenGLThread()) {
            Threading.invokeOnOpenGLThread(runnable);
        } else {
            this.drawableHelper.invokeGL(this.drawable, this.context, runnable2, this.initAction);
        }
    }

    private void disableBackgroundErase() {
        if (!disableBackgroundEraseInitialized) {
            try {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            disableBackgroundEraseMethod = GLCanvas.this.getToolkit().getClass().getDeclaredMethod("disableBackgroundErase", class$java$awt$Canvas == null ? (class$java$awt$Canvas = GLCanvas.class$("java.awt.Canvas")) : class$java$awt$Canvas);
                            disableBackgroundEraseMethod.setAccessible(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        return null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            disableBackgroundEraseInitialized = true;
        }
        if (disableBackgroundEraseMethod != null) {
            try {
                disableBackgroundEraseMethod.invoke((Object)this.getToolkit(), this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static GraphicsConfiguration chooseGraphicsConfiguration(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GraphicsDevice graphicsDevice) {
        if (Beans.isDesignTime()) {
            return null;
        }
        AWTGraphicsConfiguration aWTGraphicsConfiguration = (AWTGraphicsConfiguration)GLDrawableFactory.getFactory().chooseGraphicsConfiguration(gLCapabilities, gLCapabilitiesChooser, new AWTGraphicsDevice(graphicsDevice));
        if (aWTGraphicsConfiguration == null) {
            return null;
        }
        return aWTGraphicsConfiguration.getGraphicsConfiguration();
    }

    class DestroyAction
    implements Runnable {
        DestroyAction() {
        }

        public void run() {
            GLContext gLContext = GLContext.getCurrent();
            if (gLContext == GLCanvas.this.context) {
                GLCanvas.this.context.release();
            }
            GLCanvas.this.context.destroy();
        }
    }

    class DisplayAction
    implements Runnable {
        DisplayAction() {
        }

        public void run() {
            if (GLCanvas.this.sendReshape) {
                int n = GLCanvas.this.getWidth();
                int n2 = GLCanvas.this.getHeight();
                GLCanvas.this.getGL().glViewport(0, 0, n, n2);
                GLCanvas.this.drawableHelper.reshape(GLCanvas.this, 0, 0, n, n2);
                GLCanvas.this.sendReshape = false;
            }
            GLCanvas.this.drawableHelper.display(GLCanvas.this);
        }
    }

    class DisplayOnEventDispatchThreadAction
    implements Runnable {
        DisplayOnEventDispatchThreadAction() {
        }

        public void run() {
            GLCanvas.this.drawableHelper.invokeGL(GLCanvas.this.drawable, GLCanvas.this.context, GLCanvas.this.displayAction, GLCanvas.this.initAction);
        }
    }

    class InitAction
    implements Runnable {
        InitAction() {
        }

        public void run() {
            GLCanvas.this.drawableHelper.init(GLCanvas.this);
        }
    }

    class SwapBuffersAction
    implements Runnable {
        SwapBuffersAction() {
        }

        public void run() {
            GLCanvas.this.drawable.swapBuffers();
        }
    }

    class SwapBuffersOnEventDispatchThreadAction
    implements Runnable {
        SwapBuffersOnEventDispatchThreadAction() {
        }

        public void run() {
            GLCanvas.this.drawableHelper.invokeGL(GLCanvas.this.drawable, GLCanvas.this.context, GLCanvas.this.swapBuffersAction, GLCanvas.this.initAction);
        }
    }
}

