/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

public class Semaphore {
    protected long permits;

    public Semaphore(long initialPermits) {
        this.permits = initialPermits;
    }

    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            try {
                while (this.permits <= 0L) {
                    this.wait();
                }
                --this.permits;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }

    public boolean attempt(long msecs) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Semaphore semaphore = this;
        synchronized (semaphore) {
            if (this.permits > 0L) {
                --this.permits;
                boolean bl = true;
                return bl;
            }
            if (msecs <= 0L) {
                boolean bl = false;
                return bl;
            }
            try {
                long startTime = System.currentTimeMillis();
                long waitTime = msecs;
                do {
                    this.wait(waitTime);
                    if (this.permits <= 0L) continue;
                    --this.permits;
                    boolean bl = true;
                    return bl;
                } while ((waitTime = msecs - (System.currentTimeMillis() - startTime)) > 0L);
                boolean bl = false;
                return bl;
            }
            catch (InterruptedException ex) {
                this.notify();
                throw ex;
            }
        }
    }

    public synchronized void release() {
        ++this.permits;
        this.notify();
    }

    public synchronized void release(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException("Negative argument");
        }
        this.permits += n;
        long i = 0L;
        while (i < n) {
            this.notify();
            ++i;
        }
    }

    public synchronized long permits() {
        return this.permits;
    }
}

