/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class TextAreaWidget
extends aTextWidget {
    JTextArea textArea;
    int lastCharCode = 65535;
    int lastDot = 0;
    Process process = null;
    BufferedWriter stdOut;
    BufferedReader stdInput;
    BufferedReader stdError;
    String command = "";
    int historyIndex = 0;
    Vector history;
    String lastShellCommand;
    String commandBatch = "";
    boolean isInBatch = false;

    public TextAreaWidget(StringTokenizer stringTokenizer) {
        this.id = stringTokenizer.nextToken();
        this.action = stringTokenizer.nextToken();
        this.textArea = new JTextArea();
        this.textArea.setFont(new Font("SansSerif", 0, 12));
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.areaScrollPane = new JScrollPane(this.textArea);
        this.areaScrollPane.setVerticalScrollBarPolicy(20);
        this.container = this.areaScrollPane;
        this.jcomponent = this.textArea;
        this.component = this.areaScrollPane;
        this.textcomp = this.textArea;
        this.isScrollable = true;
        if (stringTokenizer.hasMoreTokens()) {
            this.areaScrollPane.setPreferredSize(new Dimension(Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken())));
        }
        gsObject.widgets.put(this.id, this);
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                Character c = new Character(keyEvent.getKeyChar());
                TextAreaWidget.this.lastCharCode = c.hashCode();
                if (TextAreaWidget.this.process != null && TextAreaWidget.this.lastCharCode == 12) {
                    TextAreaWidget.this.textArea.setText("");
                    TextAreaWidget.this.lastDot = 0;
                    try {
                        TextAreaWidget.this.stdOut.write(10);
                        TextAreaWidget.this.stdOut.flush();
                    }
                    catch (IOException iOException) {
                        System.out.println("clear screen:" + iOException);
                    }
                }
            }
        };
        CaretListener caretListener = new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                int n = caretEvent.getMark();
                int n2 = caretEvent.getDot();
                guiserver.out.println("(" + TextAreaWidget.this.action + " \"" + TextAreaWidget.this.id + "\" " + TextAreaWidget.this.lastCharCode + " " + n2 + " " + n + ")");
                guiserver.out.flush();
                TextAreaWidget.this.lastCharCode = 65535;
            }
        };
        this.textArea.addCaretListener(caretListener);
        this.textArea.addKeyListener(keyAdapter);
    }

    public void setTabSize(StringTokenizer stringTokenizer) {
        this.textArea.setTabSize(Integer.parseInt(stringTokenizer.nextToken()));
    }

    public void clearText(StringTokenizer stringTokenizer) {
        this.textcomp.setText("");
        this.lastCharCode = 65535;
        this.lastDot = 0;
        if (this.process != null) {
            try {
                this.stdOut.write(10);
                this.stdOut.flush();
            }
            catch (IOException iOException) {
                System.out.println("clear screen:" + iOException);
            }
        }
    }

    public void runShell(StringTokenizer stringTokenizer) {
        String string;
        if (stringTokenizer == null) {
            string = this.lastShellCommand;
        } else {
            this.lastShellCommand = string = Base64Coder.decodeString(stringTokenizer.nextToken());
        }
        this.history = new Vector();
        this.historyIndex = 0;
        this.commandBatch = "";
        this.isInBatch = false;
        if (this.process != null) {
            this.process.destroy();
        }
        InputMap inputMap = this.textArea.getInputMap();
        ActionMap actionMap = this.textArea.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(38, 0), "history-up");
        inputMap.put(KeyStroke.getKeyStroke(80, 2), "history-up");
        actionMap.put("history-up", new HistoryUpAction());
        inputMap.put(KeyStroke.getKeyStroke(40, 0), "history-down");
        inputMap.put(KeyStroke.getKeyStroke(78, 2), "history-down");
        actionMap.put("history-down", new HistoryDownAction());
        inputMap.put(KeyStroke.getKeyStroke(10, 0), "command");
        actionMap.put("command", new CommandAction());
        inputMap.put(KeyStroke.getKeyStroke(65, 2), "bol");
        inputMap.put(KeyStroke.getKeyStroke(36, 0), "bol");
        actionMap.put("bol", new BeginningOfLineAction());
        inputMap.put(KeyStroke.getKeyStroke(69, 2), "eol");
        inputMap.put(KeyStroke.getKeyStroke(35, 0), "eol");
        actionMap.put("eol", new EndOfLineAction());
        this.textArea.setText("");
        this.lastCharCode = 65535;
        this.lastDot = 0;
        try {
            this.setupShell(string);
        }
        catch (IOException iOException) {
            ErrorDialog.show("run-shell", "Could not start " + string);
            this.process = null;
        }
    }

    public void setupShell(String string) throws IOException {
        this.process = Runtime.getRuntime().exec(string);
        if (guiserver.UTF8) {
            this.stdInput = new BufferedReader(new InputStreamReader(this.process.getInputStream(), "UTF8"));
            this.stdError = new BufferedReader(new InputStreamReader(this.process.getErrorStream(), "UTF8"));
        } else {
            this.stdInput = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
            this.stdError = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
        }
        this.stdOut = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream()));
        new Thread(new stdinListener()).start();
        new Thread(new stderrorListener()).start();
    }

    public void destroyShell(StringTokenizer stringTokenizer) {
        if (this.process != null) {
            this.process.destroy();
        }
        this.process = null;
        this.stdOut = null;
    }

    public void evalShell(StringTokenizer stringTokenizer) {
        String string = Base64Coder.decodeString(stringTokenizer.nextToken());
        while (true) {
            if (this.process == null) {
                this.textArea.append("--- restarting shell ---");
                this.runShell(null);
                if (this.process != null) continue;
                break;
            }
            try {
                this.textArea.append("\n");
                this.stdOut.write(string, 0, string.length());
                this.stdOut.flush();
            }
            catch (IOException iOException) {
                this.textArea.append("--- eval shell: must restart shell ---");
                this.process = null;
                continue;
            }
            break;
        }
    }

    private class CommandAction
    extends AbstractAction {
        public static final long serialVersionUID = 1L;

        private CommandAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = TextAreaWidget.this.textArea.getText();
            if (string.length() < TextAreaWidget.this.lastDot) {
                TextAreaWidget.this.lastDot = string.length();
            }
            string = string.substring(TextAreaWidget.this.lastDot);
            if (guiserver.UTF8) {
                try {
                    string = new String(string.getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            TextAreaWidget.this.command = string;
            if (TextAreaWidget.this.command.equals("[cmd]")) {
                TextAreaWidget.this.isInBatch = true;
            }
            TextAreaWidget.this.textArea.append("\n");
            try {
                if (!TextAreaWidget.this.isInBatch) {
                    TextAreaWidget.this.stdOut.write(TextAreaWidget.this.command, 0, TextAreaWidget.this.command.length());
                    TextAreaWidget.this.stdOut.write(10);
                    TextAreaWidget.this.stdOut.flush();
                }
                if (TextAreaWidget.this.command.length() > 0) {
                    TextAreaWidget.this.history.insertElementAt(new String(TextAreaWidget.this.command), 0);
                }
                TextAreaWidget.this.historyIndex = 0;
            }
            catch (IOException iOException) {
                TextAreaWidget.this.textArea.append("--- cannot execute: restart shell ---");
            }
            if (TextAreaWidget.this.command.endsWith("\n[/cmd]")) {
                TextAreaWidget.this.isInBatch = false;
                try {
                    TextAreaWidget.this.stdOut.write(TextAreaWidget.this.command, 0, TextAreaWidget.this.command.length());
                    TextAreaWidget.this.stdOut.write(10);
                    TextAreaWidget.this.stdOut.flush();
                }
                catch (IOException iOException) {
                    TextAreaWidget.this.textArea.append("--- cannot execute command batch ---");
                }
            }
        }
    }

    private class HistoryDownAction
    extends AbstractAction {
        public static final long serialVersionUID = 1L;

        private HistoryDownAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TextAreaWidget.this.textArea.setCaretPosition(TextAreaWidget.this.lastDot);
            TextAreaWidget.this.textArea.moveCaretPosition(TextAreaWidget.this.textArea.getText().length());
            TextAreaWidget.this.textArea.cut();
            if (TextAreaWidget.this.history.size() > 0) {
                TextAreaWidget.this.textArea.append((String)TextAreaWidget.this.history.elementAt(TextAreaWidget.this.historyIndex));
                if (TextAreaWidget.this.historyIndex > 0) {
                    --TextAreaWidget.this.historyIndex;
                }
            }
        }
    }

    private class HistoryUpAction
    extends AbstractAction {
        public static final long serialVersionUID = 1L;

        private HistoryUpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TextAreaWidget.this.textArea.setCaretPosition(TextAreaWidget.this.lastDot);
            TextAreaWidget.this.textArea.moveCaretPosition(TextAreaWidget.this.textArea.getText().length());
            TextAreaWidget.this.textArea.cut();
            if (TextAreaWidget.this.history.size() > 0) {
                TextAreaWidget.this.textArea.append((String)TextAreaWidget.this.history.elementAt(TextAreaWidget.this.historyIndex));
                if (TextAreaWidget.this.historyIndex < TextAreaWidget.this.history.size() - 1) {
                    ++TextAreaWidget.this.historyIndex;
                }
            }
        }
    }

    private class EndOfLineAction
    extends AbstractAction {
        public static final long serialVersionUID = 1L;

        private EndOfLineAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TextAreaWidget.this.textArea.setCaretPosition(TextAreaWidget.this.textArea.getText().length());
        }
    }

    private class BeginningOfLineAction
    extends AbstractAction {
        public static final long serialVersionUID = 1L;

        private BeginningOfLineAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TextAreaWidget.this.textArea.setCaretPosition(TextAreaWidget.this.lastDot);
        }
    }

    class stderrorListener
    implements Runnable {
        int len;
        char[] buff = new char[512];
        String str;
        String text;

        stderrorListener() {
        }

        public void run() {
            try {
                while ((this.len = TextAreaWidget.this.stdError.read(this.buff, 0, 512)) != -1) {
                    this.str = new String(this.buff, 0, this.len);
                    this.text = TextAreaWidget.this.textArea.getText();
                    if (this.text.length() > 100000) {
                        TextAreaWidget.this.textArea.setText(this.text.substring(50000));
                    }
                    TextAreaWidget.this.textArea.append(this.str);
                    TextAreaWidget.this.lastDot = TextAreaWidget.this.textArea.getText().length();
                    TextAreaWidget.this.textArea.setCaretPosition(TextAreaWidget.this.lastDot);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    class stdinListener
    implements Runnable {
        int len;
        char[] buff = new char[512];
        String str;
        String text;

        stdinListener() {
        }

        public void run() {
            try {
                while ((this.len = TextAreaWidget.this.stdInput.read(this.buff, 0, 512)) != -1) {
                    this.str = new String(this.buff, 0, this.len);
                    this.text = TextAreaWidget.this.textArea.getText();
                    if (this.text.length() > 100000) {
                        TextAreaWidget.this.textArea.setText(this.text.substring(50000));
                    }
                    TextAreaWidget.this.textArea.append(this.str);
                    TextAreaWidget.this.lastDot = TextAreaWidget.this.textArea.getText().length();
                    TextAreaWidget.this.textArea.setCaretPosition(TextAreaWidget.this.lastDot);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

