/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.ffi.jna;

import com.sun.jna.Function;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyString;
import org.jruby.nb.ext.ffi.FFIProvider;
import org.jruby.nb.ext.ffi.Invoker;
import org.jruby.nb.ext.ffi.NativeType;
import org.jruby.nb.ext.ffi.Platform;
import org.jruby.nb.ext.ffi.Util;
import org.jruby.nb.ext.ffi.jna.FunctionInvoker;
import org.jruby.nb.ext.ffi.jna.Invocation;
import org.jruby.nb.ext.ffi.jna.JNAInvoker;
import org.jruby.nb.ext.ffi.jna.JNAMemory;
import org.jruby.nb.ext.ffi.jna.JNAMemoryPointer;
import org.jruby.nb.ext.ffi.jna.Marshaller;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public final class JNAProvider
extends FFIProvider {
    JNAProvider(Ruby runtime) {
        super(runtime);
    }

    @Override
    public final Invoker createInvoker(Ruby runtime, String libraryName, String functionName, NativeType returnType, NativeType[] parameterTypes, String convention) {
        Function function = NativeLibrary.getInstance((String)libraryName).getFunction(functionName, "stdcall".equals(convention) ? 1 : 0);
        FunctionInvoker functionInvoker = this.getFunctionInvoker(returnType);
        Marshaller[] marshallers = new Marshaller[parameterTypes.length];
        for (int i = 0; i < marshallers.length; ++i) {
            marshallers[i] = JNAProvider.getMarshaller(parameterTypes[i]);
        }
        return new JNAInvoker(runtime, function, functionInvoker, marshallers);
    }

    @Override
    public int getLastError() {
        return Native.getLastError();
    }

    @Override
    public void setLastError(int error) {
        Native.setLastError((int)error);
    }

    private FunctionInvoker getFunctionInvoker(NativeType returnType) {
        switch (returnType) {
            case VOID: {
                return VoidInvoker.INSTANCE;
            }
            case POINTER: {
                return PointerInvoker.INSTANCE;
            }
            case INT8: 
            case INT16: 
            case INT32: {
                return Signed32Invoker.INSTANCE;
            }
            case UINT8: 
            case UINT16: 
            case UINT32: {
                return Unsigned32Invoker.INSTANCE;
            }
            case INT64: 
            case UINT64: {
                return Signed64Invoker.INSTANCE;
            }
            case LONG: {
                return Platform.getPlatform().addressSize() == 32 ? Signed32Invoker.INSTANCE : Signed64Invoker.INSTANCE;
            }
            case ULONG: {
                return Platform.getPlatform().addressSize() == 32 ? Unsigned32Invoker.INSTANCE : Signed64Invoker.INSTANCE;
            }
            case FLOAT32: {
                return Float32Invoker.INSTANCE;
            }
            case FLOAT64: {
                return Float64Invoker.INSTANCE;
            }
            case STRING: 
            case RBXSTRING: {
                return StringInvoker.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Invalid return type: " + (Object)((Object)returnType));
    }

    private static final Marshaller getMarshaller(NativeType type) {
        switch (type) {
            case INT8: {
                return Signed8Marshaller.INSTANCE;
            }
            case UINT8: {
                return Unsigned8Marshaller.INSTANCE;
            }
            case INT16: {
                return Signed16Marshaller.INSTANCE;
            }
            case UINT16: {
                return Unsigned16Marshaller.INSTANCE;
            }
            case INT32: {
                return Signed32Marshaller.INSTANCE;
            }
            case UINT32: {
                return Unsigned32Marshaller.INSTANCE;
            }
            case INT64: {
                return Signed64Marshaller.INSTANCE;
            }
            case UINT64: {
                return Unsigned64Marshaller.INSTANCE;
            }
            case LONG: {
                return Platform.getPlatform().longSize() == 32 ? Signed32Marshaller.INSTANCE : Signed64Marshaller.INSTANCE;
            }
            case ULONG: {
                return Platform.getPlatform().longSize() == 32 ? Signed32Marshaller.INSTANCE : Signed64Marshaller.INSTANCE;
            }
            case FLOAT32: {
                return Float32Marshaller.INSTANCE;
            }
            case FLOAT64: {
                return Float64Marshaller.INSTANCE;
            }
            case STRING: {
                return StringMarshaller.INSTANCE;
            }
            case RBXSTRING: {
                return RbxStringMarshaller.INSTANCE;
            }
            case POINTER: {
                return PointerMarshaller.INSTANCE;
            }
            case BUFFER_IN: 
            case BUFFER_OUT: 
            case BUFFER_INOUT: {
                return BufferMarshaller.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Invalid parameter type: " + (Object)((Object)type));
    }

    private static final class BufferMarshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new BufferMarshaller();

        private BufferMarshaller() {
        }

        @Override
        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            if (parameter instanceof JNAMemory) {
                return ((JNAMemory)((Object)parameter)).getNativeMemory();
            }
            if (parameter.isNil()) {
                return Pointer.NULL;
            }
            if (parameter instanceof RubyString) {
                ByteList bl = ((RubyString)parameter).getByteList();
                return ByteBuffer.wrap(bl.unsafeBytes(), bl.begin(), bl.realSize);
            }
            return Util.convertParameter(parameter, Object.class);
        }
    }

    private static final class RbxStringMarshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new RbxStringMarshaller();

        private RbxStringMarshaller() {
        }

        @Override
        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            final ByteList bl = parameter.asString().getByteList();
            final int strlen = bl.length();
            final Memory memory = new Memory((long)(strlen + 1));
            memory.write(0L, bl.unsafeBytes(), bl.begin(), strlen);
            memory.setByte((long)bl.length(), (byte)0);
            invocation.addPostInvoke(new Runnable(){

                @Override
                public void run() {
                    memory.read(0L, bl.unsafeBytes(), bl.begin(), strlen);
                }
            });
            return memory;
        }
    }

    private static final class StringMarshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new StringMarshaller();

        private StringMarshaller() {
        }

        @Override
        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            RubyString s = parameter.asString();
            ByteList bl = s.getByteList();
            Memory memory = new Memory((long)(bl.length() + 1));
            memory.write(0L, bl.unsafeBytes(), bl.begin(), bl.length());
            memory.setByte((long)bl.length(), (byte)0);
            return memory;
        }
    }

    private static final class PointerMarshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new PointerMarshaller();

        private PointerMarshaller() {
        }

        @Override
        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            if (parameter instanceof JNAMemory) {
                return ((JNAMemory)((Object)parameter)).getNativeMemory();
            }
            if (parameter.isNil()) {
                return Pointer.NULL;
            }
            if (parameter instanceof RubyString) {
                final ByteList bl = ((RubyString)parameter).getByteList();
                final int len = bl.length();
                final Memory memory = new Memory((long)len);
                memory.write(0L, bl.unsafeBytes(), bl.begin(), len);
                invocation.addPostInvoke(new Runnable(){

                    @Override
                    public void run() {
                        memory.read(0L, bl.unsafeBytes(), bl.begin(), len);
                    }
                });
                return memory;
            }
            return Util.convertParameter(parameter, Pointer.class);
        }
    }

    private static final class Float64Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Float64Marshaller();

        private Float64Marshaller() {
        }

        @Override
        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            return Util.doubleValue(parameter);
        }
    }

    private static final class Float32Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Float32Marshaller();

        private Float32Marshaller() {
        }

        @Override
        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            return Float.valueOf(Util.floatValue(parameter));
        }
    }

    private static final class Unsigned64Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Unsigned64Marshaller();

        private Unsigned64Marshaller() {
        }

        @Override
        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            return Util.uint64Value(parameter);
        }
    }

    private static final class Signed64Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Signed64Marshaller();

        private Signed64Marshaller() {
        }

        @Override
        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            return Util.int64Value(parameter);
        }
    }

    private static final class Unsigned32Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Unsigned32Marshaller();

        private Unsigned32Marshaller() {
        }

        @Override
        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            return (int)Util.uint32Value(parameter);
        }
    }

    private static final class Signed32Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Signed32Marshaller();

        private Signed32Marshaller() {
        }

        @Override
        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            return Util.int32Value(parameter);
        }
    }

    private static final class Unsigned16Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Unsigned16Marshaller();

        private Unsigned16Marshaller() {
        }

        @Override
        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            return (short)Util.uint16Value(parameter);
        }
    }

    private static final class Signed16Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Signed16Marshaller();

        private Signed16Marshaller() {
        }

        @Override
        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            return Util.int16Value(parameter);
        }
    }

    private static final class Unsigned8Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Unsigned8Marshaller();

        private Unsigned8Marshaller() {
        }

        @Override
        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            return (byte)Util.uint8Value(parameter);
        }
    }

    private static final class Signed8Marshaller
    implements Marshaller {
        public static final Marshaller INSTANCE = new Signed8Marshaller();

        private Signed8Marshaller() {
        }

        @Override
        public final Object marshal(Invocation invocation, IRubyObject parameter) {
            return Util.int8Value(parameter);
        }
    }

    private static final class StringInvoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new StringInvoker();

        private StringInvoker() {
        }

        @Override
        public final IRubyObject invoke(Ruby runtime, Function function, Object[] args) {
            Pointer address = function.invokePointer(args);
            if (address == null) {
                return runtime.getNil();
            }
            int len = (int)address.indexOf(0L, (byte)0);
            if (len == 0) {
                return RubyString.newEmptyString(runtime);
            }
            ByteList bl = new ByteList(len);
            bl.length(len);
            address.read(0L, bl.unsafeBytes(), bl.begin(), len);
            return RubyString.newString(runtime, bl);
        }
    }

    private static final class PointerInvoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new PointerInvoker();

        private PointerInvoker() {
        }

        @Override
        public final IRubyObject invoke(Ruby runtime, Function function, Object[] args) {
            return new JNAMemoryPointer(runtime, function.invokePointer(args));
        }
    }

    private static final class Float64Invoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new Float64Invoker();

        private Float64Invoker() {
        }

        @Override
        public final IRubyObject invoke(Ruby runtime, Function function, Object[] args) {
            return runtime.newFloat(function.invokeDouble(args));
        }
    }

    private static final class Float32Invoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new Float32Invoker();

        private Float32Invoker() {
        }

        @Override
        public final IRubyObject invoke(Ruby runtime, Function function, Object[] args) {
            return runtime.newFloat(function.invokeFloat(args));
        }
    }

    private static final class Signed64Invoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new Signed64Invoker();

        private Signed64Invoker() {
        }

        @Override
        public final IRubyObject invoke(Ruby runtime, Function function, Object[] args) {
            return runtime.newFixnum(function.invokeLong(args));
        }
    }

    private static final class Unsigned32Invoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new Unsigned32Invoker();

        private Unsigned32Invoker() {
        }

        @Override
        public final IRubyObject invoke(Ruby runtime, Function function, Object[] args) {
            long value = function.invokeInt(args);
            return runtime.newFixnum(value < 0L ? (value & Integer.MAX_VALUE) + 0x80000000L : value);
        }
    }

    private static final class Signed32Invoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new Signed32Invoker();

        private Signed32Invoker() {
        }

        @Override
        public final IRubyObject invoke(Ruby runtime, Function function, Object[] args) {
            return runtime.newFixnum(function.invokeInt(args));
        }
    }

    private static final class VoidInvoker
    implements FunctionInvoker {
        public static final FunctionInvoker INSTANCE = new VoidInvoker();

        private VoidInvoker() {
        }

        @Override
        public final IRubyObject invoke(Ruby runtime, Function function, Object[] args) {
            function.invoke(args);
            return runtime.getNil();
        }
    }
}

