/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.compiler.impl;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.compiler.ArrayCallback;
import org.jruby.nb.compiler.CompilerCallback;
import org.jruby.nb.compiler.VariableCompiler;
import org.jruby.nb.compiler.impl.SkinnyMethodAdapter;
import org.jruby.nb.compiler.impl.StandardASMCompiler;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.DynamicScope;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.CodegenUtils;
import org.objectweb.asm.Label;

public abstract class AbstractVariableCompiler
implements VariableCompiler {
    protected SkinnyMethodAdapter method;
    protected StandardASMCompiler.AbstractMethodCompiler methodCompiler;
    protected int argsIndex;
    protected int tempVariableIndex;
    protected Arity arity;
    protected StaticScope scope;
    protected boolean specificArity;

    public AbstractVariableCompiler(StandardASMCompiler.AbstractMethodCompiler methodCompiler, SkinnyMethodAdapter method, StaticScope scope, boolean specificArity, int argsIndex, int firstTempIndex) {
        this.methodCompiler = methodCompiler;
        this.method = method;
        this.argsIndex = argsIndex;
        this.tempVariableIndex = firstTempIndex;
        this.scope = scope;
        this.specificArity = specificArity;
    }

    @Override
    public SkinnyMethodAdapter getMethodAdapter() {
        return this.method;
    }

    @Override
    public void setMethodAdapter(SkinnyMethodAdapter sma) {
        this.method = sma;
    }

    @Override
    public void assignLastLine() {
        this.methodCompiler.loadRuntime();
        this.method.swap();
        this.methodCompiler.loadThreadContext();
        this.method.swap();
        this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "setLastLine", CodegenUtils.sig(IRubyObject.class, Ruby.class, ThreadContext.class, IRubyObject.class));
    }

    @Override
    public void assignLastLine(CompilerCallback value) {
        this.methodCompiler.loadRuntime();
        this.methodCompiler.loadThreadContext();
        value.call(this.methodCompiler);
        this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "setLastLine", CodegenUtils.sig(IRubyObject.class, Ruby.class, ThreadContext.class, IRubyObject.class));
    }

    @Override
    public void retrieveLastLine() {
        this.methodCompiler.loadRuntime();
        this.methodCompiler.loadThreadContext();
        this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "getLastLine", CodegenUtils.sig(IRubyObject.class, Ruby.class, ThreadContext.class));
    }

    @Override
    public void assignBackRef() {
        this.methodCompiler.loadRuntime();
        this.method.swap();
        this.methodCompiler.loadThreadContext();
        this.method.swap();
        this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "setBackref", CodegenUtils.sig(IRubyObject.class, Ruby.class, ThreadContext.class, IRubyObject.class));
    }

    @Override
    public void assignBackRef(CompilerCallback value) {
        this.methodCompiler.loadRuntime();
        this.methodCompiler.loadThreadContext();
        value.call(this.methodCompiler);
        this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "setBackref", CodegenUtils.sig(IRubyObject.class, Ruby.class, ThreadContext.class, IRubyObject.class));
    }

    @Override
    public void retrieveBackRef() {
        this.methodCompiler.loadRuntime();
        this.methodCompiler.loadThreadContext();
        this.method.invokestatic(CodegenUtils.p(RuntimeHelpers.class), "getBackref", CodegenUtils.sig(IRubyObject.class, Ruby.class, ThreadContext.class));
    }

    @Override
    public void checkMethodArity(int requiredArgs, int optArgs, int restArg) {
        Label arityError = new Label();
        Label noArityError = new Label();
        if (!this.specificArity) {
            boolean needsError = false;
            if (restArg != -1) {
                if (requiredArgs > 0) {
                    needsError = true;
                    this.method.aload(this.argsIndex);
                    this.method.arraylength();
                    this.method.pushInt(requiredArgs);
                    this.method.if_icmplt(arityError);
                }
            } else if (optArgs > 0) {
                needsError = true;
                if (requiredArgs > 0) {
                    this.method.aload(this.argsIndex);
                    this.method.arraylength();
                    this.method.pushInt(requiredArgs);
                    this.method.if_icmplt(arityError);
                }
                this.method.aload(this.argsIndex);
                this.method.arraylength();
                this.method.pushInt(requiredArgs + optArgs);
                this.method.if_icmpgt(arityError);
            } else {
                needsError = true;
                this.method.aload(this.argsIndex);
                this.method.arraylength();
                this.method.pushInt(requiredArgs);
                this.method.if_icmpne(arityError);
            }
            if (needsError) {
                this.method.go_to(noArityError);
                this.method.label(arityError);
                this.methodCompiler.loadRuntime();
                this.method.aload(this.argsIndex);
                this.method.pushInt(requiredArgs);
                this.method.pushInt(requiredArgs + optArgs);
                this.method.invokestatic(CodegenUtils.p(Arity.class), "checkArgumentCount", CodegenUtils.sig(Integer.TYPE, Ruby.class, IRubyObject[].class, Integer.TYPE, Integer.TYPE));
                this.method.pop();
                this.method.label(noArityError);
            }
        }
    }

    @Override
    public void assignMethodArguments(Object requiredArgs, int requiredArgsCount, Object optArgs, int optArgsCount, ArrayCallback requiredAssignment, ArrayCallback optGivenAssignment, ArrayCallback optNotGivenAssignment, CompilerCallback restAssignment, CompilerCallback blockAssignment) {
        if (this.specificArity) {
            for (int currentArgElement = 0; currentArgElement < this.scope.getRequiredArgs(); ++currentArgElement) {
                this.method.aload(this.argsIndex + currentArgElement);
                requiredAssignment.nextValue(this.methodCompiler, requiredArgs, currentArgElement);
                this.method.pop();
            }
        } else if (requiredArgsCount > 0 || optArgsCount > 0 || restAssignment != null) {
            int currentArgElement;
            this.method.aload(this.argsIndex);
            for (currentArgElement = 0; currentArgElement < requiredArgsCount; ++currentArgElement) {
                this.method.dup();
                this.method.pushInt(currentArgElement);
                this.method.arrayload();
                requiredAssignment.nextValue(this.methodCompiler, requiredArgs, currentArgElement);
                this.method.pop();
            }
            for (int optArgElement = 0; optArgElement < optArgsCount; ++optArgElement) {
                Label noMoreArrayElements = new Label();
                Label doneWithElement = new Label();
                this.method.dup();
                this.method.arraylength();
                this.method.pushInt(currentArgElement);
                this.method.if_icmple(noMoreArrayElements);
                this.method.dup();
                this.method.pushInt(currentArgElement);
                this.method.arrayload();
                optGivenAssignment.nextValue(this.methodCompiler, optArgs, optArgElement);
                this.method.go_to(doneWithElement);
                this.method.label(noMoreArrayElements);
                optNotGivenAssignment.nextValue(this.methodCompiler, optArgs, optArgElement);
                this.method.label(doneWithElement);
                this.method.pop();
                ++currentArgElement;
            }
            if (restAssignment != null) {
                Label emptyArray = new Label();
                Label readyForArgs = new Label();
                this.method.dup();
                this.method.arraylength();
                this.method.pushInt(currentArgElement);
                this.method.if_icmple(emptyArray);
                this.method.dup();
                this.methodCompiler.loadRuntime();
                this.method.pushInt(currentArgElement);
                this.methodCompiler.invokeUtilityMethod("createSubarray", CodegenUtils.sig(RubyArray.class, IRubyObject[].class, Ruby.class, Integer.TYPE));
                this.method.go_to(readyForArgs);
                this.method.label(emptyArray);
                this.methodCompiler.createEmptyArray();
                this.method.label(readyForArgs);
                restAssignment.call(this.methodCompiler);
                this.method.pop();
            }
            this.method.pop();
        }
        if (blockAssignment != null) {
            this.methodCompiler.loadRuntime();
            this.method.aload(this.methodCompiler.getClosureIndex());
            this.methodCompiler.invokeUtilityMethod("processBlockArgument", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Ruby.class, Block.class)));
            blockAssignment.call(this.methodCompiler);
            this.method.pop();
        }
    }

    @Override
    public int grabTempLocal() {
        return this.tempVariableIndex++;
    }

    @Override
    public void setTempLocal(int index) {
        this.method.astore(index);
    }

    @Override
    public void getTempLocal(int index) {
        this.method.aload(index);
    }

    @Override
    public void releaseTempLocal() {
        --this.tempVariableIndex;
    }

    protected void assignHeapLocal(CompilerCallback value, int depth, int index) {
        switch (index) {
            case 0: {
                this.unwrapParentScopes(depth);
                value.call(this.methodCompiler);
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueZeroDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            case 1: {
                this.unwrapParentScopes(depth);
                value.call(this.methodCompiler);
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueOneDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            case 2: {
                this.unwrapParentScopes(depth);
                value.call(this.methodCompiler);
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueTwoDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            case 3: {
                this.unwrapParentScopes(depth);
                value.call(this.methodCompiler);
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueThreeDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            default: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                this.method.pushInt(index);
                value.call(this.methodCompiler);
                this.method.pushInt(depth);
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValue", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Integer.TYPE, IRubyObject.class, Integer.TYPE)));
            }
        }
    }

    protected void assignHeapLocal(int depth, int index) {
        switch (index) {
            case 0: {
                this.unwrapParentScopes(depth);
                this.method.swap();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueZeroDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            case 1: {
                this.unwrapParentScopes(depth);
                this.method.swap();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueOneDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            case 2: {
                this.unwrapParentScopes(depth);
                this.method.swap();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueTwoDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            case 3: {
                this.unwrapParentScopes(depth);
                this.method.swap();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValueThreeDepthZero", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
                break;
            }
            default: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                this.method.swap();
                this.method.pushInt(index);
                this.method.pushInt(depth);
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "setValue", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class, Integer.TYPE, Integer.TYPE)));
            }
        }
    }

    protected void retrieveHeapLocal(int depth, int index) {
        switch (index) {
            case 0: {
                this.unwrapParentScopes(depth);
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueZeroDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            case 1: {
                this.unwrapParentScopes(depth);
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueOneDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            case 2: {
                this.unwrapParentScopes(depth);
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueTwoDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            case 3: {
                this.unwrapParentScopes(depth);
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueThreeDepthZeroOrNil", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
                break;
            }
            default: {
                this.method.aload(this.methodCompiler.getDynamicScopeIndex());
                this.method.pushInt(index);
                this.method.pushInt(depth);
                this.methodCompiler.loadNil();
                this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getValueOrNil", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(Integer.TYPE, Integer.TYPE, IRubyObject.class)));
            }
        }
    }

    protected void unwrapParentScopes(int depth) {
        this.method.aload(this.methodCompiler.getDynamicScopeIndex());
        while (depth > 0) {
            this.method.invokevirtual(CodegenUtils.p(DynamicScope.class), "getNextCapturedScope", CodegenUtils.sig(DynamicScope.class, new Class[0]));
            --depth;
        }
    }
}

