/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import org.mozilla.nb.javascript.FunctionNode;
import org.mozilla.nb.javascript.Node;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.StructureItem;
import org.netbeans.modules.csl.api.StructureScanner;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript.editing.AstElement;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.FunctionAstElement;
import org.netbeans.modules.javascript.editing.GlobalAstElement;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.JsParser;
import org.netbeans.modules.javascript.editing.JsUtils;
import org.netbeans.modules.javascript.editing.ParseTreeVisitor;
import org.netbeans.modules.javascript.editing.ParseTreeWalker;
import org.netbeans.modules.javascript.editing.VariableVisitor;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.util.Exceptions;

public class JsAnalyzer
implements StructureScanner {
    public static final String NETBEANS_IMPORT_FILE = "__netbeans_import__";
    private static final String DOT_CALL = ".call";

    public List<? extends StructureItem> scan(ParserResult parserResult) {
        Object object;
        List<Object> list;
        Object object2;
        JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)parserResult);
        AnalysisResult analysisResult = jsParseResult.getStructure();
        List<? extends AstElement> list2 = analysisResult.getElements();
        ArrayList<Object> arrayList = new ArrayList<Object>(list2.size());
        HashMap hashMap = new HashMap();
        ArrayList<AstElement> arrayList2 = new ArrayList<AstElement>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        for (AstElement object3 : list2) {
            object2 = object3.getIn();
            if (object3.getKind() == ElementKind.CLASS) {
                object2 = object2 != null && ((String)object2).length() > 0 ? (String)object2 + "." + object3.getName() : object3.getName();
            } else if (object3.getKind() == ElementKind.CONSTRUCTOR && Character.isUpperCase(object3.getName().charAt(0))) {
                object2 = object3.getIn() != null && object3.getIn().length() > 0 ? object3.getIn() + "." + object3.getName() : object3.getName();
            }
            if (object2 != null && ((String)object2).length() > 0) {
                list = (List)hashMap.get(object2);
                if (list == null) {
                    list = new ArrayList();
                    hashMap.put(object2, list);
                    arrayList3.add(object2);
                }
                list.add(object3);
                continue;
            }
            arrayList2.add(object3);
        }
        for (AstElement astElement : arrayList2) {
            if (astElement.getKind() == ElementKind.CONSTRUCTOR) {
                object2 = astElement.getName();
                list = (ArrayList<AstElement>)hashMap.get(object2);
                if (list == null) {
                    list = new ArrayList<AstElement>();
                    hashMap.put(object2, list);
                    arrayList3.add(object2);
                }
                list.add(astElement);
                continue;
            }
            object2 = new JsStructureItem(astElement, jsParseResult);
            arrayList.add(object2);
        }
        for (String string : arrayList3) {
            object2 = (List)hashMap.get(string);
            assert (object2 != null);
            list = (AstElement)object2.get(0);
            object = new JsFakeStructureItem(string, ElementKind.CLASS, (AstElement)((Object)list), jsParseResult);
            arrayList.add(object);
            int n = ((AstElement)((Object)list)).getNode().getSourceStart();
            int n2 = ((AstElement)((Object)list)).getNode().getSourceEnd();
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Object object3;
                AstElement astElement = (AstElement)iterator.next();
                if (astElement.getKind() != ElementKind.CLASS) {
                    object3 = new JsStructureItem(astElement, jsParseResult);
                    ((JsFakeStructureItem)object).addChild((StructureItem)object3);
                } else {
                    ((JsFakeStructureItem)object).element = astElement;
                }
                object3 = astElement.getNode();
                if (object3.getSourceStart() < n) {
                    n = object3.getSourceStart();
                }
                if (object3.getSourceEnd() <= n2) continue;
                n2 = object3.getSourceEnd();
            }
            object.begin = LexUtilities.getLexerOffset(jsParseResult, n);
            object.end = LexUtilities.getLexerOffset(jsParseResult, n2);
        }
        if (analysisResult.e4xStrings != null) {
            for (Node node : analysisResult.e4xStrings) {
                object2 = node.getString();
                int n = LexUtilities.getLexerOffset(jsParseResult, node.getSourceStart());
                if (n == -1) {
                    n = node.getSourceStart();
                }
                if ((object = XmlStructureItem.get((String)object2, n)) == null) continue;
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    public Map<String, List<OffsetRange>> folds(ParserResult parserResult) {
        JsParseResult jsParseResult = AstUtilities.getParseResult((Parser.Result)parserResult);
        AnalysisResult analysisResult = jsParseResult.getStructure();
        List<? extends AstElement> list = analysisResult.getElements();
        HashMap<String, List<OffsetRange>> hashMap = new HashMap<String, List<OffsetRange>>();
        ArrayList<OffsetRange> arrayList = new ArrayList<OffsetRange>();
        hashMap.put("codeblocks", arrayList);
        CharSequence charSequence = parserResult.getSnapshot().getText();
        try {
            for (AstElement astElement : list) {
                ElementKind elementKind = astElement.getKind();
                switch (elementKind) {
                    case METHOD: 
                    case CONSTRUCTOR: 
                    case CLASS: 
                    case MODULE: {
                        int n;
                        int n2;
                        Node node = astElement.getNode();
                        OffsetRange offsetRange = AstUtilities.getRange(node);
                        if (elementKind != ElementKind.METHOD && elementKind != ElementKind.CONSTRUCTOR && offsetRange.getStart() <= GsfUtilities.getRowStart((CharSequence)charSequence, (int)Math.min(offsetRange.getStart(), charSequence.length()))) break;
                        int n3 = offsetRange.getStart();
                        int n4 = n3 = GsfUtilities.getRowEnd((CharSequence)charSequence, (int)Math.min(n3, charSequence.length()));
                        if (n4 >= charSequence.length()) break;
                        char c = charSequence.charAt(n4);
                        if (c == '\n') {
                            --n4;
                        }
                        do {
                            c = charSequence.charAt(n4);
                        } while (--n4 > 0 && c != '\n' && c != '{');
                        if (c == '{') {
                            n3 = n4 + 1;
                        }
                        int n5 = offsetRange.getEnd();
                        if (n3 == -1 || n5 == -1 || n3 >= n5 || n5 > charSequence.length() || (n2 = jsParseResult.getSnapshot().getOriginalOffset(n3)) >= (n = jsParseResult.getSnapshot().getOriginalOffset(n5))) break;
                        offsetRange = new OffsetRange(n2, n);
                        arrayList.add(offsetRange);
                        break;
                    }
                }
                assert (astElement.getChildren().size() == 0);
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        return hashMap;
    }

    static AnalysisResult analyze(JsParseResult jsParseResult) {
        AnalysisResult analysisResult = new AnalysisResult(jsParseResult);
        ParseTreeWalker parseTreeWalker = new ParseTreeWalker(analysisResult);
        Node node = jsParseResult.getRootNode();
        if (Boolean.getBoolean("debug.js.ast")) {
            JsParser.dumpTree(node);
        }
        if (node != null) {
            parseTreeWalker.walk(node);
        }
        analysisResult.postProcess(jsParseResult);
        return analysisResult;
    }

    public StructureScanner.Configuration getConfiguration() {
        return null;
    }

    public static class XmlStructureItem
    implements StructureItem {
        private List<XmlStructureItem> children = new ArrayList<XmlStructureItem>();
        private String name;
        private long start;
        private long end;

        public XmlStructureItem(String string, long l, long l2) {
            this.name = string;
            this.start = l;
            this.end = l2;
        }

        public static XmlStructureItem get(String string, int n) {
            int n2 = 0;
            XmlStructureItem xmlStructureItem = null;
            XmlStructureItem xmlStructureItem2 = null;
            int n3 = 0;
            ArrayList<XmlStructureItem> arrayList = new ArrayList<XmlStructureItem>();
            int n4 = string.length();
            for (int i = 0; i < n4; ++i) {
                Object object;
                char c = string.charAt(i);
                if (n3 == 0) {
                    if (c != '<') continue;
                    if (i < n4 - 1 && string.charAt(i + 1) == '/') {
                        n2 = i + 2;
                        ++i;
                        n3 = 2;
                        continue;
                    }
                    n2 = i + 1;
                    n3 = 1;
                    continue;
                }
                if (n3 == 1) {
                    if (Character.isLetterOrDigit(c) || c == '_' || c == ':') continue;
                    object = string.substring(n2, i);
                    XmlStructureItem xmlStructureItem3 = new XmlStructureItem((String)object, n2 - 1 + n, i + n);
                    if (!arrayList.isEmpty()) {
                        ((XmlStructureItem)arrayList.get((int)(arrayList.size() - 1))).children.add(xmlStructureItem3);
                    }
                    arrayList.add(xmlStructureItem3);
                    if (xmlStructureItem == null) {
                        xmlStructureItem = xmlStructureItem3;
                    }
                    xmlStructureItem2 = xmlStructureItem3;
                    if (c == '>') {
                        n3 = 0;
                        continue;
                    }
                    n3 = 3;
                    continue;
                }
                if (n3 == 2) {
                    if (Character.isLetterOrDigit(c) || c == '_' || c == ':') continue;
                    if (!arrayList.isEmpty()) {
                        object = (XmlStructureItem)arrayList.get(arrayList.size() - 1);
                        if (((XmlStructureItem)object).end < (long)(n + i + 1)) {
                            ((XmlStructureItem)object).end = n + i + 1;
                        }
                        arrayList.remove(arrayList.size() - 1);
                    }
                    if (c == '>') {
                        n3 = 0;
                        continue;
                    }
                    n3 = 4;
                    continue;
                }
                if (n3 == 3) {
                    if (c != '>') continue;
                    n3 = 0;
                    if (i <= 0 || string.charAt(i - 1) != '/') continue;
                    if (xmlStructureItem2 != null) {
                        xmlStructureItem2.end = n + i + 1;
                        xmlStructureItem2 = null;
                    }
                    if (arrayList.isEmpty()) continue;
                    arrayList.remove(arrayList.size() - 1);
                    continue;
                }
                if (n3 == 4) {
                    if (c == '>') {
                        n3 = 0;
                    }
                    if (xmlStructureItem2 == null) continue;
                    xmlStructureItem2.end = n + i + 1;
                    xmlStructureItem2 = null;
                    continue;
                }
                assert (false) : n3;
            }
            return xmlStructureItem;
        }

        public String getName() {
            return this.name;
        }

        public String getSortText() {
            return this.name;
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.reset();
            htmlFormatter.appendText(this.name);
            return htmlFormatter.getText();
        }

        public ElementHandle getElementHandle() {
            return null;
        }

        public ElementKind getKind() {
            return ElementKind.TAG;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isLeaf() {
            return this.children.size() == 0;
        }

        public List<? extends StructureItem> getNestedItems() {
            return this.children;
        }

        public long getPosition() {
            return this.start;
        }

        public long getEndPosition() {
            return this.end;
        }

        public ImageIcon getCustomIcon() {
            return null;
        }
    }

    private class JsStructureItem
    implements StructureItem {
        private AstElement element;
        private ElementKind kind;
        private JsParseResult info;
        private String name;

        private JsStructureItem(AstElement astElement, JsParseResult jsParseResult) {
            this.element = astElement;
            this.info = jsParseResult;
            this.kind = astElement.getKind();
        }

        void setKind(ElementKind elementKind) {
            this.kind = elementKind;
        }

        void setName(String string) {
            this.name = string;
        }

        public String getName() {
            if (this.name == null) {
                this.name = this.element.getName();
            }
            return this.name;
        }

        public String getSortText() {
            return this.getName();
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            FunctionAstElement functionAstElement;
            List<String> list;
            boolean bl = this.element.getModifiers().contains(Modifier.DEPRECATED);
            if (bl) {
                htmlFormatter.deprecated(true);
            }
            htmlFormatter.appendText(this.getName());
            if (bl) {
                htmlFormatter.deprecated(false);
            }
            if (this.element instanceof FunctionAstElement && (list = (functionAstElement = (FunctionAstElement)this.element).getParameters()) != null && list.size() > 0) {
                htmlFormatter.appendHtml("(");
                htmlFormatter.parameters(true);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    htmlFormatter.appendText(string);
                    if (!iterator.hasNext()) continue;
                    htmlFormatter.appendHtml(", ");
                }
                htmlFormatter.parameters(false);
                htmlFormatter.appendHtml(")");
            }
            if (this.element.getType() != null && this.element.getType() != Node.UNKNOWN_TYPE) {
                htmlFormatter.appendHtml(" : ");
                htmlFormatter.appendText(JsUtils.normalizeTypeString(this.element.getType()));
            }
            return htmlFormatter.getText();
        }

        public ElementHandle getElementHandle() {
            return this.element;
        }

        public ElementKind getKind() {
            return this.kind;
        }

        public Set<Modifier> getModifiers() {
            return this.element.getModifiers();
        }

        public boolean isLeaf() {
            switch (this.kind) {
                case METHOD: 
                case CONSTRUCTOR: 
                case ATTRIBUTE: 
                case CONSTANT: 
                case FIELD: 
                case KEYWORD: 
                case VARIABLE: 
                case OTHER: 
                case GLOBAL: 
                case PACKAGE: 
                case PROPERTY: {
                    return true;
                }
                case CLASS: 
                case MODULE: {
                    return false;
                }
            }
            throw new RuntimeException("Unhandled kind: " + this.kind);
        }

        public List<? extends StructureItem> getNestedItems() {
            List<AstElement> list = this.element.getChildren();
            if (list != null && list.size() > 0) {
                ArrayList<JsStructureItem> arrayList = new ArrayList<JsStructureItem>(list.size());
                for (AstElement astElement : list) {
                    arrayList.add(new JsStructureItem(astElement, this.info));
                }
                return arrayList;
            }
            return Collections.emptyList();
        }

        public long getPosition() {
            return LexUtilities.getLexerOffset(this.info, this.element.getNode().getSourceStart());
        }

        public long getEndPosition() {
            return LexUtilities.getLexerOffset(this.info, this.element.getNode().getSourceEnd());
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof JsStructureItem)) {
                return false;
            }
            JsStructureItem jsStructureItem = (JsStructureItem)object;
            if (this.kind != jsStructureItem.kind) {
                return false;
            }
            return this.getName().equals(jsStructureItem.getName());
        }

        public int hashCode() {
            int n = 7;
            n = 29 * n + (this.getName() != null ? this.getName().hashCode() : 0);
            n = 29 * n + (this.kind != null ? this.kind.hashCode() : 0);
            return n;
        }

        public String toString() {
            return this.getName();
        }

        public ImageIcon getCustomIcon() {
            return null;
        }
    }

    class JsFakeStructureItem
    implements StructureItem {
        private String name;
        private AstElement element;
        private ElementKind kind;
        private JsParseResult info;
        List<StructureItem> children = new ArrayList<StructureItem>();
        int begin;
        int end;

        JsFakeStructureItem(String string, ElementKind elementKind, AstElement astElement, JsParseResult jsParseResult) {
            this.name = string;
            this.kind = elementKind;
            this.element = astElement;
            this.info = jsParseResult;
        }

        private void addChild(StructureItem structureItem) {
            this.children.add(structureItem);
        }

        public String getName() {
            return this.name;
        }

        public String getSortText() {
            return this.getName();
        }

        public String getHtml(HtmlFormatter htmlFormatter) {
            htmlFormatter.appendText(this.name);
            return htmlFormatter.getText();
        }

        public ElementHandle getElementHandle() {
            return this.element;
        }

        public ElementKind getKind() {
            return this.kind;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean isLeaf() {
            return this.children.size() == 0;
        }

        public List<? extends StructureItem> getNestedItems() {
            return this.children;
        }

        public long getPosition() {
            return this.begin;
        }

        public long getEndPosition() {
            return this.end;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof JsFakeStructureItem)) {
                return false;
            }
            JsFakeStructureItem jsFakeStructureItem = (JsFakeStructureItem)object;
            if (this.kind != jsFakeStructureItem.kind) {
                return false;
            }
            if (!this.getName().equals(jsFakeStructureItem.getName())) {
                return false;
            }
            return this.isLeaf() == jsFakeStructureItem.isLeaf();
        }

        public int hashCode() {
            int n = 7;
            n = 29 * n + (this.getName() != null ? this.getName().hashCode() : 0);
            n = 29 * n + (this.kind != null ? this.kind.hashCode() : 0);
            return n;
        }

        public String toString() {
            return this.getName();
        }

        public ImageIcon getCustomIcon() {
            return null;
        }
    }

    public static class AnalysisResult
    implements ParseTreeVisitor {
        private List<AstElement> elements = new ArrayList<AstElement>();
        private List<String> imports;
        private JsParseResult info;
        private Map<String, String> classExtends;
        private Set<String> fields;
        private Node inConstructor;
        private Node currentFunction;
        private Map<String, String> classToFqn;
        private List<Node> e4xStrings;

        private AnalysisResult(JsParseResult jsParseResult) {
            this.info = jsParseResult;
        }

        void addNameSpace(String string, String string2) {
            if (this.classToFqn == null) {
                this.classToFqn = new HashMap<String, String>();
            }
            this.classToFqn.put(string, string2);
        }

        String getNameSpace(String string) {
            if (this.classToFqn != null) {
                return this.classToFqn.get(string);
            }
            return null;
        }

        String getExtends(String string) {
            if (this.classExtends != null) {
                return this.classExtends.get(string);
            }
            return null;
        }

        Map<String, String> getExtendsMap() {
            return this.classExtends;
        }

        void addSuperClass(String string, String string2) {
            if (this.classExtends == null) {
                this.classExtends = new HashMap<String, String>();
            }
            this.classExtends.put(string.toString(), string2.toString());
        }

        @Override
        public boolean visit(Node node) {
            block0 : switch (node.getType()) {
                case 41: {
                    CharSequence charSequence;
                    StringBuilder stringBuilder;
                    Node node2;
                    Node node3;
                    Node node4;
                    String string;
                    Node node5;
                    if (node.getString().equalsIgnoreCase("prototype") && (node5 = node.getParentNode()).getType() == 33 && (string = node5.getFirstChild()).getType() == 39 && (node4 = node5.getParentNode()).getType() == 35) {
                        node3 = node5.getNext();
                        if (node3 == null || node3 == null || !Character.isLowerCase(node3.getString().charAt(0)) || (node2 = node3.getNext()) != null && node2.getType() == 108) break;
                        if (node3.getType() == 41 && AstUtilities.addName(stringBuilder = new StringBuilder(), (Node)string)) {
                            int n;
                            charSequence = stringBuilder.toString();
                            String string2 = node3.getString();
                            String string3 = (String)charSequence + "." + string2;
                            if ((this.fields == null || !this.fields.contains(string3)) && (n = ((String)charSequence).lastIndexOf(46) + 1) < ((String)charSequence).length() && Character.isUpperCase(((String)charSequence).charAt(n))) {
                                String string4 = string2;
                                CharSequence charSequence2 = charSequence;
                                if (this.fields == null) {
                                    this.fields = new HashSet<String>();
                                }
                                this.fields.add(string3);
                                AstElement astElement = AstElement.createElement(this.info, node3, string4, (String)charSequence2, this);
                                if (astElement != null) {
                                    String string5;
                                    this.checkDocumentation(astElement);
                                    astElement.setKind(ElementKind.PROPERTY);
                                    if (node2 != null && (string5 = AstUtilities.getExpressionType(node2)) != null) {
                                        astElement.setType(string5);
                                    }
                                    this.elements.add(astElement);
                                }
                            }
                        }
                    }
                }
                case 38: {
                    Node node3;
                    Node node4;
                    String string;
                    if (!node.hasChildren()) break;
                    Node node5 = node.getFirstChild();
                    if (node5.getType() == 39) {
                        string = node5.getString();
                        if (!string.equals(JsAnalyzer.NETBEANS_IMPORT_FILE)) break;
                        this.processImports(node5.getNext());
                        break;
                    }
                    if (node5.getType() != 33 || (string = node5.getFirstChild()) == null || string.getType() != 39 || !"YAHOO".equals(string.getString()) || (node4 = string.getNext()) == null || node4.getType() != 41 || !"extend".equals(node4.getString()) || (node3 = node5.getNext()) == null) break;
                    Node node2 = node3.getNext();
                    StringBuilder stringBuilder = new StringBuilder();
                    CharSequence charSequence = new StringBuilder();
                    if (!AstUtilities.addName(stringBuilder, node3) || !AstUtilities.addName((StringBuilder)charSequence, node2)) break;
                    this.addSuperClass(stringBuilder.toString(), ((StringBuilder)charSequence).toString());
                    break;
                }
                case 66: {
                    AstElement astElement;
                    Object object;
                    Object object2;
                    String[] stringArray = AstUtilities.getObjectLitFqn(node);
                    String string = stringArray[0];
                    String string6 = stringArray[1];
                    if (string == null) break;
                    if (string.endsWith(".prototype")) {
                        string = string.substring(0, string.length() - ".prototype".length());
                        object2 = string;
                        object = null;
                        int n = string.lastIndexOf(46);
                        if (n != -1) {
                            object = string.substring(0, n);
                            object2 = string.substring(n + 1);
                        }
                        if ((astElement = AstElement.createElement(this.info, node, (String)object2, (String)object, this)) != null) {
                            this.checkDocumentation(astElement);
                            astElement.setKind(ElementKind.CONSTRUCTOR);
                            this.elements.add(astElement);
                        }
                    }
                    if (string6 != null) {
                        this.addSuperClass(string, string6.toString());
                    }
                    for (object2 = node.getFirstChild(); object2 != null; object2 = object2.getNext()) {
                        String string7;
                        if (object2.getType() != 165 || (object = AstUtilities.getLabelledNode(object2)) == null) continue;
                        if (object.getType() == 108 && ((FunctionNode)object).getFunctionName().length() > 0) break block0;
                        String string8 = object2.getString();
                        astElement = AstElement.createElement(this.info, object, string8, string, this);
                        if (astElement == null) continue;
                        this.checkDocumentation(astElement);
                        if (object.getType() != 108) {
                            astElement.setKind(ElementKind.PROPERTY);
                            string7 = AstUtilities.getExpressionType(object);
                            if (string7 != null) {
                                astElement.setType(string7);
                            }
                        } else if (astElement.getKind() == ElementKind.CONSTRUCTOR) {
                            this.inConstructor = object;
                            string7 = astElement.getIn();
                            if (string7 != null && string7.length() > 0) {
                                astElement.setType(string7);
                            } else {
                                astElement.setType(astElement.getName());
                            }
                        }
                        this.elements.add(astElement);
                    }
                    break;
                }
                case 108: {
                    AstElement astElement;
                    FunctionNode functionNode = (FunctionNode)node;
                    this.currentFunction = functionNode;
                    boolean[] blArray = new boolean[1];
                    String string = AstUtilities.getFunctionFqn(node, blArray);
                    if (string == null || string.length() <= 0) break;
                    String string9 = "";
                    boolean bl = blArray[0];
                    String string10 = string;
                    int n = string.lastIndexOf(46);
                    if (n != -1) {
                        string9 = string.substring(0, n);
                        if (string9.equals("window") || string9.equals("document")) break;
                        if (!Character.isUpperCase(string9.charAt(0))) {
                            bl = true;
                        }
                        string = string.substring(n + 1);
                        if (string9.endsWith(".prototype")) {
                            string9 = string9.substring(0, string9.length() - ".prototype".length());
                        }
                    }
                    if ((astElement = AstElement.createElement(this.info, (Node)functionNode, string, string9, this)) != null) {
                        this.checkDocumentation(astElement);
                        if (!bl) {
                            astElement.markStatic();
                        }
                        this.elements.add(astElement);
                    }
                    if (!Character.isUpperCase(string.charAt(0))) break;
                    astElement.setType(string10);
                    this.inConstructor = functionNode;
                    break;
                }
                case 43: {
                    String string;
                    String string11;
                    StringBuilder stringBuilder;
                    Node node6;
                    Node node7 = node.getParentNode();
                    if (this.inConstructor != null && node7.getType() == 35) {
                        String string12;
                        int n;
                        String string13;
                        Node node8;
                        Node node9;
                        Node node10 = node7;
                        if (node10.getParentNode() == null || node10.getParentNode().getType() != 132) break;
                        for (node9 = node7; node9 != null && node9.getType() != 108; node9 = node9.getParentNode()) {
                        }
                        if (node9 != this.inConstructor || (node8 = node.getNext()) == null || node8.getType() != 41) break;
                        String string14 = node8.getString();
                        Node node11 = node8.getNext();
                        if (node11 != null && node11.getType() == 108 || !Character.isLowerCase(string14.charAt(0)) || (string13 = AstUtilities.getFqn(node, null, null)) == null) break;
                        String string15 = string13 + "." + string14;
                        if (this.fields != null && this.fields.contains(string15) || (n = string13.lastIndexOf(46) + 1) >= string13.length() || !Character.isUpperCase(string13.charAt(n))) break;
                        String string16 = string14;
                        String string17 = string13;
                        if (this.fields == null) {
                            this.fields = new HashSet<String>();
                        }
                        this.fields.add(string15);
                        AstElement astElement = AstElement.createElement(this.info, node8, string16, string17, this);
                        if (astElement == null) break;
                        this.checkDocumentation(astElement);
                        astElement.setKind(ElementKind.PROPERTY);
                        if (node11 != null && (string12 = AstUtilities.getExpressionType(node11)) != null) {
                            astElement.setType(string12);
                        }
                        this.elements.add(astElement);
                        break;
                    }
                    if (this.inConstructor == null || node7.getType() != 38 || (node6 = node7.getFirstChild()).getType() != 33 || !AstUtilities.addName(stringBuilder = new StringBuilder(), node6) || !(string11 = stringBuilder.toString()).endsWith(JsAnalyzer.DOT_CALL) || (string = AstUtilities.getFqn(node7, null, null)) == null) break;
                    String string18 = string11.substring(0, string11.length() - JsAnalyzer.DOT_CALL.length());
                    this.addSuperClass(string, string18.toString());
                    break;
                }
                case 4: {
                    if (this.currentFunction == null || this.currentFunction.nodeType == Node.UNKNOWN_TYPE) break;
                    Node node12 = node.getFirstChild();
                    String string = node12 == null ? "void" : AstUtilities.getExpressionType(node12);
                    if (string == Node.UNKNOWN_TYPE) {
                        this.currentFunction.nodeType = Node.UNKNOWN_TYPE;
                        break;
                    }
                    if (this.currentFunction.nodeType == null) {
                        this.currentFunction.nodeType = string;
                        break;
                    }
                    if (string == null || this.currentFunction.nodeType.indexOf(string) != -1) break;
                    this.currentFunction.nodeType = this.currentFunction.nodeType + "|" + string;
                    break;
                }
                case 174: {
                    Node node13 = node.getFirstChild();
                    if (node13 == null || node13.getType() != 41) break;
                    if (this.e4xStrings == null) {
                        this.e4xStrings = new ArrayList<Node>();
                    }
                    this.e4xStrings.add(node13);
                    break;
                }
            }
            return false;
        }

        @Override
        public boolean unvisit(Node node) {
            if (node.getType() == 108) {
                if (this.currentFunction != null && this.currentFunction.nodeType == null && this.info != null && !this.info.getSnapshot().getSource().getFileObject().getNameExt().startsWith("stub_")) {
                    this.currentFunction.nodeType = "void";
                }
                this.currentFunction = null;
                for (Node node2 = node.getParentNode(); node2 != null; node2 = node2.getParentNode()) {
                    if (node2.getType() != 108) continue;
                    this.currentFunction = node2;
                    break;
                }
            }
            return false;
        }

        private void checkDocumentation(AstElement astElement) {
            Object object;
            if (astElement.in != null && astElement.in.length() > 0) {
                object = this.getNameSpace(astElement.in);
                if (object != null) {
                    astElement.in = (String)object + "." + astElement.in;
                }
            } else if (Character.isUpperCase(astElement.name.charAt(0)) && (object = this.getNameSpace(astElement.name)) != null) {
                astElement.in = object;
            }
            object = astElement.getDocProps();
            if (object != null) {
                String string;
                String string2 = (String)object.get("@extends");
                if (string2 != null) {
                    this.addSuperClass(astElement.name, string2);
                }
                if ((string = (String)object.get("@namespace")) != null) {
                    this.addNameSpace(astElement.name, string);
                    astElement.in = string;
                }
            }
        }

        private void postProcess(JsParseResult jsParseResult) {
            VariableVisitor variableVisitor;
            List<Node> list;
            if (jsParseResult.getRootNode() != null && (list = (variableVisitor = jsParseResult.getVariableVisitor()).getGlobalVars(true)).size() > 0) {
                HashSet<String> hashSet = new HashSet<String>();
                for (Node node : list) {
                    String string = node.getString();
                    if (hashSet.contains(string)) continue;
                    hashSet.add(string);
                    GlobalAstElement globalAstElement = new GlobalAstElement(this.info, node);
                    node.element = globalAstElement;
                    this.elements.add(globalAstElement);
                }
            }
        }

        private void processImports(Node node) {
            if (this.imports == null) {
                this.imports = new ArrayList<String>();
            }
            while (node != null) {
                assert (node.getType() == 41);
                String string = node.getString();
                if (string.indexOf(",") != -1) {
                    String[] stringArray;
                    for (String string2 : stringArray = string.split(",")) {
                        if (string2.startsWith("'") || string2.startsWith("\"")) {
                            this.imports.add(string2.substring(1, string2.length() - 1));
                            continue;
                        }
                        this.imports.add(string2);
                    }
                } else {
                    this.imports.add(string);
                }
                node = node.getNext();
            }
        }

        public List<String> getImports() {
            if (this.imports == null) {
                return Collections.emptyList();
            }
            return this.imports;
        }

        public List<? extends AstElement> getElements() {
            return this.elements;
        }
    }
}

